/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class IpAddressUtil {
    private static final Logger logger = Logger.getLogger(IpAddressUtil.class);

    public static String getFristIPv4() {
        String wanIp = null;
        String lanIp = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            boolean found = false;
            block2: while (!found && netInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> address = netInterfaces.nextElement().getInetAddresses();
                while (address.hasMoreElements()) {
                    InetAddress inetAddress = address.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().contains(":")) continue;
                    if (!inetAddress.isSiteLocalAddress()) {
                        wanIp = inetAddress.getHostAddress();
                        found = true;
                        continue block2;
                    }
                    if (lanIp != null) continue;
                    lanIp = inetAddress.getHostAddress();
                }
            }
        }
        catch (Throwable th) {
            logger.error((Object)"< Get First IPv4 On Error", th);
        }
        if (wanIp != null && !"".equals(wanIp)) {
            return wanIp;
        }
        return lanIp;
    }
}

