/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;

class IdleConnectionCleanThread
extends Thread {
    private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;

    public IdleConnectionCleanThread(HttpClientConnectionManager connMgr) {
        this.setName("idle-connection-monitor");
        this.setDaemon(true);
        this.connMgr = connMgr;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionCleanThread idleConnectionCleanThread = this;
                synchronized (idleConnectionCleanThread) {
                    this.wait(15000L);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IdleConnectionCleanThread idleConnectionCleanThread = this;
        synchronized (idleConnectionCleanThread) {
            this.shutdown = true;
            this.notifyAll();
        }
    }
}

