/*
 * Decompiled with CFR 0.152.
 */
package cn.navigational;

import cn.navigational.annotation.Application;
import cn.navigational.annotation.ScanPackage;
import cn.navigational.annotation.Verticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VertxApplication {
    private String config;
    private final Vertx vertx = Vertx.vertx();
    private final Logger logger = LogManager.getLogger();
    private final DeploymentOptions options = new DeploymentOptions();
    private final List<String> verticle = new ArrayList<String>();
    private String[] packages;
    private JsonObject appConfig = new JsonObject();

    public void init() {
        FileSystem fs = this.vertx.fileSystem();
        Application app = this.getClass().getDeclaredAnnotation(Application.class);
        ScanPackage scanPackage = this.getClass().getDeclaredAnnotation(ScanPackage.class);
        if (app != null) {
            this.config = app.config();
        }
        if (scanPackage != null) {
            this.packages = scanPackage.packages();
        }
        if (this.config != null) {
            this.appConfig = fs.readFileBlocking(this.config).toJsonObject();
        }
        if (this.packages == null || this.packages.length == 0) {
            this.logger.warn("No packages need to be scanned");
            this.packages = new String[0];
        }
        this.scanPackage(this.packages);
        this.options.setConfig(this.appConfig);
        if (!this.verticle.isEmpty()) {
            this.verticle.forEach(_clazz -> {
                this.logger.info("start deploy {}", _clazz);
                this.vertx.deployVerticle(_clazz, this.options, _rs -> {
                    if (_rs.succeeded()) {
                        this.logger.info("{} deployment success!", _clazz);
                    } else {
                        _rs.cause().printStackTrace();
                        this.logger.error("{} deployment failed:{}", _clazz, (Object)_rs.cause().getMessage());
                    }
                });
            });
        }
    }

    private void scanPackage(String ... pack) {
        if (pack.length == 0) {
            return;
        }
        for (String path : pack) {
            try {
                Enumeration<URL> clazz = this.getClass().getClassLoader().getResources(path.replaceAll("\\.", "/"));
                while (clazz.hasMoreElements()) {
                    URL url = clazz.nextElement();
                    if (url == null) continue;
                    if (url.getProtocol().equals("file")) {
                        this.logger.info("scan type {}", (Object)"FileSystem");
                        String packagePath = URLDecoder.decode(url.getFile(), String.valueOf(StandardCharsets.UTF_8));
                        this.addClass(packagePath, path);
                        continue;
                    }
                    this.logger.info("scan type:{}", (Object)"jar");
                    this.verticle.addAll(this.scanClassFromJar(url, path));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error("scan package failed:{}", (Object)e.getCause().getMessage());
            }
        }
    }

    private List<String> scanClassFromJar(URL url, String path) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        if (Objects.nonNull(jarURLConnection) && Objects.nonNull(jarURLConnection.getJarFile())) {
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String className;
                boolean cl;
                JarEntry jarEntry = entries.nextElement();
                String jarEntryName = jarEntry.getName();
                String prefix = jarEntryName.replaceAll("/", "\\.");
                if (!prefix.startsWith(path) || !jarEntryName.endsWith(".class") || !(cl = this.isFitClass(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "\\.")))) continue;
                this.logger.info(className);
                list.add(className);
            }
        }
        return list;
    }

    private void addClass(String packPath, String packName) {
        File[] files = new File(packPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isFile() && name.endsWith(".class") || dir.isDirectory();
            }
        });
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (file.isFile()) {
                String className = packName + "." + fileName.split("\\.")[0];
                boolean clazz = this.isFitClass(className);
                if (!clazz) continue;
                this.verticle.add(className);
                continue;
            }
            String subPath = packPath + File.separator + fileName;
            String subPackage = packName + "." + fileName;
            this.addClass(subPath, subPackage);
        }
    }

    private boolean isFitClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz.getDeclaredAnnotation(Verticle.class) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error("class {} not found!", (Object)className);
        }
        return false;
    }

    public VertxApplication setConfig(String config) {
        this.config = config;
        return this;
    }

    public DeploymentOptions getOptions() {
        return this.options;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String ... packages) {
        this.packages = packages;
    }

    public JsonObject getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(JsonObject appConfig) {
        this.appConfig = appConfig;
    }
}

