/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.plugin.security.realm;

import cn.naturemix.plugin.security.NaturemixSecurity;
import cn.naturemix.plugin.security.password.Md5CredentialsMatcher;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;

public class NaturemixCustomRealm
extends AuthorizingRealm {
    private final NaturemixSecurity naturemixSecurity;

    public NaturemixCustomRealm(NaturemixSecurity naturemixSecurity) {
        this.naturemixSecurity = naturemixSecurity;
        super.setName("custom");
        super.setCredentialsMatcher((CredentialsMatcher)new Md5CredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (token == null) {
            throw new AuthenticationException("parameter token is null");
        }
        String username = ((UsernamePasswordToken)token).getUsername();
        String password = this.naturemixSecurity.getPassword(username);
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo();
        authenticationInfo.setPrincipals((PrincipalCollection)new SimplePrincipalCollection((Object)username, super.getName()));
        authenticationInfo.setCredentials((Object)password);
        return authenticationInfo;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("parameter principals is null");
        }
        String username = (String)super.getAvailablePrincipal(principals);
        Set<String> roleNameSet = this.naturemixSecurity.getRoleNameSet(username);
        HashSet<String> permissionNameSet = new HashSet<String>();
        if (roleNameSet != null && roleNameSet.size() > 0) {
            for (String roleName : roleNameSet) {
                Set<String> currentPermissionNameSet = this.naturemixSecurity.getPermissionNameSet(roleName);
                permissionNameSet.addAll(currentPermissionNameSet);
            }
        }
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        authorizationInfo.setRoles(roleNameSet);
        authorizationInfo.setStringPermissions(permissionNameSet);
        return authorizationInfo;
    }
}

