/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.plugin.security.aspect;

import cn.naturemix.framework.annotation.Aspect;
import cn.naturemix.framework.annotation.Controller;
import cn.naturemix.plugin.security.annotation.User;
import cn.naturemix.plugin.security.exception.AuthzException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;

@Aspect(value=Controller.class)
public class AuthzAnnotationAspect {
    public static final Class[] ANNOTATION_CLASS_ARRAY = new Class[]{User.class};

    public void before(Class<?> cls, Method method, Object[] params) throws Throwable {
        Class<? extends Annotation> annotationType;
        Annotation annotation = this.getAnnotation(cls, method);
        if (annotation != null && (annotationType = annotation.annotationType()).equals(User.class)) {
            this.handleUser();
        }
    }

    private Annotation getAnnotation(Class<?> cls, Method method) {
        for (Class annotationClass : ANNOTATION_CLASS_ARRAY) {
            if (method.isAnnotationPresent(annotationClass)) {
                return method.getAnnotation(annotationClass);
            }
            if (!cls.isAnnotationPresent(annotationClass)) continue;
            return cls.getAnnotation(annotationClass);
        }
        return null;
    }

    private void handleUser() {
        Subject currentUser = SecurityUtils.getSubject();
        PrincipalCollection principals = currentUser.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            throw new AuthzException("\u5f53\u524d\u7528\u6237\u5c1a\u672a\u767b\u9646");
        }
    }
}

