/*
 * Decompiled with CFR 0.152.
 */
package cn.naturemix.plugin.security;

import cn.naturemix.plugin.security.NaturemixSecurity;
import cn.naturemix.plugin.security.SecurityConfig;
import cn.naturemix.plugin.security.realm.NaturemixCustomRealm;
import cn.naturemix.plugin.security.realm.NaturemixJdbcRealm;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.CachingSecurityManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroFilter;

public class NaturemixSercurityFilter
extends ShiroFilter {
    public void init() throws Exception {
        WebSecurityManager webSecurityManager = super.getSecurityManager();
        this.setReaml(webSecurityManager);
        this.setCache(webSecurityManager);
    }

    private void setReaml(WebSecurityManager webSecurityManager) {
        String[] securityRealmArray;
        String securityReamls = SecurityConfig.getRealms();
        if (securityReamls != null && (securityRealmArray = securityReamls.split(",")).length > 0) {
            LinkedHashSet<Realm> realms = new LinkedHashSet<Realm>();
            for (String securityRealm : securityRealmArray) {
                if (securityRealm.equalsIgnoreCase("jdbc")) {
                    this.addJdbcReaml(realms);
                    continue;
                }
                if (!securityRealm.equalsIgnoreCase("custom")) continue;
                this.addCustomReaml(realms);
            }
            RealmSecurityManager realmSecurityManager = (RealmSecurityManager)webSecurityManager;
            realmSecurityManager.setRealms(realms);
        }
    }

    private void addJdbcReaml(Set<Realm> realms) {
        NaturemixJdbcRealm naturemixJdbcRealm = new NaturemixJdbcRealm();
        realms.add((Realm)naturemixJdbcRealm);
    }

    private void addCustomReaml(Set<Realm> realms) {
        NaturemixSecurity naturemixSecurity = SecurityConfig.getNaturemixSecurity();
        NaturemixCustomRealm naturemixCustomRealm = new NaturemixCustomRealm(naturemixSecurity);
        realms.add((Realm)naturemixCustomRealm);
    }

    private void setCache(WebSecurityManager webSecurityManager) {
        if (SecurityConfig.isCache()) {
            CachingSecurityManager cachingSecurityManager = (CachingSecurityManager)webSecurityManager;
            MemoryConstrainedCacheManager cacheManager = new MemoryConstrainedCacheManager();
            cachingSecurityManager.setCacheManager((CacheManager)cacheManager);
        }
    }
}

