/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.luaj.vm2.Globals;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class LuajContext
extends SimpleScriptContext
implements ScriptContext {
    public final Globals globals;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public LuajContext() {
        this("true".equals(System.getProperty("org.luaj.debug")), "true".equals(System.getProperty("org.luaj.luajc")));
    }

    public LuajContext(boolean createDebugGlobals, boolean useLuaJCCompiler) {
        Globals globals = this.globals = createDebugGlobals ? JsePlatform.debugGlobals() : JsePlatform.standardGlobals();
        if (useLuaJCCompiler) {
            LuaJC.install(this.globals);
        }
        this.stdin = this.globals.STDIN;
        this.stdout = this.globals.STDOUT;
        this.stderr = this.globals.STDERR;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.globals.STDERR = writer != null ? new PrintStream(new WriterOutputStream(writer)) : this.stderr;
    }

    @Override
    public void setReader(Reader reader) {
        this.globals.STDIN = reader != null ? new ReaderInputStream(reader) : this.stdin;
    }

    @Override
    public void setWriter(Writer writer) {
        this.globals.STDOUT = writer != null ? new PrintStream(new WriterOutputStream(writer), true) : this.stdout;
    }

    static final class ReaderInputStream
    extends InputStream {
        final Reader r;

        ReaderInputStream(Reader r) {
            this.r = r;
        }

        @Override
        public int read() throws IOException {
            return this.r.read();
        }
    }

    static final class WriterOutputStream
    extends OutputStream {
        final Writer w;

        WriterOutputStream(Writer w) {
            this.w = w;
        }

        @Override
        public void write(int b) throws IOException {
            this.w.write(new String(new byte[]{(byte)b}));
        }

        @Override
        public void write(byte[] b, int o, int l) throws IOException {
            this.w.write(new String(b, o, l));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.w.write(new String(b));
        }

        @Override
        public void close() throws IOException {
            this.w.close();
        }

        @Override
        public void flush() throws IOException {
            this.w.flush();
        }
    }
}

