/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.UpvalInfo;
import org.luaj.vm2.luajc.VarInfo;

public class ProtoInfo {
    public final String name;
    public final Prototype prototype;
    public final ProtoInfo[] subprotos;
    public final BasicBlock[] blocks;
    public final BasicBlock[] blocklist;
    public final VarInfo[] params;
    public final VarInfo[][] vars;
    public final UpvalInfo[] upvals;
    public final UpvalInfo[][] openups;

    public ProtoInfo(Prototype p, String name) {
        this(p, name, null);
    }

    private ProtoInfo(Prototype p, String name, UpvalInfo[] u) {
        UpvalInfo[] upvalInfoArray;
        this.name = name;
        this.prototype = p;
        if (u != null) {
            upvalInfoArray = u;
        } else {
            UpvalInfo[] upvalInfoArray2 = new UpvalInfo[1];
            upvalInfoArray = upvalInfoArray2;
            upvalInfoArray2[0] = new UpvalInfo(this);
        }
        this.upvals = upvalInfoArray;
        this.subprotos = p.p != null && p.p.length > 0 ? new ProtoInfo[p.p.length] : null;
        this.blocks = BasicBlock.findBasicBlocks(p);
        this.blocklist = BasicBlock.findLiveBlocks(this.blocks);
        this.params = new VarInfo[p.maxstacksize];
        for (int slot = 0; slot < p.maxstacksize; ++slot) {
            VarInfo v;
            this.params[slot] = v = VarInfo.PARAM(slot);
        }
        this.vars = this.findVariables();
        this.replaceTrivialPhiVariables();
        this.openups = new UpvalInfo[p.maxstacksize][];
        this.findUpvalues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int i;
        int n;
        StringBuffer sb = new StringBuffer();
        sb.append("proto '" + this.name + "'\n");
        int n2 = n = this.upvals != null ? this.upvals.length : 0;
        for (i = 0; i < n; ++i) {
            sb.append(" up[" + i + "]: " + this.upvals[i] + "\n");
        }
        for (i = 0; i < this.blocklist.length; ++i) {
            BasicBlock b = this.blocklist[i];
            int pc0 = b.pc0;
            sb.append("  block " + b.toString());
            this.appendOpenUps(sb, -1);
            for (int pc = pc0; pc <= b.pc1; ++pc) {
                this.appendOpenUps(sb, pc);
                sb.append("     ");
                for (int j = 0; j < this.prototype.maxstacksize; ++j) {
                    VarInfo v = this.vars[j][pc];
                    String u = v == null ? "" : (v.upvalue != null ? (!v.upvalue.rw ? "[C] " : (v.allocupvalue && v.pc == pc ? "[*] " : "[]  ")) : "    ");
                    String s = v == null ? "null   " : String.valueOf(v);
                    sb.append(s + u);
                }
                sb.append("  ");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ops = Print.ps;
                Print.ps = new PrintStream(baos);
                try {
                    Print.printOpCode(this.prototype, pc);
                }
                finally {
                    Print.ps.close();
                    Print.ps = ops;
                }
                sb.append(baos.toString());
                sb.append("\n");
            }
        }
        int n3 = n = this.subprotos != null ? this.subprotos.length : 0;
        for (i = 0; i < n; ++i) {
            sb.append(this.subprotos[i].toString());
        }
        return sb.toString();
    }

    private void appendOpenUps(StringBuffer sb, int pc) {
        for (int j = 0; j < this.prototype.maxstacksize; ++j) {
            VarInfo v;
            VarInfo varInfo = v = pc < 0 ? this.params[j] : this.vars[j][pc];
            if (v == null || v.pc != pc || !v.allocupvalue) continue;
            sb.append("    open: " + v.upvalue + "\n");
        }
    }

    private VarInfo[][] findVariables() {
        int n = this.prototype.code.length;
        int m = this.prototype.maxstacksize;
        VarInfo[][] v = new VarInfo[m][];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new VarInfo[n];
        }
        for (int bi = 0; bi < this.blocklist.length; ++bi) {
            BasicBlock b0 = this.blocklist[bi];
            int nprev = b0.prev != null ? b0.prev.length : 0;
            for (int slot = 0; slot < m; ++slot) {
                VarInfo var = null;
                if (nprev == 0) {
                    var = this.params[slot];
                } else if (nprev == 1) {
                    var = v[slot][b0.prev[0].pc1];
                } else {
                    for (int i = 0; i < nprev; ++i) {
                        BasicBlock bp = b0.prev[i];
                        if (v[slot][bp.pc1] != VarInfo.INVALID) continue;
                        var = VarInfo.INVALID;
                    }
                }
                if (var == null) {
                    var = VarInfo.PHI(this, slot, b0.pc0);
                }
                v[slot][b0.pc0] = var;
            }
            block29: for (int pc = b0.pc0; pc <= b0.pc1; ++pc) {
                if (pc > b0.pc0) {
                    ProtoInfo.propogateVars(v, pc - 1, pc);
                }
                int ins = this.prototype.code[pc];
                int op = Lua.GET_OPCODE(ins);
                switch (op) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 11: {
                        int a = Lua.GETARG_A(ins);
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 0: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 28: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        v[b][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        if (!Lua.ISK(b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (!Lua.ISK(c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 10: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        v[a][pc].isreferenced = true;
                        if (!Lua.ISK(b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK(c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 8: {
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        if (!Lua.ISK(b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK(c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 22: {
                        int b;
                        int a = Lua.GETARG_A(ins);
                        int c = Lua.GETARG_C(ins);
                        for (b = Lua.GETARG_B(ins); b <= c; ++b) {
                            v[b][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 33: {
                        int a = Lua.GETARG_A(ins);
                        v[a + 2][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 7: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        v[b][pc].isreferenced = true;
                        if (!Lua.ISK(c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 6: {
                        int a = Lua.GETARG_A(ins);
                        int c = Lua.GETARG_C(ins);
                        if (!Lua.ISK(c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 12: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        v[b][pc].isreferenced = true;
                        if (!Lua.ISK(c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        v[a + 1][pc] = new VarInfo(a + 1, pc);
                        continue block29;
                    }
                    case 32: {
                        int a = Lua.GETARG_A(ins);
                        v[a][pc].isreferenced = true;
                        v[a + 2][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        v[a][pc].isreferenced = true;
                        v[a + 1][pc].isreferenced = true;
                        v[a + 3][pc] = new VarInfo(a + 3, pc);
                        continue block29;
                    }
                    case 4: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        while (b-- >= 0) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++a;
                        }
                        continue block29;
                    }
                    case 38: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int j = 1;
                        while (j < b) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        if (b != 0) continue block29;
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 29: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        v[a][pc].isreferenced = true;
                        v[a][pc].isreferenced = true;
                        for (int i = 1; i <= b - 1; ++i) {
                            v[a + i][pc].isreferenced = true;
                        }
                        int j = 0;
                        while (j <= c - 2) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 34: {
                        int a = Lua.GETARG_A(ins);
                        int c = Lua.GETARG_C(ins);
                        v[a++][pc].isreferenced = true;
                        v[a++][pc].isreferenced = true;
                        v[a++][pc].isreferenced = true;
                        int j = 0;
                        while (j < c) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 35: {
                        int a = Lua.GETARG_A(ins);
                        v[a + 1][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 30: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        v[a][pc].isreferenced = true;
                        for (int i = 1; i <= b - 1; ++i) {
                            v[a + i][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 31: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        for (int i = 0; i <= b - 2; ++i) {
                            v[a + i][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 37: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_Bx(ins);
                        Upvaldesc[] upvalues = this.prototype.p[b].upvalues;
                        int nups = upvalues.length;
                        for (int k = 0; k < nups; ++k) {
                            if (!upvalues[k].instack) continue;
                            v[upvalues[k].idx][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 36: {
                        int a = Lua.GETARG_A(ins);
                        int b = Lua.GETARG_B(ins);
                        v[a][pc].isreferenced = true;
                        for (int i = 1; i <= b; ++i) {
                            v[a + i][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 9: 
                    case 27: {
                        int a = Lua.GETARG_A(ins);
                        v[a][pc].isreferenced = true;
                        continue block29;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        int b = Lua.GETARG_B(ins);
                        int c = Lua.GETARG_C(ins);
                        if (!Lua.ISK(b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK(c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 23: {
                        int a = Lua.GETARG_A(ins);
                        if (a <= 0) continue block29;
                        --a;
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    default: {
                        throw new IllegalStateException("unhandled opcode: " + ins);
                    }
                }
            }
        }
        return v;
    }

    private static void propogateVars(VarInfo[][] v, int pcfrom, int pcto) {
        int m = v.length;
        for (int j = 0; j < m; ++j) {
            v[j][pcto] = v[j][pcfrom];
        }
    }

    private void replaceTrivialPhiVariables() {
        for (int i = 0; i < this.blocklist.length; ++i) {
            BasicBlock b0 = this.blocklist[i];
            for (int slot = 0; slot < this.prototype.maxstacksize; ++slot) {
                VarInfo vold = this.vars[slot][b0.pc0];
                VarInfo vnew = vold.resolvePhiVariableValues();
                if (vnew == null) continue;
                this.substituteVariable(slot, vold, vnew);
            }
        }
    }

    private void substituteVariable(int slot, VarInfo vold, VarInfo vnew) {
        int n = this.prototype.code.length;
        for (int i = 0; i < n; ++i) {
            this.replaceAll(this.vars[slot], this.vars[slot].length, vold, vnew);
        }
    }

    private void replaceAll(VarInfo[] v, int n, VarInfo vold, VarInfo vnew) {
        for (int i = 0; i < n; ++i) {
            if (v[i] != vold) continue;
            v[i] = vnew;
        }
    }

    private void findUpvalues() {
        int pc;
        int[] code = this.prototype.code;
        int n = code.length;
        String[] names = this.findInnerprotoNames();
        for (pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE(code[pc]) != 37) continue;
            int bx = Lua.GETARG_Bx(code[pc]);
            Prototype newp = this.prototype.p[bx];
            UpvalInfo[] newu = new UpvalInfo[newp.upvalues.length];
            String newname = this.name + "$" + names[bx];
            for (int j = 0; j < newp.upvalues.length; ++j) {
                Upvaldesc u = newp.upvalues[j];
                newu[j] = u.instack ? this.findOpenUp(pc, u.idx) : this.upvals[u.idx];
            }
            this.subprotos[bx] = new ProtoInfo(newp, newname, newu);
        }
        for (pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE(code[pc]) != 9) continue;
            this.upvals[Lua.GETARG_B((int)code[pc])].rw = true;
        }
    }

    private UpvalInfo findOpenUp(int pc, int slot) {
        if (this.openups[slot] == null) {
            this.openups[slot] = new UpvalInfo[this.prototype.code.length];
        }
        if (this.openups[slot][pc] != null) {
            return this.openups[slot][pc];
        }
        UpvalInfo u = new UpvalInfo(this, pc, slot);
        int n = this.prototype.code.length;
        for (int i = 0; i < n; ++i) {
            if (this.vars[slot][i] == null || this.vars[slot][i].upvalue != u) continue;
            this.openups[slot][i] = u;
        }
        return u;
    }

    public boolean isUpvalueAssign(int pc, int slot) {
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw;
    }

    public boolean isUpvalueCreate(int pc, int slot) {
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw && v.allocupvalue && pc == v.pc;
    }

    public boolean isUpvalueRefer(int pc, int slot) {
        if (pc > 0 && this.vars[slot][pc] != null && this.vars[slot][pc].pc == pc && this.vars[slot][pc - 1] != null) {
            --pc;
        }
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw;
    }

    public boolean isInitialValueUsed(int slot) {
        VarInfo v = this.params[slot];
        return v.isreferenced;
    }

    public boolean isReadWriteUpvalue(UpvalInfo u) {
        return u.rw;
    }

    private String[] findInnerprotoNames() {
        if (this.prototype.p.length <= 0) {
            return null;
        }
        String[] names = new String[this.prototype.p.length];
        Hashtable<String, Boolean> used = new Hashtable<String, Boolean>();
        int[] code = this.prototype.code;
        int n = code.length;
        for (int pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE(code[pc]) != 37) continue;
            int bx = Lua.GETARG_Bx(code[pc]);
            String name = null;
            int i = code[pc + 1];
            switch (Lua.GET_OPCODE(i)) {
                case 8: 
                case 10: {
                    int b = Lua.GETARG_B(i);
                    if (!Lua.ISK(b)) break;
                    name = this.prototype.k[b & 0xFF].tojstring();
                    break;
                }
                case 9: {
                    int b = Lua.GETARG_B(i);
                    LuaString s = this.prototype.upvalues[b].name;
                    if (s == null) break;
                    name = s.tojstring();
                    break;
                }
                default: {
                    int a = Lua.GETARG_A(code[pc]);
                    LuaString s = this.prototype.getlocalname(a + 1, pc + 1);
                    if (s == null) break;
                    name = s.tojstring();
                }
            }
            String string = name = name != null ? ProtoInfo.toJavaClassPart(name) : String.valueOf(bx);
            if (used.containsKey(name)) {
                String basename = name;
                int count = 1;
                while (used.containsKey(name = basename + '$' + count++)) {
                }
            }
            used.put(name, Boolean.TRUE);
            names[bx] = name;
        }
        return names;
    }

    private static String toJavaClassPart(String s) {
        int n = s.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sb.append(Character.isJavaIdentifierPart(s.charAt(i)) ? s.charAt(i) : (char)'_');
        }
        return sb.toString();
    }
}

