/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaClass;

public class LuajavaLib
extends VarArgFunction {
    static final int INIT = 0;
    static final int BINDCLASS = 1;
    static final int NEWINSTANCE = 2;
    static final int NEW = 3;
    static final int CREATEPROXY = 4;
    static final int LOADLIB = 5;
    static final int ASTABLE = 6;
    static final String[] NAMES = new String[]{"bindClass", "newInstance", "new", "createProxy", "loadLib", "astable"};
    static final int METHOD_MODIFIERS_VARARGS = 128;

    @Override
    public Varargs invoke(Varargs args) {
        try {
            switch (this.opcode) {
                case 0: {
                    final LuaValue env = args.arg(2);
                    LuaTable t = new LuaTable();
                    this.bind(t, this.getClass(), NAMES, 1);
                    env.set("luajava", (LuaValue)t);
                    env.get("package").get("loaded").set("luajava", (LuaValue)t);
                    env.set("byte", (LuaValue)JavaClass.forClass(Byte.TYPE));
                    env.set("char", (LuaValue)JavaClass.forClass(Character.TYPE));
                    env.set("short", (LuaValue)JavaClass.forClass(Short.TYPE));
                    env.set("int", (LuaValue)JavaClass.forClass(Integer.TYPE));
                    env.set("long", (LuaValue)JavaClass.forClass(Long.TYPE));
                    env.set("float", (LuaValue)JavaClass.forClass(Float.TYPE));
                    env.set("double", (LuaValue)JavaClass.forClass(Double.TYPE));
                    env.set("import", (LuaValue)new VarArgFunction(){

                        @Override
                        public Varargs invoke(Varargs args) {
                            try {
                                String cls = args.checkjstring(1);
                                String n = cls.replaceFirst(".*?[$\\.]([^$\\.]*)$", "$1");
                                Class<?> clazz = LuajavaLib.this.classForName(cls);
                                JavaClass ls = JavaClass.forClass(clazz);
                                env.set(n, (LuaValue)ls);
                                return ls;
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                                throw new LuaError(e);
                            }
                        }
                    });
                    return t;
                }
                case 1: {
                    Class<?> clazz = this.classForName(args.checkjstring(1));
                    return JavaClass.forClass(clazz);
                }
                case 2: 
                case 3: {
                    LuaValue c = args.checkvalue(1);
                    Class clazz = this.opcode == 2 ? this.classForName(c.tojstring()) : (Class)c.checkuserdata(Class.class);
                    Varargs consargs = args.subargs(2);
                    return JavaClass.forClass(clazz).getConstructor().invoke(consargs);
                }
                case 4: {
                    int niface = args.narg() - 1;
                    if (niface <= 0) {
                        throw new LuaError("no interfaces");
                    }
                    LuaTable lobj = args.checktable(niface + 1);
                    Class[] ifaces = new Class[niface];
                    for (int i = 0; i < niface; ++i) {
                        ifaces[i] = this.classForName(args.checkjstring(i + 1));
                    }
                    ProxyInvocationHandler handler = new ProxyInvocationHandler(lobj);
                    Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces, (InvocationHandler)handler);
                    return LuaValue.userdataOf(proxy);
                }
                case 5: {
                    String classname = args.checkjstring(1);
                    String methodname = args.checkjstring(2);
                    Class<?> clazz = this.classForName(classname);
                    Method method = clazz.getMethod(methodname, new Class[0]);
                    Object result = method.invoke(clazz, new Object[0]);
                    if (result instanceof LuaValue) {
                        return (LuaValue)result;
                    }
                    return NIL;
                }
                case 6: {
                    return LuajavaLib.asTable(args.checkuserdata(1));
                }
            }
            throw new LuaError("not yet supported: " + this);
        }
        catch (LuaError e) {
            throw e;
        }
        catch (InvocationTargetException ite) {
            throw new LuaError(ite.getTargetException());
        }
        catch (Exception e) {
            throw new LuaError(e);
        }
    }

    public static LuaValue asTable(boolean dep, Object obj) {
        if (dep) {
            return LuajavaLib.asTable(obj);
        }
        LuaTable tab = new LuaTable();
        if (obj.getClass().isArray()) {
            int n = Array.getLength(obj);
            for (int i = 0; i <= n - 1; ++i) {
                tab.set(i + 1, CoerceJavaToLua.coerce(Array.get(obj, i)));
            }
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            int i = 1;
            for (Object v : list) {
                tab.set(i + 1, CoerceJavaToLua.coerce(v));
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i.next();
                tab.set(CoerceJavaToLua.coerce(entry.getKey()), CoerceJavaToLua.coerce(entry.getValue()));
            }
        } else if (obj instanceof JSONObject) {
            JSONObject map = (JSONObject)obj;
            Iterator<String> keys = map.keys();
            while (keys.hasNext()) {
                String k = keys.next();
                try {
                    tab.set(k, CoerceJavaToLua.coerce(map.get(k)));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else if (obj instanceof JSONArray) {
            JSONArray map = (JSONArray)obj;
            int len2 = map.length();
            for (int i = 0; i < len2; ++i) {
                try {
                    tab.set(i, CoerceJavaToLua.coerce(map.get(i)));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else {
            return CoerceJavaToLua.coerce(obj);
        }
        return tab;
    }

    public static LuaValue asTable(Object obj) {
        LuaTable tab = new LuaTable();
        if (obj.getClass().isArray()) {
            int n = Array.getLength(obj);
            for (int i = 0; i <= n - 1; ++i) {
                tab.set(i + 1, LuajavaLib.asTable(Array.get(obj, i)));
            }
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            int i = 1;
            for (Object v : list) {
                tab.set(i++, LuajavaLib.asTable(v));
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i.next();
                tab.set(CoerceJavaToLua.coerce(entry.getKey()), LuajavaLib.asTable(entry.getValue()));
            }
        } else if (obj instanceof JSONObject) {
            JSONObject map = (JSONObject)obj;
            Iterator<String> keys = map.keys();
            while (keys.hasNext()) {
                String k = keys.next();
                try {
                    tab.set(k, LuajavaLib.asTable(map.get(k)));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else if (obj instanceof JSONArray) {
            JSONArray map = (JSONArray)obj;
            int len2 = map.length();
            for (int i = 0; i < len2; ++i) {
                try {
                    tab.set(i, LuajavaLib.asTable(map.get(i)));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else {
            return CoerceJavaToLua.coerce(obj);
        }
        return tab;
    }

    public static LuaUserdata createProxy(Class clazz, LuaValue lobj) {
        Class[] ifaces = new Class[]{clazz};
        ProxyInvocationHandler handler = new ProxyInvocationHandler(lobj);
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), ifaces, (InvocationHandler)handler);
        return LuaValue.userdataOf(proxy);
    }

    protected Class<?> classForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public static JavaClass bindClassForName(String name) throws ClassNotFoundException {
        return JavaClass.forClass(Class.forName(name));
    }

    private static final class ProxyInvocationHandler
    implements InvocationHandler {
        private final LuaValue lobj;

        private ProxyInvocationHandler(LuaValue lobj) {
            this.lobj = lobj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LuaValue[] v;
            int n;
            String name = method.getName();
            LuaValue func = this.lobj.isfunction() ? this.lobj : this.lobj.get(name);
            if (func.isnil()) {
                return null;
            }
            boolean isvarargs = (method.getModifiers() & 0x80) != 0;
            int n2 = n = args != null ? args.length : 0;
            if (isvarargs) {
                int i;
                Object o = args[--n];
                int m = Array.getLength(o);
                v = new LuaValue[n + m];
                for (i = 0; i < n; ++i) {
                    v[i] = CoerceJavaToLua.coerce(args[i]);
                }
                for (i = 0; i < m; ++i) {
                    v[i + n] = CoerceJavaToLua.coerce(Array.get(o, i));
                }
            } else {
                v = new LuaValue[n];
                for (int i = 0; i < n; ++i) {
                    v[i] = CoerceJavaToLua.coerce(args[i]);
                }
            }
            try {
                LuaValue result = func.invoke(v).arg1();
                return CoerceLuaToJava.coerce(result, method.getReturnType());
            }
            catch (Exception e) {
                return CoerceLuaToJava.coerce(LuaValue.NIL, method.getReturnType());
            }
        }
    }
}

