/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaMember;

class JavaMethod
extends JavaMember {
    static final Map methods = Collections.synchronizedMap(new HashMap());
    private final Class<?> returnType;
    final Method method;

    static JavaMethod forMethod(Method m) {
        JavaMethod j = (JavaMethod)methods.get(m);
        if (j == null) {
            j = new JavaMethod(m);
            methods.put(m, j);
        }
        return j;
    }

    static LuaFunction forMethods(JavaMethod[] m) {
        return new Overload(m);
    }

    private JavaMethod(Method m) {
        super(m.getParameterTypes(), m.getModifiers());
        this.method = m;
        this.returnType = m.getReturnType();
        try {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public LuaValue call() {
        return this.invokeMethod(this.uservalue.touserdata(), LuaValue.NONE);
    }

    @Override
    public LuaValue call(LuaValue arg) {
        return this.invokeMethod(this.uservalue.touserdata(), arg);
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        return this.invokeMethod(this.uservalue.touserdata(), LuaValue.varargsOf(arg1, (Varargs)arg2));
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        return this.invokeMethod(this.uservalue.touserdata(), LuaValue.varargsOf(arg1, arg2, arg3));
    }

    @Override
    public Varargs invoke(LuaValue[] args) {
        return this.invoke(LuaValue.varargsOf(args));
    }

    @Override
    public Varargs invoke(Varargs args) {
        return this.invokeMethod(this.uservalue.touserdata(), args);
    }

    LuaValue invokeMethod(Object instance, Varargs args) {
        Object[] a = this.convertArgs(args);
        try {
            if (this.returnType == Void.TYPE) {
                this.method.invoke(instance, a);
                return this.uservalue;
            }
            return CoerceJavaToLua.coerce(this.method.invoke(instance, a));
        }
        catch (InvocationTargetException e) {
            throw new LuaError(e.getTargetException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return LuaValue.error("coercion error " + e);
        }
    }

    static class Overload
    extends LuaFunction {
        final JavaMethod[] methods;

        Overload(JavaMethod[] methods) {
            this.methods = methods;
        }

        @Override
        public LuaValue call() {
            return this.invokeBestMethod(this.uservalue.touserdata(), LuaValue.NONE);
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return this.invokeBestMethod(this.uservalue.touserdata(), arg);
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return this.invokeBestMethod(this.uservalue.touserdata(), LuaValue.varargsOf(arg1, (Varargs)arg2));
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            return this.invokeBestMethod(this.uservalue.touserdata(), LuaValue.varargsOf(arg1, arg2, arg3));
        }

        @Override
        public Varargs invoke(LuaValue[] args) {
            return this.invoke(LuaValue.varargsOf(args));
        }

        @Override
        public Varargs invoke(Varargs args) {
            return this.invokeBestMethod(this.uservalue.touserdata(), args);
        }

        private LuaValue invokeBestMethod(Object instance, Varargs args) {
            LuaValue best = null;
            int score = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (int i = 0; i < this.methods.length; ++i) {
                int s = this.methods[i].score(args);
                if (s >= score) continue;
                score = s;
                best = this.methods[i];
                if (score == 0) break;
            }
            if (best == null) {
                LuaValue.error("no coercible public method");
            }
            best.setuservalue(this.uservalue);
            return ((JavaMethod)best).invokeMethod(instance, args);
        }
    }
}

