/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaClass;
import org.luaj.vm2.lib.jse.JavaMethod;
import org.luaj.vm2.lib.jse.LuajavaLib;

class JavaInstance
extends LuaUserdata {
    JavaClass jclass;
    private static final int TYPE_GETFILED = 1;
    private static final int TYPE_METHOD = 2;
    private static final int TYPE_CLASS = 3;
    private static final int TYPE_GETTER = 4;
    private static final int TYPE_GETVALUE = 5;
    private static final int TYPE_SETFIELD = 6;
    private static final int TYPE_SETTER = 7;
    private static final int TYPE_SETVALUE = 8;
    private static final int TYPE_SETLISTENER = 9;
    private static HashMap<JavaInstance, HashMap<LuaValue, LuaValue>> values = new HashMap();
    private HashMap<LuaValue, LuaValue> vs;
    static final LuaValue CLASS = JavaInstance.valueOf("class");

    JavaInstance(Object instance) {
        super(instance);
    }

    @Override
    public LuaValue call(LuaValue arg) {
        if (arg.istable()) {
            Varargs next2;
            LuaValue key = LuaValue.NIL;
            while (!(next2 = arg.next(key)).isnil(1)) {
                key = next2.arg1();
                this.set(key, next2.arg(2));
            }
            return this;
        }
        return super.call(arg);
    }

    @Override
    public Varargs invoke(Varargs args) {
        LuaValue arg;
        if (args.narg() == 1 && (arg = args.arg1()).istable()) {
            Varargs next2;
            LuaValue key = LuaValue.NIL;
            while (!(next2 = arg.next(key)).isnil(1)) {
                key = next2.arg1();
                this.set(key, next2.arg(2));
            }
            return this;
        }
        return super.invoke(args);
    }

    @Override
    public Varargs next(LuaValue index) {
        if (this.m_instance instanceof Map) {
            Map map = (Map)this.m_instance;
            Set sets = map.keySet();
            Object key = CoerceLuaToJava.coerce(index, Object.class);
            for (Object set : sets) {
                if (key != null && !key.equals(set)) continue;
                return LuaValue.varargsOf(new LuaValue[]{CoerceJavaToLua.coerce(set), CoerceJavaToLua.coerce(map.get(set))});
            }
        } else if (this.m_instance instanceof List) {
            int idx;
            List list = (List)this.m_instance;
            int n = idx = index.isnil() ? 0 : index.toint() + 1;
            if (idx >= list.size()) {
                return LuaValue.NIL;
            }
            return LuaValue.varargsOf(new LuaValue[]{CoerceJavaToLua.coerce(idx), CoerceJavaToLua.coerce(list.get(idx))});
        }
        return super.next(index);
    }

    @Override
    public LuaValue get(LuaValue key) {
        HashMap<LuaValue, LuaValue> cs;
        Class c;
        LuaValue m;
        Field f;
        LuaValue val;
        if (this.jclass == null) {
            this.jclass = JavaClass.forClass(this.m_instance.getClass());
        }
        if ((val = this.jclass.finalValueCache.get(key)) != null) {
            return val;
        }
        int type2 = 0;
        Integer type22 = this.jclass.typeCache.get(key);
        if (type22 != null) {
            type2 = type22;
        }
        if ((type2 == 0 || type2 == 1) && (f = this.jclass.getField(key)) != null) {
            if (type2 == 0) {
                this.jclass.typeCache.put(key, 1);
            }
            try {
                LuaValue ret = CoerceJavaToLua.coerce(f.get(this.m_instance));
                if (Modifier.isFinal(f.getModifiers())) {
                    this.jclass.finalValueCache.put(key, ret);
                }
                return ret;
            }
            catch (Exception e) {
                throw new LuaError(e);
            }
        }
        if ((type2 == 0 || type2 == 2) && (m = this.jclass.getMethod(key)) != null) {
            if (type2 == 0) {
                this.jclass.typeCache.put(key, 2);
            }
            m.setuservalue(this);
            return m;
        }
        if ((type2 == 0 || type2 == 3) && this.m_instance instanceof Class && (c = this.jclass.getInnerClass(key)) != null) {
            if (type2 == 0) {
                this.jclass.typeCache.put(key, 3);
            }
            JavaClass ret = JavaClass.forClass(c);
            if (Modifier.isStatic(c.getModifiers())) {
                this.jclass.finalValueCache.put(key, ret);
            }
            return ret;
        }
        if (type2 == 0 || type2 == 4) {
            m = this.jclass.getterCache.get(key);
            if (m == null) {
                String k = key.tojstring();
                if (k.equals("class")) {
                    return CoerceJavaToLua.coerce(this.m_instance.getClass());
                }
                if (Character.isLowerCase(k.charAt(0))) {
                    k = Character.toUpperCase(k.charAt(0)) + k.substring(1);
                }
                if ((m = this.jclass.getMethod(CoerceJavaToLua.coerce("get" + k))) == null) {
                    m = this.jclass.getMethod(CoerceJavaToLua.coerce("is" + k));
                }
            }
            if (m != null) {
                if (type2 == 0) {
                    this.jclass.getterCache.put(key, m);
                    this.jclass.typeCache.put(key, 4);
                }
                m.setuservalue(this);
                return m.call();
            }
        }
        if (type2 == 0 || type2 == 5) {
            if (this.m_instance instanceof Map) {
                Map map = (Map)this.m_instance;
                if (type2 == 0) {
                    this.jclass.typeCache.put(key, 5);
                }
                return CoerceJavaToLua.coerce(map.get(CoerceLuaToJava.coerce(key, Object.class)));
            }
            if (this.m_instance instanceof List) {
                if (type2 == 0) {
                    this.jclass.typeCache.put(key, 5);
                }
                List list = (List)this.m_instance;
                return CoerceJavaToLua.coerce(list.get(key.checkint()));
            }
        }
        if (this.vs == null) {
            if (values.containsKey(this)) {
                this.vs = values.get(this);
                if (this.vs.containsKey(key)) {
                    return this.vs.get(key);
                }
            }
        } else if (this.vs.containsKey(key)) {
            return this.vs.get(key);
        }
        if (values.containsKey(this.jclass) && (cs = values.get(this.jclass)).containsKey(key)) {
            return cs.get(key);
        }
        if (key.eq_b(CLASS)) {
            this.jclass.finalValueCache.put(key, this.jclass);
            return this.jclass;
        }
        return super.get(key);
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        String k;
        Field f;
        if (this.jclass == null) {
            this.jclass = JavaClass.forClass(this.m_instance.getClass());
        }
        int type2 = 0;
        Integer type22 = this.jclass.setTypeCache.get(key);
        if (type22 != null) {
            type2 = type22;
        }
        if ((type2 == 0 || type2 == 6) && (f = this.jclass.getField(key)) != null) {
            if (type2 == 0) {
                this.jclass.setTypeCache.put(key, 6);
            }
            try {
                f.set(this.m_instance, CoerceLuaToJava.coerce(value, f.getType()));
                return;
            }
            catch (Exception e) {
                throw new LuaError(e);
            }
        }
        if (type2 == 0 || type2 == 7) {
            LuaValue m = this.jclass.setterCache.get(key);
            if (m == null) {
                String k2 = key.tojstring();
                if (Character.isLowerCase(k2.charAt(0))) {
                    k2 = Character.toUpperCase(k2.charAt(0)) + k2.substring(1);
                }
                m = this.jclass.getMethod(CoerceJavaToLua.coerce("set" + k2));
            }
            if (m != null) {
                if (type2 == 0) {
                    this.jclass.setterCache.put(key, m);
                    this.jclass.setTypeCache.put(key, 7);
                }
                m.setuservalue(this);
                m.call(value);
                return;
            }
        }
        if ((type2 == 0 || type2 == 9) && (k = key.tojstring()).length() > 2 && k.substring(0, 2).equals("on") && value.isfunction() && this.javaSetListener(k, value)) {
            if (type2 == 0) {
                this.jclass.setTypeCache.put(key, 9);
            }
            return;
        }
        if (type2 == 0 || type2 == 8) {
            if (this.m_instance instanceof Map) {
                Map map = (Map)this.m_instance;
                if (type2 == 0) {
                    this.jclass.setTypeCache.put(key, 8);
                }
                CoerceJavaToLua.coerce(map.put(CoerceLuaToJava.coerce(key, Object.class), CoerceLuaToJava.coerce(value, Object.class)));
                return;
            }
            if (this.m_instance instanceof List) {
                if (type2 == 0) {
                    this.jclass.setTypeCache.put(key, 8);
                }
                List list = (List)this.m_instance;
                CoerceJavaToLua.coerce(list.set(key.checkint(), CoerceLuaToJava.coerce(value, Object.class)));
                return;
            }
        }
        if (this.vs == null) {
            if (values.containsKey(this)) {
                this.vs = values.get(this);
            } else {
                this.vs = new HashMap();
                values.put(this, this.vs);
            }
        }
        this.vs.put(key, value);
    }

    private boolean javaSetListener(String k, LuaValue v) {
        String name = "setOn" + k.substring(2) + "Listener";
        JavaMethod m = (JavaMethod)this.jclass.getMethod(CoerceJavaToLua.coerce(name));
        if (m != null) {
            LuaTable t = new LuaTable();
            t.set(k, v);
            Class<?>[] pt = m.method.getParameterTypes();
            m.setuservalue(this);
            m.call(LuajavaLib.createProxy(pt[0], t));
            return true;
        }
        return false;
    }

    @Override
    public LuaValue len() {
        if (this.m_instance instanceof Map) {
            Map map = (Map)this.m_instance;
            return CoerceJavaToLua.coerce(map.size());
        }
        if (this.m_instance instanceof List) {
            List list = (List)this.m_instance;
            return CoerceJavaToLua.coerce(list.size());
        }
        return super.len();
    }
}

