/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.Constants;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.MathLib;

public class LexState
extends Constants {
    protected static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    protected static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    protected static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    protected static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    protected static final String[] RESERVED_LOCAL_VAR_KEYWORDS;
    private static final Hashtable RESERVED_LOCAL_VAR_KEYWORDS_TABLE;
    private static final int EOZ = -1;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    public int lastidx;
    private static final int LUA_COMPAT_LSTR = 1;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_MOD = 3;
    static final int OPR_POW = 4;
    static final int OPR_DIV = 5;
    static final int OPR_IDIV = 6;
    static final int OPR_BAND = 7;
    static final int OPR_BOR = 8;
    static final int OPR_BXOR = 9;
    static final int OPR_SHL = 10;
    static final int OPR_SHR = 11;
    static final int OPR_CONCAT = 12;
    static final int OPR_EQ = 13;
    static final int OPR_LT = 14;
    static final int OPR_LE = 15;
    static final int OPR_NE = 16;
    static final int OPR_GT = 17;
    static final int OPR_GE = 18;
    static final int OPR_AND = 19;
    static final int OPR_OR = 20;
    static final int OPR_NOBINOPR = 21;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int OPR_BNOT = 4;
    public static final int VVOID = 0;
    public static final int VNIL = 1;
    public static final int VTRUE = 2;
    public static final int VFALSE = 3;
    public static final int VK = 4;
    public static final int VKNUM = 5;
    public static final int VNONRELOC = 6;
    public static final int VLOCAL = 7;
    public static final int VGLOBAL = 8;
    public static final int VENV = 9;
    public static final int VUPVAL = 10;
    public static final int VINDEXED = 11;
    public static final int VJMP = 12;
    public static final int VRELOCABLE = 13;
    public static final int VCALL = 14;
    public static final int VVARARG = 15;
    int currentidx;
    int current;
    int linenumber;
    int lastline;
    final Token t = new Token();
    final Token lookahead = new Token();
    FuncState fs;
    LuaC.CompileState L;
    InputStream z;
    char[] buff;
    int nbuff;
    Dyndata dyd = new Dyndata();
    LuaString source;
    LuaString envn;
    byte decpoint;
    static final String[] luaX_tokens;
    static final String[] luaX_cn_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_CASE = 259;
    static final int TK_CATCH = 260;
    static final int TK_CONTINUE = 261;
    static final int TK_DEFAULT = 262;
    static final int TK_DEFER = 263;
    static final int TK_DO = 264;
    static final int TK_ELSE = 265;
    static final int TK_ELSEIF = 266;
    static final int TK_END = 267;
    static final int TK_FALSE = 268;
    static final int TK_FINALLY = 269;
    static final int TK_FOR = 270;
    static final int TK_FUNCTION = 271;
    static final int TK_GOTO = 272;
    static final int TK_IF = 273;
    static final int TK_IMPORT = 274;
    static final int TK_IN = 275;
    static final int TK_LAMBDA = 276;
    static final int TK_LOCAL = 277;
    static final int TK_MODULE = 278;
    static final int TK_NIL = 279;
    static final int TK_NOT = 280;
    static final int TK_OR = 281;
    static final int TK_REPEAT = 282;
    static final int TK_RETURN = 283;
    static final int TK_SWITCH = 284;
    static final int TK_THEN = 285;
    static final int TK_TRUE = 286;
    static final int TK_TRY = 287;
    static final int TK_UNTIL = 288;
    static final int TK_WHEN = 289;
    static final int TK_WHILE = 290;
    static final int TK_CONCAT = 291;
    static final int TK_DOTS = 292;
    static final int TK_EQ = 293;
    static final int TK_GE = 294;
    static final int TK_LE = 295;
    static final int TK_NE = 296;
    static final int TK_IDIV = 297;
    static final int TK_SHL = 298;
    static final int TK_SHR = 299;
    static final int TK_DBCOLON = 300;
    static final int TK_EOS = 301;
    static final int TK_NUMBER = 302;
    static final int TK_NAME = 303;
    static final int TK_STRING = 304;
    static final int FIRST_RESERVED = 257;
    static final int NUM_RESERVED = 34;
    static final Hashtable RESERVED;
    private static final int[] luai_ctype_;
    private static final int ALPHABIT = 0;
    private static final int DIGITBIT = 1;
    private static final int PRINTBIT = 2;
    private static final int SPACEBIT = 3;
    private static final int XDIGITBIT = 4;
    public static String errormsg;
    public static int errorline;
    public static int erroridx;
    static Priority[] priority;
    static final int UNARY_PRIORITY = 8;

    private static final String LUA_QS(String s) {
        return "'" + s + "'";
    }

    private static final String LUA_QL(Object o) {
        return LexState.LUA_QS(String.valueOf(o));
    }

    public static boolean isReservedKeyword(String varName) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(varName);
    }

    private boolean testprop(int c, int p) {
        return (luai_ctype_[c + 1] & p) != 0;
    }

    private static int MASK(int B) {
        return 1 << B;
    }

    private boolean isalnum(int c) {
        return this.testprop(c, LexState.MASK(0) | LexState.MASK(1));
    }

    private boolean isalpha(int c) {
        return this.testprop(c, LexState.MASK(0));
    }

    private boolean isdigit(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isxdigit(int c) {
        return this.testprop(c, LexState.MASK(4));
    }

    private boolean isspace(int c) {
        return this.testprop(c, LexState.MASK(3));
    }

    public LexState(LuaC.CompileState state, InputStream stream) {
        this.z = stream;
        this.buff = new char[32];
        this.L = state;
    }

    void nextChar() {
        try {
            this.current = this.z.read();
            ++this.currentidx;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.current = -1;
        }
    }

    boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    void save(int c) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = LexState.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (char)c;
    }

    String token2str(int token) {
        if (token < 257) {
            return LexState.iscntrl(token) ? this.L.pushfstring("char(" + token + ")") : this.L.pushfstring(String.valueOf((char)token));
        }
        return luaX_tokens[token - 257];
    }

    private static boolean iscntrl(int token) {
        return token < 32;
    }

    String txtToken(int token) {
        switch (token) {
            case 302: 
            case 303: 
            case 304: {
                return LuaString.valueOf(this.buff, 0, this.nbuff).tojstring();
            }
        }
        return this.token2str(token);
    }

    void lexerror(String msg, int token) {
        String cid = Lua.chunkid(this.source.tojstring());
        msg = token != 0 ? this.L.pushfstring(this.linenumber + ": syntax error: " + msg + " near " + this.txtToken(token)) : this.L.pushfstring(cid + ":" + this.linenumber + ": " + msg);
        throw new LuaError(msg);
    }

    void syntaxerror(String msg) {
        this.lexerror(msg, this.t.token);
    }

    LuaString newstring(String s) {
        return this.L.newTString(s);
    }

    LuaString newstring(char[] chars, int offset, int len2) {
        return this.L.newTString(LuaString.valueOf(chars, offset, len2));
    }

    void inclinenumber() {
        int old = this.current;
        LexState._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != old) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            this.syntaxerror("chunk has too many lines");
        }
    }

    void setinput(LuaC.CompileState L, int firstByte, InputStream z, LuaString source) {
        this.decpoint = (byte)46;
        this.L = L;
        this.lookahead.token = 301;
        this.z = z;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = source;
        this.envn = LuaValue.ENV;
        this.nbuff = 0;
        this.current = firstByte;
        this.skipShebang();
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    boolean check_next(String set) {
        if (set.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    void buffreplace(char from, char to) {
        int n = this.nbuff;
        char[] p = this.buff;
        while (--n >= 0) {
            if (p[n] != from) continue;
            p[n] = to;
        }
    }

    LuaValue strx2number(String str, SemInfo seminfo) {
        int s;
        char[] c = str.toCharArray();
        for (s = 0; s < c.length && this.isspace(c[s]); ++s) {
        }
        double sgn = 1.0;
        if (s < c.length && c[s] == '-') {
            sgn = -1.0;
            ++s;
        }
        if (s + 2 >= c.length) {
            return LuaValue.ZERO;
        }
        if (c[s++] != '0') {
            return LuaValue.ZERO;
        }
        if (c[s] != 'x' && c[s] != 'X') {
            return LuaValue.ZERO;
        }
        ++s;
        double m = 0.0;
        int e = 0;
        while (s < c.length && this.isxdigit(c[s])) {
            m = m * 16.0 + (double)this.hexvalue(c[s++]);
        }
        if (s < c.length && c[s] == '.') {
            ++s;
            while (s < c.length && this.isxdigit(c[s])) {
                m = m * 16.0 + (double)this.hexvalue(c[s++]);
                e -= 4;
            }
        }
        if (s < c.length && (c[s] == 'p' || c[s] == 'P')) {
            int exp1 = 0;
            boolean neg1 = false;
            if (++s < c.length && c[s] == '-') {
                neg1 = true;
                ++s;
            }
            while (s < c.length && this.isdigit(c[s])) {
                exp1 = exp1 * 10 + c[s++] - 48;
            }
            if (neg1) {
                exp1 = -exp1;
            }
            e += exp1;
        }
        return LuaValue.valueOf(sgn * m * MathLib.dpow_d(2.0, e));
    }

    boolean str2d(String str, SemInfo seminfo) {
        seminfo.r = str.indexOf(110) >= 0 || str.indexOf(78) >= 0 ? LuaValue.ZERO : (str.indexOf(120) >= 0 || str.indexOf(88) >= 0 ? this.strx2number(str, seminfo) : LuaValue.valueOf(Double.parseDouble(str.trim())));
        return true;
    }

    void read_numeral(SemInfo seminfo) {
        String expo = "Ee";
        int first = this.current;
        LexState._assert(this.isdigit(this.current));
        this.save_and_next();
        if (first == 48 && this.check_next("Xx")) {
            expo = "Pp";
        }
        while (true) {
            if (this.check_next(expo)) {
                this.check_next("+-");
            }
            if (!this.isxdigit(this.current) && this.current != 46) break;
            this.save_and_next();
        }
        this.save(0);
        String str = new String(this.buff, 0, this.nbuff);
        this.str2d(str, seminfo);
    }

    int skip_sep() {
        int count = 0;
        int s = this.current;
        LexState._assert(s == 91 || s == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++count;
        }
        return this.current == s ? count : -count - 1;
    }

    void read_long_string(SemInfo seminfo, int sep) {
        int cont = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        boolean endloop = false;
        block6: while (!endloop) {
            switch (this.current) {
                case -1: {
                    this.lexerror(seminfo != null ? "unfinished long string" : "unfinished long comment", 301);
                    continue block6;
                }
                case 91: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    ++cont;
                    if (sep != 0) continue block6;
                    this.lexerror("nesting of [[...]] is deprecated", 91);
                    continue block6;
                }
                case 93: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    endloop = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (seminfo != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            this.save_and_next();
        }
        if (seminfo != null) {
            seminfo.ts = this.newstring(this.buff, 2 + sep, this.nbuff - 2 * (2 + sep));
        }
    }

    int hexvalue(int c) {
        return c <= 57 ? c - 48 : (c <= 70 ? c + 10 - 65 : c + 10 - 97);
    }

    int readhexaesc() {
        this.nextChar();
        int c1 = this.current;
        this.nextChar();
        int c2 = this.current;
        if (!this.isxdigit(c1) || !this.isxdigit(c2)) {
            this.lexerror("hexadecimal digit expected 'x" + (char)c1 + (char)c2, 304);
        }
        return (this.hexvalue(c1) << 4) + this.hexvalue(c2);
    }

    int readutf8aesc() {
        int i = 0;
        int c = 0;
        this.nextChar();
        do {
            c = (c << 4) + this.hexvalue(this.current);
            this.nextChar();
        } while (++i < 4 && this.isxdigit(this.current));
        this.save_utf8(c);
        return (char)c;
    }

    private int save_utf8(int ch) {
        if (ch < 128) {
            this.save((char)ch);
            return 1;
        }
        if (ch <= 2047) {
            this.save((char)(ch >> 6) | 0xC0);
            this.save((char)(ch | 0x80) & 0xBF);
            return 2;
        }
        if (ch <= 65535) {
            this.save((char)(ch >> 12) | 0xE0);
            this.save((char)(ch >> 6 | 0x80) & 0xBF);
            this.save((char)(ch | 0x80) & 0xBF);
            return 3;
        }
        return 0;
    }

    void read_string(int del, SemInfo seminfo) {
        this.save_and_next();
        block19: while (this.current != del) {
            switch (this.current) {
                case -1: {
                    this.lexerror("unfinished string", 301);
                    continue block19;
                }
                case 10: 
                case 13: {
                    this.lexerror("unfinished string", 304);
                    continue block19;
                }
                case 92: {
                    int c;
                    this.nextChar();
                    switch (this.current) {
                        case 97: {
                            c = 7;
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: {
                            c = this.readutf8aesc();
                            continue block19;
                        }
                        case 120: {
                            c = this.readhexaesc();
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block19;
                        }
                        case -1: {
                            continue block19;
                        }
                        case 122: {
                            this.nextChar();
                            while (this.isspace(this.current)) {
                                if (this.currIsNewline()) {
                                    this.inclinenumber();
                                    continue;
                                }
                                this.nextChar();
                            }
                            continue block19;
                        }
                        default: {
                            if (!this.isdigit(this.current)) {
                                this.save_and_next();
                                continue block19;
                            }
                            int i = 0;
                            c = 0;
                            do {
                                c = 10 * c + (this.current - 48);
                                this.nextChar();
                            } while (++i < 3 && this.isdigit(this.current));
                            if (c > 255) {
                                this.lexerror("escape sequence too large", 304);
                            }
                            this.save(c);
                            continue block19;
                        }
                    }
                    this.save(c);
                    this.nextChar();
                    continue block19;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        seminfo.ts = this.newstring(this.buff, 1, this.nbuff - 2);
    }

    int llex(SemInfo seminfo) {
        this.nbuff = 0;
        block15: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block15;
                }
                case 45: {
                    int sep;
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91 && (sep = this.skip_sep()) >= 0) {
                        this.read_long_string(null, sep);
                        this.nbuff = 0;
                        continue block15;
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block15;
                        this.nextChar();
                    }
                }
                case 91: {
                    int sep = this.skip_sep();
                    if (sep >= 0) {
                        this.read_long_string(seminfo, sep);
                        return 304;
                    }
                    if (sep == -1) {
                        return 91;
                    }
                    this.lexerror("invalid long string delimiter", 304);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 293;
                }
                case 60: {
                    this.nextChar();
                    if (this.current == 60) {
                        this.nextChar();
                        return 298;
                    }
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 295;
                }
                case 62: {
                    this.nextChar();
                    if (this.current == 62) {
                        this.nextChar();
                        return 299;
                    }
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 294;
                }
                case 47: {
                    this.nextChar();
                    if (this.current != 47) {
                        return 47;
                    }
                    this.nextChar();
                    return 297;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 296;
                }
                case 58: {
                    this.nextChar();
                    if (this.current != 58) {
                        return 58;
                    }
                    this.nextChar();
                    return 300;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, seminfo);
                    return 304;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 292;
                        }
                        return 291;
                    }
                    if (!this.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(seminfo);
                    return 302;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.read_numeral(seminfo);
                    return 302;
                }
                case -1: {
                    return 301;
                }
            }
            if (!this.isspace(this.current)) break;
            LexState._assert(!this.currIsNewline());
            this.nextChar();
        }
        if (this.isdigit(this.current)) {
            this.read_numeral(seminfo);
            return 302;
        }
        if (this.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (this.isalnum(this.current));
            LuaString ts = this.newstring(this.buff, 0, this.nbuff);
            if (RESERVED.containsKey(ts)) {
                return (Integer)RESERVED.get(ts);
            }
            seminfo.ts = ts;
            return 303;
        }
        int c = this.current;
        this.nextChar();
        return c;
    }

    void next() {
        this.lastline = this.linenumber;
        this.lastidx = this.currentidx;
        if (this.lookahead.token != 301) {
            this.t.set(this.lookahead);
            this.lookahead.token = 301;
        } else {
            this.t.token = this.llex(this.t.seminfo);
        }
    }

    void lookahead() {
        LexState._assert(this.lookahead.token == 301);
        this.lookahead.token = this.llex(this.lookahead.seminfo);
    }

    static final boolean vkisvar(int k) {
        return 7 <= k && k <= 11;
    }

    static final boolean vkisinreg(int k) {
        return k == 6 || k == 7;
    }

    boolean hasmultret(int k) {
        return k == 14 || k == 15;
    }

    void anchor_token() {
        LexState._assert(this.fs != null || this.t.token == 301);
        if (this.t.token == 303 || this.t.token == 304) {
            LuaString ts = this.t.seminfo.ts;
            this.L.cachedLuaString(this.t.seminfo.ts);
        }
    }

    void semerror(String msg) {
        this.t.token = 0;
        this.syntaxerror(msg);
    }

    void error_expected(int token) {
        this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(token)) + " expected"));
    }

    boolean testnext(int c) {
        if (this.t.token == c) {
            this.next();
            return true;
        }
        return false;
    }

    boolean testtoken(int c) {
        return this.t.token == c;
    }

    void check(int c) {
        if (this.t.token != c) {
            this.error_expected(c);
        }
    }

    void checknext(int c) {
        this.check(c);
        this.next();
    }

    void check_condition(boolean c, String msg) {
        if (!c) {
            this.syntaxerror(msg);
        }
    }

    void check_match(int what, int who, int where) {
        if (!this.testnext(what)) {
            if (where == this.linenumber) {
                this.error_expected(what);
            } else {
                errorline = where;
                this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(what)) + " expected (to close " + LexState.LUA_QS(this.token2str(who)) + " at line " + where + ")"));
            }
        }
    }

    LuaString str_checkname() {
        this.check(303);
        LuaString ts = this.t.seminfo.ts;
        this.next();
        return ts;
    }

    LuaString str_check() {
        this.check(304);
        LuaString ts = this.t.seminfo.ts;
        this.next();
        return ts;
    }

    void codestring(expdesc e, LuaString s) {
        e.init(4, this.fs.stringK(s));
    }

    void checkname(expdesc e) {
        this.codestring(e, this.str_checkname());
    }

    LuaString checkstring(expdesc e) {
        LuaString str = this.str_check();
        this.codestring(e, str);
        return str;
    }

    int registerlocalvar(LuaString varname) {
        LocVars var;
        FuncState fs = this.fs;
        Prototype f = fs.f;
        if (f.locvars == null || fs.nlocvars + 1 > f.locvars.length) {
            f.locvars = LexState.realloc(f.locvars, fs.nlocvars * 2 + 1);
        }
        f.locvars[fs.nlocvars] = var = new LocVars(varname, 0, 0);
        short s = fs.nlocvars;
        fs.nlocvars = (short)(s + 1);
        return s;
    }

    void new_localvar(LuaString name) {
        int reg = this.registerlocalvar(name);
        this.fs.checklimit(this.dyd.n_actvar + 1, 200, "local variables");
        if (this.dyd.actvar == null || this.dyd.n_actvar + 1 > this.dyd.actvar.length) {
            this.dyd.actvar = LexState.realloc(this.dyd.actvar, Math.max(1, this.dyd.n_actvar * 2));
        }
        this.dyd.actvar[this.dyd.n_actvar++] = new Vardesc(reg);
    }

    void new_localvarliteral(String v) {
        LuaString ts = this.newstring(v);
        this.new_localvar(ts);
    }

    void adjustlocalvars(int nvars) {
        FuncState fs = this.fs;
        fs.nactvar = (short)(fs.nactvar + nvars);
        while (nvars > 0) {
            LocVars var = fs.getlocvar(fs.nactvar - nvars);
            var.startpc = fs.pc;
            var.startidx = this.currentidx;
            --nvars;
        }
    }

    void removevars(int tolevel) {
        FuncState fs = this.fs;
        while (fs.nactvar > tolevel) {
            fs.nactvar = (short)(fs.nactvar - 1);
            fs.getlocvar((int)((short)(fs.nactvar - 1))).endpc = fs.pc;
        }
    }

    void singlevar(expdesc var) {
        FuncState fs = this.fs;
        LuaString varname = this.str_checkname();
        int vartype = FuncState.singlevaraux(fs, varname, var, 1);
        if (vartype != 7) {
            // empty if block
        }
        if (vartype == 0) {
            expdesc key = new expdesc();
            vartype = FuncState.singlevaraux(fs, this.envn, var, 1);
            LexState._assert(var.k == 7 || var.k == 10);
            this.codestring(key, varname);
            fs.indexed(var, key);
        }
    }

    void adjust_assign(int nvars, int nexps, expdesc e) {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (this.hasmultret(e.k)) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setreturns(e, extra);
            if (extra > 1) {
                fs.reserveregs(extra - 1);
            }
        } else {
            if (e.k != 0) {
                fs.exp2nextreg(e);
            }
            if (extra > 0) {
                short reg = fs.freereg;
                fs.reserveregs(extra);
                fs.nil(reg, extra);
            }
        }
    }

    void enterlevel() {
        if (++this.L.nCcalls > 200) {
            this.lexerror("chunk has too many syntax levels", 0);
        }
    }

    void leavelevel() {
        --this.L.nCcalls;
    }

    void closegoto(int g, Labeldesc label) {
        FuncState fs = this.fs;
        Labeldesc[] gl = this.dyd.gt;
        Labeldesc gt = gl[g];
        LexState._assert(gt.name.eq_b(label.name));
        if (gt.nactvar < label.nactvar) {
            LuaString vname = fs.getlocvar((int)gt.nactvar).varname;
            String msg = this.L.pushfstring("<goto " + gt.name + "> at line " + gt.line + " jumps into the scope of local '" + vname.tojstring() + "'");
            this.semerror(msg);
        }
        fs.patchlist(gt.pc, label.pc);
        System.arraycopy(gl, g + 1, gl, g, this.dyd.n_gt - g - 1);
        gl[--this.dyd.n_gt] = null;
    }

    boolean findlabel(int g) {
        FuncState.BlockCnt bl = this.fs.bl;
        Dyndata dyd = this.dyd;
        Labeldesc gt = dyd.gt[g];
        for (int i = bl.firstlabel; i < dyd.n_label; ++i) {
            Labeldesc lb = dyd.label[i];
            if (!lb.name.eq_b(gt.name)) continue;
            if (gt.nactvar > lb.nactvar && (bl.upval || dyd.n_label > bl.firstlabel)) {
                this.fs.patchclose(gt.pc, lb.nactvar);
            }
            this.closegoto(g, lb);
            return true;
        }
        return false;
    }

    int newlabelentry(Labeldesc[] l, int index, LuaString name, int line, int pc) {
        l[index] = new Labeldesc(name, pc, line, this.fs.nactvar);
        return index;
    }

    void findgotos(Labeldesc lb) {
        Labeldesc[] gl = this.dyd.gt;
        int i = this.fs.bl.firstgoto;
        while (i < this.dyd.n_gt) {
            if (gl[i].name.eq_b(lb.name)) {
                this.closegoto(i, lb);
                continue;
            }
            ++i;
        }
    }

    void breaklabel() {
        LuaString n = LuaString.valueOf("break");
        this.dyd.label = LexState.grow(this.dyd.label, this.dyd.n_label + 1);
        int l = this.newlabelentry(this.dyd.label, this.dyd.n_label++, n, 0, this.fs.pc);
        this.findgotos(this.dyd.label[l]);
    }

    void continuelabel() {
        LuaString n = LuaString.valueOf("continue");
        this.dyd.label = LexState.grow(this.dyd.label, this.dyd.n_label + 1);
        int l = this.newlabelentry(this.dyd.label, this.dyd.n_label++, n, 0, this.fs.pc);
        this.findgotos(this.dyd.label[l]);
    }

    void undefgoto(Labeldesc gt) {
        String msg = this.L.pushfstring(LexState.isReservedKeyword(gt.name.tojstring()) ? "<" + gt.name + "> at line " + gt.line + " not inside a loop" : "no visible label '" + gt.name + "' for <goto> at line " + gt.line);
        this.semerror(msg);
    }

    Prototype addprototype() {
        Prototype clp;
        Prototype f = this.fs.f;
        if (f.p == null || this.fs.np >= f.p.length) {
            f.p = LexState.realloc(f.p, Math.max(1, this.fs.np * 2));
        }
        f.p[this.fs.np++] = clp = new Prototype();
        return clp;
    }

    void codeclosure(expdesc v) {
        FuncState fs = this.fs.prev;
        v.init(13, fs.codeABx(37, 0, fs.np - 1));
        fs.exp2nextreg(v);
    }

    void open_func(FuncState fs, FuncState.BlockCnt bl) {
        fs.prev = this.fs;
        fs.ls = this;
        this.fs = fs;
        fs.pc = 0;
        fs.lasttarget = -1;
        fs.jpc = new IntPtr(-1);
        fs.freereg = 0;
        fs.nk = 0;
        fs.np = 0;
        fs.nups = 0;
        fs.nlocvars = 0;
        fs.nactvar = 0;
        fs.firstlocal = this.dyd.n_actvar;
        fs.bl = null;
        fs.f.source = this.source;
        fs.f.maxstacksize = 2;
        fs.enterblock(bl, false);
    }

    void close_func() {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        fs.ret(0, 0);
        fs.leaveblock();
        f.code = LexState.realloc(f.code, fs.pc);
        f.lineinfo = LexState.realloc(f.lineinfo, fs.pc);
        f.k = LexState.realloc(f.k, fs.nk);
        f.p = LexState.realloc(f.p, fs.np);
        f.locvars = LexState.realloc(f.locvars, (int)fs.nlocvars);
        f.upvalues = LexState.realloc(f.upvalues, (int)fs.nups);
        LexState._assert(fs.bl == null);
        this.fs = fs.prev;
    }

    void fieldsel(expdesc v) {
        FuncState fs = this.fs;
        expdesc key = new expdesc();
        fs.exp2anyregup(v);
        this.next();
        this.checkname(key);
        fs.indexed(v, key);
    }

    void yindex(expdesc v) {
        this.next();
        this.expr(v);
        this.fs.exp2val(v);
        this.checknext(93);
    }

    void recfield(ConsControl cc) {
        FuncState fs = this.fs;
        short reg = this.fs.freereg;
        expdesc key = new expdesc();
        expdesc val = new expdesc();
        boolean isstr = false;
        boolean isfunc = false;
        if (this.t.token == 271) {
            isfunc = true;
            fs.checklimit(cc.nh, 0x7FFFFFFD, "items in a constructor");
            this.next();
            this.checkname(key);
        } else if (this.t.token == 304) {
            isstr = true;
            fs.checklimit(cc.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkstring(key);
        } else if (this.t.token == 303) {
            fs.checklimit(cc.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(key);
        } else {
            this.yindex(key);
        }
        ++cc.nh;
        if (!(isfunc || isstr && this.testnext(58))) {
            this.checknext(61);
        }
        int rkkey = fs.exp2RK(key);
        if (isfunc) {
            this.body(val, false, this.linenumber);
        } else {
            this.expr(val);
        }
        fs.codeABC(10, cc.t.u.info, rkkey, fs.exp2RK(val));
        fs.freereg = reg;
    }

    void listfield(ConsControl cc) {
        this.expr(cc.v);
        this.fs.checklimit(cc.na, 0x7FFFFFFD, "items in a constructor");
        ++cc.na;
        ++cc.tostore;
    }

    void constructor(expdesc t) {
        FuncState fs = this.fs;
        int line = this.linenumber;
        int pc = fs.codeABC(11, 0, 0, 0);
        ConsControl cc = new ConsControl();
        cc.tostore = 0;
        cc.nh = 0;
        cc.na = 0;
        cc.t = t;
        t.init(13, pc);
        cc.v.init(0, 0);
        fs.exp2nextreg(t);
        this.checknext(123);
        do {
            LexState._assert(cc.v.k == 0 || cc.tostore > 0);
            if (this.t.token == 125) break;
            fs.closelistfield(cc);
            switch (this.t.token) {
                case 304: {
                    this.lookahead();
                    if (this.lookahead.token != 61 && this.lookahead.token != 58) {
                        this.listfield(cc);
                        break;
                    }
                    this.recfield(cc);
                    break;
                }
                case 271: {
                    this.lookahead();
                    if (this.lookahead.token != 303) {
                        this.listfield(cc);
                        break;
                    }
                    this.recfield(cc);
                    break;
                }
                case 303: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(cc);
                        break;
                    }
                    this.recfield(cc);
                    break;
                }
                case 91: {
                    this.recfield(cc);
                    break;
                }
                default: {
                    this.listfield(cc);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, line);
        fs.lastlistfield(cc);
        InstructionPtr i = new InstructionPtr(fs.f.code, pc);
        LexState.SETARG_B(i, LexState.luaO_int2fb(cc.na));
        LexState.SETARG_C(i, LexState.luaO_int2fb(cc.nh));
    }

    void constructorList(expdesc t) {
        FuncState fs = this.fs;
        int line = this.linenumber;
        int pc = fs.codeABx(48, 0, 0);
        ConsControl cc = new ConsControl();
        cc.tostore = 0;
        cc.nh = 0;
        cc.na = 0;
        cc.t = t;
        t.init(13, pc);
        cc.v.init(0, 0);
        fs.exp2nextreg(t);
        this.checknext(91);
        do {
            LexState._assert(cc.v.k == 0 || cc.tostore > 0);
            if (this.t.token == 93) break;
            fs.closelistfield(cc);
            this.listfield(cc);
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(93, 91, line);
        fs.lastlistfield(cc);
        InstructionPtr i = new InstructionPtr(fs.f.code, pc);
        LexState.SETARG_B(i, LexState.luaO_int2fb(cc.na));
    }

    static int luaO_int2fb(int x) {
        int e = 0;
        while (x >= 16) {
            x = x + 1 >> 1;
            ++e;
        }
        if (x < 8) {
            return x;
        }
        return e + 1 << 3 | x - 8;
    }

    void parlist() {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        int nparams = 0;
        f.is_vararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 303: {
                        this.new_localvar(this.str_checkname());
                        ++nparams;
                        break;
                    }
                    case 292: {
                        this.next();
                        f.is_vararg = 1;
                        break;
                    }
                    default: {
                        this.syntaxerror("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (f.is_vararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(nparams);
        f.numparams = fs.nactvar;
        fs.reserveregs(fs.nactvar);
    }

    void body(expdesc e, boolean needself, int line) {
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        new_fs.f.startidx = this.currentidx;
        this.open_func(new_fs, bl);
        this.checknext(40);
        if (needself) {
            this.new_localvarliteral("self");
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        boolean left = this.testnext(123);
        this.new_localvar(this.envn);
        expdesc env = new expdesc();
        FuncState.singlevaraux(this.fs, this.envn, env, 1);
        this.adjust_assign(1, 1, env);
        this.adjustlocalvars(1);
        this.statlist();
        new_fs.f.endidx = this.currentidx;
        new_fs.f.lastlinedefined = this.linenumber;
        this.codeclosure(e);
        this.close_func();
        if (left) {
            this.check_match(125, 271, line);
        } else {
            this.check_match(267, 271, line);
        }
    }

    void lambdabody(expdesc e, int line) {
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        new_fs.f.startidx = this.currentidx;
        this.open_func(new_fs, bl);
        boolean left = this.testnext(40);
        this.parlist();
        if (left) {
            this.checknext(41);
        }
        this.new_localvar(this.envn);
        expdesc env = new expdesc();
        FuncState.singlevaraux(this.fs, this.envn, env, 1);
        this.adjust_assign(1, 1, env);
        this.adjustlocalvars(1);
        this.checknext(58);
        this.retstat();
        new_fs.f.endidx = this.currentidx;
        new_fs.f.lastlinedefined = this.linenumber;
        this.codeclosure(e);
        this.close_func();
    }

    void deferbody(expdesc e, int line) {
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        new_fs.f.startidx = this.currentidx;
        this.open_func(new_fs, bl);
        new_fs.f.name = "defer";
        boolean hasarg = this.testnext(40);
        if (hasarg) {
            this.parlist();
            this.checknext(41);
        }
        this.statement();
        new_fs.f.endidx = this.currentidx;
        new_fs.f.lastlinedefined = this.linenumber;
        this.codeclosure(e);
        this.close_func();
    }

    void whenbody(expdesc e, int line) {
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        new_fs.f.startidx = this.currentidx;
        this.open_func(new_fs, bl);
        new_fs.f.name = "when";
        boolean left = this.testnext(40);
        expdesc control = new expdesc();
        this.expr(control);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        IntPtr escapelist = new IntPtr(-1);
        while (this.t.token == 259) {
            this.test_case_block(escapelist, control.clone());
        }
        if (this.testnext(262)) {
            this.block();
        }
        this.fs.patchtohere(escapelist.i);
        new_fs.f.endidx = this.currentidx;
        new_fs.f.lastlinedefined = this.linenumber;
        this.codeclosure(e);
        this.close_func();
        if (left) {
            this.check_match(125, 289, line);
        } else {
            this.check_match(267, 289, line);
        }
    }

    boolean trybody(expdesc e, int token, int line) {
        boolean hasarg;
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        new_fs.f.startidx = this.currentidx;
        this.open_func(new_fs, bl);
        if (token == 260 && (hasarg = this.testnext(40))) {
            this.parlist();
            this.checknext(41);
        }
        boolean left = this.testnext(123);
        this.statlist();
        new_fs.f.endidx = this.currentidx;
        new_fs.f.lastlinedefined = this.linenumber;
        this.codeclosure(e);
        this.close_func();
        if (left) {
            this.check_match(125, token, line);
        }
        return left;
    }

    int explist(expdesc v) {
        int n = 1;
        this.expr(v);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(v);
            this.expr(v);
            ++n;
        }
        return n;
    }

    void funcargs(expdesc f, int line) {
        int nparams;
        FuncState fs = this.fs;
        expdesc args = new expdesc();
        switch (this.t.token) {
            case 40: {
                this.next();
                if (this.t.token == 41) {
                    args.k = 0;
                } else {
                    this.explist(args);
                    fs.setmultret(args);
                }
                this.check_match(41, 40, line);
                break;
            }
            case 123: {
                this.constructor(args);
                break;
            }
            case 304: {
                this.codestring(args, this.t.seminfo.ts);
                this.next();
                break;
            }
            default: {
                this.syntaxerror("function arguments expected");
                return;
            }
        }
        LexState._assert(f.k == 6);
        int base = f.u.info;
        if (this.hasmultret(args.k)) {
            nparams = -1;
        } else {
            if (args.k != 0) {
                fs.exp2nextreg(args);
            }
            nparams = fs.freereg - (base + 1);
        }
        f.init(14, fs.codeABC(29, base, nparams + 1, 2));
        fs.fixline(line);
        fs.freereg = (short)(base + 1);
    }

    void primaryexp(expdesc v) {
        switch (this.t.token) {
            case 40: {
                int line = this.linenumber;
                this.next();
                this.expr(v);
                this.check_match(41, 40, line);
                this.fs.dischargevars(v);
                return;
            }
            case 303: {
                this.singlevar(v);
                return;
            }
        }
        this.syntaxerror("unexpected symbol " + this.t.token);
    }

    void suffixedexp(expdesc v) {
        int line = this.linenumber;
        this.primaryexp(v);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.fieldsel(v);
                    continue block6;
                }
                case 91: {
                    expdesc key = new expdesc();
                    this.fs.exp2anyregup(v);
                    this.yindex(key);
                    this.fs.indexed(v, key);
                    continue block6;
                }
                case 58: {
                    expdesc key = new expdesc();
                    this.next();
                    this.checkname(key);
                    this.fs.self(v, key);
                    this.funcargs(v, line);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 304: {
                    this.fs.exp2nextreg(v);
                    this.funcargs(v, line);
                    continue block6;
                }
            }
            break;
        }
    }

    void simpleexp(expdesc v) {
        switch (this.t.token) {
            case 302: {
                v.init(5, 0);
                v.u.setNval(this.t.seminfo.r);
                break;
            }
            case 304: {
                this.codestring(v, this.t.seminfo.ts);
                break;
            }
            case 279: {
                v.init(1, 0);
                break;
            }
            case 286: {
                v.init(2, 0);
                break;
            }
            case 268: {
                v.init(3, 0);
                break;
            }
            case 292: {
                FuncState fs = this.fs;
                this.check_condition(fs.f.is_vararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                v.init(15, fs.codeABC(38, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(v);
                return;
            }
            case 91: {
                this.constructorList(v);
                return;
            }
            case 271: {
                this.next();
                this.body(v, false, this.linenumber);
                return;
            }
            case 276: {
                this.next();
                this.lambdabody(v, this.linenumber);
                return;
            }
            case 289: {
                v.init(14, this.whenstat());
                return;
            }
            default: {
                this.suffixedexp(v);
                return;
            }
        }
        this.next();
    }

    int getunopr(int op) {
        switch (op) {
            case 280: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
            case 126: {
                return 4;
            }
        }
        return 3;
    }

    int getbinopr(int op) {
        switch (op) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 5;
            }
            case 37: {
                return 3;
            }
            case 94: {
                return 4;
            }
            case 291: {
                return 12;
            }
            case 296: {
                return 16;
            }
            case 293: {
                return 13;
            }
            case 60: {
                return 14;
            }
            case 295: {
                return 15;
            }
            case 62: {
                return 17;
            }
            case 294: {
                return 18;
            }
            case 257: {
                return 19;
            }
            case 281: {
                return 20;
            }
            case 297: {
                return 6;
            }
            case 38: {
                return 7;
            }
            case 124: {
                return 8;
            }
            case 126: {
                return 9;
            }
            case 298: {
                return 10;
            }
            case 299: {
                return 11;
            }
        }
        return 21;
    }

    int subexpr(expdesc v, int limit) {
        this.enterlevel();
        int uop = this.getunopr(this.t.token);
        if (uop != 3) {
            int line = this.linenumber;
            this.next();
            this.subexpr(v, 8);
            this.fs.prefix(uop, v, line);
        } else {
            this.simpleexp(v);
        }
        int op = this.getbinopr(this.t.token);
        while (op != 21 && LexState.priority[op].left > limit) {
            expdesc v2 = new expdesc();
            int line = this.linenumber;
            this.next();
            this.fs.infix(op, v);
            int nextop = this.subexpr(v2, LexState.priority[op].right);
            this.fs.posfix(op, v, v2, line);
            op = nextop;
        }
        this.leavelevel();
        return op;
    }

    void expr(expdesc v) {
        this.subexpr(v, 0);
    }

    boolean block_follow(boolean withuntil) {
        switch (this.t.token) {
            case 125: 
            case 259: 
            case 260: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 301: {
                return true;
            }
            case 288: {
                return withuntil;
            }
        }
        return false;
    }

    void block() {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, false);
        this.statlist();
        fs.leaveblock();
    }

    void check_conflict(LHS_assign lh, expdesc v) {
        FuncState fs = this.fs;
        short extra = fs.freereg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.k == 11) {
                if (lh.v.u.ind_vt == v.k && lh.v.u.ind_t == v.u.info) {
                    conflict = true;
                    lh.v.u.ind_vt = (short)7;
                    lh.v.u.ind_t = extra;
                }
                if (v.k == 7 && lh.v.u.ind_idx == v.u.info) {
                    conflict = true;
                    lh.v.u.ind_idx = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            int op = v.k == 7 ? 0 : 5;
            fs.codeABC(op, extra, v.u.info, 0);
            fs.reserveregs(1);
        }
    }

    void assignment(LHS_assign lh, int nvars) {
        expdesc e = new expdesc();
        this.check_condition(7 <= lh.v.k && lh.v.k <= 11, "syntax error");
        if (this.testnext(44)) {
            LHS_assign nv = new LHS_assign();
            nv.prev = lh;
            this.suffixedexp(nv.v);
            if (nv.v.k != 11) {
                this.check_conflict(lh, nv.v);
            }
            this.assignment(nv, nvars + 1);
        } else {
            this.checknext(61);
            int nexps = this.explist(e);
            if (nexps != nvars) {
                this.adjust_assign(nvars, nexps, e);
                if (nexps > nvars) {
                    this.fs.freereg = (short)(this.fs.freereg - (nexps - nvars));
                }
            } else {
                this.fs.setoneret(e);
                this.fs.storevar(lh.v, e);
                return;
            }
        }
        e.init(6, this.fs.freereg - 1);
        this.fs.storevar(lh.v, e);
    }

    int cond() {
        expdesc v = new expdesc();
        this.expr(v);
        if (v.k == 1) {
            v.k = 3;
        }
        this.fs.goiftrue(v);
        return v.f.i;
    }

    void gotostat(int pc) {
        LuaString label;
        int line = this.linenumber;
        if (this.testnext(272)) {
            label = this.str_checkname();
        } else if (this.testnext(261)) {
            label = LuaString.valueOf("continue");
        } else {
            this.next();
            label = LuaString.valueOf("break");
        }
        this.dyd.gt = LexState.grow(this.dyd.gt, this.dyd.n_gt + 1);
        int g = this.newlabelentry(this.dyd.gt, this.dyd.n_gt++, label, line, pc);
        this.findlabel(g);
    }

    void skipnoopstat() {
        while (this.t.token == 59 || this.t.token == 300) {
            this.statement();
        }
    }

    void labelstat(LuaString label, int line) {
        this.fs.checkrepeated(this.dyd.label, this.dyd.n_label, label);
        this.checknext(300);
        this.dyd.label = LexState.grow(this.dyd.label, this.dyd.n_label + 1);
        int l = this.newlabelentry(this.dyd.label, this.dyd.n_label++, label, line, this.fs.getlabel());
        this.skipnoopstat();
        if (this.block_follow(false)) {
            this.dyd.label[l].nactvar = this.fs.bl.nactvar;
        }
        this.findgotos(this.dyd.label[l]);
    }

    void whilestat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.next();
        boolean left = this.testnext(40);
        int whileinit = fs.getlabel();
        int condexit = this.cond();
        fs.enterblock(bl, true);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        if (!left) {
            this.testnext(264);
        }
        this.block();
        this.continuelabel();
        fs.patchlist(fs.jump(), whileinit);
        if (left) {
            this.check_match(125, 290, line);
        } else {
            this.check_match(267, 290, line);
        }
        fs.leaveblock();
        fs.patchtohere(condexit);
    }

    void repeatstat(int line) {
        FuncState fs = this.fs;
        boolean left = this.testnext(123);
        int repeat_init = fs.getlabel();
        FuncState.BlockCnt bl1 = new FuncState.BlockCnt();
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl1, true);
        fs.enterblock(bl2, false);
        this.next();
        this.statlist();
        this.continuelabel();
        if (left) {
            this.check_match(125, 282, line);
        }
        this.check_match(288, 282, line);
        int condexit = this.cond();
        if (bl2.upval) {
            fs.patchclose(condexit, bl2.nactvar);
        }
        fs.leaveblock();
        fs.patchlist(condexit, repeat_init);
        fs.leaveblock();
    }

    int exp1() {
        expdesc e = new expdesc();
        this.expr(e);
        int k = e.k;
        this.fs.exp2nextreg(e);
        return k;
    }

    boolean forbody(int base, int line, int nvars, boolean isnum, boolean left) {
        int endfor;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustlocalvars(3);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        if (!left) {
            this.testnext(264);
        }
        int prep = isnum ? fs.codeAsBx(33, base, -1) : fs.jump();
        fs.enterblock(bl, false);
        this.adjustlocalvars(nvars);
        fs.reserveregs(nvars);
        this.block();
        this.continuelabel();
        fs.leaveblock();
        fs.patchtohere(prep);
        if (isnum) {
            endfor = fs.codeAsBx(32, base, -1);
        } else {
            fs.codeABC(34, base, 0, nvars);
            fs.fixline(line);
            endfor = fs.codeAsBx(35, base + 2, -1);
        }
        fs.patchlist(endfor, prep + 1);
        fs.fixline(line);
        return left;
    }

    boolean foreachbody(int base, int line, int nvars, boolean left) {
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustlocalvars(3);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        if (!left) {
            this.testnext(264);
        }
        int prep = fs.jump();
        fs.enterblock(bl, false);
        this.adjustlocalvars(nvars);
        fs.reserveregs(nvars);
        this.block();
        this.continuelabel();
        fs.leaveblock();
        fs.patchtohere(prep);
        fs.codeABC(52, base, 0, nvars);
        fs.fixline(line);
        int endfor = fs.codeAsBx(35, base + 2, -1);
        fs.patchlist(endfor, prep + 1);
        fs.fixline(line);
        return left;
    }

    boolean fornum(LuaString varname, int line, boolean left) {
        FuncState fs = this.fs;
        short base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP);
        this.new_localvar(varname);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            fs.codeABx(1, fs.freereg, fs.numberK(LuaInteger.valueOf(1)));
            fs.reserveregs(1);
        }
        return this.forbody(base, line, 1, true, left);
    }

    boolean forlist(LuaString indexname, boolean left) {
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        int nvars = 4;
        short base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL);
        this.new_localvar(indexname);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname());
            ++nvars;
        }
        boolean foreach = this.testnext(58);
        this.testnext(275);
        int line = this.linenumber;
        this.adjust_assign(3, this.explist(e), e);
        fs.checkstack(3);
        if (foreach) {
            return this.foreachbody(base, line, nvars - 3, left);
        }
        return this.forbody(base, line, nvars - 3, false, left);
    }

    void forstat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, true);
        this.next();
        boolean left = this.testnext(40);
        LuaString varname = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                left = this.fornum(varname, line, left);
                break;
            }
            case 44: 
            case 275: {
                left = this.forlist(varname, left);
                break;
            }
            default: {
                left = this.forlist(varname, left);
            }
        }
        if (left) {
            this.check_match(125, 270, line);
        } else {
            this.check_match(267, 270, line);
        }
        fs.leaveblock();
    }

    boolean test_then_block(IntPtr escapelist) {
        expdesc v = new expdesc();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        int jf = 0;
        int token = this.t.token;
        int line = this.linenumber;
        this.next();
        boolean left = this.testnext(40);
        this.expr(v);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        if (!left) {
            this.testnext(285);
        }
        if (this.t.token == 272 || this.t.token == 258 || this.t.token == 261) {
            this.fs.goiffalse(v);
            this.fs.enterblock(bl, false);
            this.gotostat(v.t.i);
            this.skipnoopstat();
            if (this.block_follow(false)) {
                this.fs.leaveblock();
                return left;
            }
            this.syntaxerror("unreachable statement");
        } else {
            this.fs.goiftrue(v);
            this.fs.enterblock(bl, false);
            jf = v.f.i;
        }
        this.statlist();
        this.fs.leaveblock();
        if (left) {
            this.check_match(125, token, line);
        }
        if (this.t.token == 265 || this.t.token == 266) {
            this.fs.concat(escapelist, this.fs.jump());
        }
        this.fs.patchtohere(jf);
        return left;
    }

    void ifstat(int line) {
        boolean left = false;
        IntPtr escapelist = new IntPtr(-1);
        left = this.test_then_block(escapelist);
        while (this.t.token == 266) {
            left = this.test_then_block(escapelist);
        }
        if (this.testnext(265)) {
            left = this.testnext(123);
            this.block();
            if (left) {
                this.check_match(125, 273, line);
            }
        }
        if (!left) {
            this.check_match(267, 273, line);
        }
        this.fs.patchtohere(escapelist.i);
    }

    void test_case_block(IntPtr escapelist, expdesc control) {
        expdesc v = new expdesc();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        int jf = 0;
        this.next();
        expdesc gcontrol = control.clone();
        this.enterlevel();
        this.fs.infix(13, control);
        this.expr(v);
        this.fs.posfix(13, control, v, this.linenumber);
        while (this.testnext(44)) {
            expdesc c = gcontrol.clone();
            this.fs.infix(13, c);
            this.expr(v);
            this.fs.posfix(13, c, v, this.linenumber);
            this.fs.infix(20, control);
            this.fs.posfix(20, control, c, this.linenumber);
        }
        this.leavelevel();
        this.testnext(285);
        if (this.t.token == 272 || this.t.token == 258 || this.t.token == 261) {
            this.fs.goiffalse(control);
            this.fs.enterblock(bl, false);
            this.gotostat(control.t.i);
            this.skipnoopstat();
            if (this.block_follow(false)) {
                this.fs.leaveblock();
                return;
            }
            this.syntaxerror("unreachable statement");
        } else {
            this.fs.goiftrue(control);
            this.fs.enterblock(bl, false);
            jf = control.f.i;
        }
        this.statlist();
        this.fs.leaveblock();
        if (this.t.token == 259 || this.t.token == 262) {
            this.fs.concat(escapelist, this.fs.jump());
        }
        this.fs.patchtohere(jf);
    }

    void switchstat(int line) {
        IntPtr escapelist = new IntPtr(-1);
        expdesc control = new expdesc();
        this.next();
        boolean left = this.testnext(40);
        this.expr(control);
        if (left) {
            this.checknext(41);
            left = this.testnext(123);
        }
        if (!left) {
            this.testnext(264);
        }
        while (this.t.token == 259) {
            this.test_case_block(escapelist, control.clone());
        }
        if (this.testnext(262)) {
            this.block();
        }
        if (left) {
            this.check_match(125, 284, line);
        } else {
            this.check_match(267, 284, line);
        }
        this.fs.patchtohere(escapelist.i);
    }

    void localfunc() {
        expdesc b = new expdesc();
        FuncState fs = this.fs;
        this.new_localvar(this.str_checkname());
        this.adjustlocalvars(1);
        this.body(b, false, this.linenumber);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
    }

    void importstat() {
        this.next();
        FuncState fs = this.fs;
        boolean left = this.testnext(40);
        do {
            int idx;
            String varname = null;
            if (this.t.token == 303) {
                varname = this.str_checkname().tojstring();
            }
            LuaString classname = this.str_check();
            if (varname == null && (idx = (varname = classname.tojstring()).lastIndexOf(".")) > 0) {
                varname = varname.substring(idx + 1);
            }
            this.new_localvarliteral(varname);
            this.adjustlocalvars(1);
            fs.codeABx(54, fs.nactvar - 1, fs.stringK(classname));
            fs.reserveregs(1);
        } while (this.testnext(44));
        if (left) {
            this.checknext(41);
        }
    }

    void modulestat() {
        this.next();
        FuncState fs = this.fs;
        boolean left = this.testnext(40);
        LuaString classname = this.str_check();
        this.new_localvar(this.envn);
        this.adjustlocalvars(1);
        fs.codeABx(55, fs.nactvar - 1, fs.stringK(classname));
        fs.reserveregs(1);
        if (left) {
            this.checknext(41);
        }
    }

    void deferstat() {
        this.next();
        FuncState fs = this.fs;
        expdesc b = new expdesc();
        this.new_localvarliteral("(defer)");
        this.adjustlocalvars(1);
        this.deferbody(b, this.linenumber);
        fs.codeABC(51, fs.nactvar - 1, 0, 0);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
    }

    int whenstat() {
        this.next();
        FuncState fs = this.fs;
        expdesc b = new expdesc();
        this.new_localvarliteral("(when)");
        this.adjustlocalvars(1);
        this.whenbody(b, this.linenumber);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
        return fs.codeABC(29, fs.nactvar - 1, 0, 2);
    }

    void whenstat(expdesc b) {
        FuncState fs = this.fs;
        this.new_localvarliteral("(when)");
        this.adjustlocalvars(1);
        this.whenbody(b, this.linenumber);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
        b.init(14, fs.codeABC(29, fs.nactvar - 1, 0, 0));
    }

    void trystat() {
        short ra = 0;
        short rb = 0;
        short rc = 0;
        boolean left = false;
        int line = this.linenumber;
        this.next();
        expdesc b = new expdesc();
        FuncState fs = this.fs;
        ra = fs.freereg;
        this.new_localvarliteral("(try)");
        this.adjustlocalvars(1);
        left = this.trybody(b, 287, this.linenumber);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
        if (this.testnext(260)) {
            rb = fs.freereg;
            this.new_localvarliteral("(catch)");
            this.adjustlocalvars(1);
            left = this.trybody(b, 260, this.linenumber);
            fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
        }
        if (this.testnext(269)) {
            rc = fs.freereg;
            this.new_localvarliteral("(finally)");
            this.adjustlocalvars(1);
            left = this.trybody(b, 269, this.linenumber);
            fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
        }
        if (!left) {
            this.check_match(267, 287, line);
        }
        fs.codeABC(53, ra, rb, rc);
    }

    void loadlist(int n) {
        LocVars[] ls = this.fs.f.locvars;
        expdesc var = new expdesc();
        short nl = this.fs.nlocvars;
        LuaString l = ls[nl - n].varname;
        FuncState.singlevaraux(this.fs, l, var, 1);
        for (int i = nl - n + 1; i < nl; ++i) {
            l = ls[i].varname;
            this.fs.exp2nextreg(var);
            FuncState.singlevaraux(this.fs, l, var, 1);
        }
        this.adjust_assign(n, n, var);
        this.adjustlocalvars(n);
    }

    void localstat() {
        int nexps;
        int nvars = 0;
        expdesc e = new expdesc();
        boolean def = this.testnext(61) || this.testnext(58);
        do {
            this.new_localvar(this.str_checkname());
            ++nvars;
        } while (this.testnext(44));
        if (def) {
            this.loadlist(nvars);
            return;
        }
        if (nvars == 1 && this.testtoken(40)) {
            expdesc b = new expdesc();
            this.adjustlocalvars(1);
            this.body(b, false, this.linenumber);
            this.fs.getlocvar((int)(this.fs.nactvar - 1)).startpc = this.fs.pc;
            return;
        }
        if (this.testnext(61)) {
            nexps = this.explist(e);
        } else {
            e.k = 0;
            nexps = 0;
        }
        this.adjust_assign(nvars, nexps, e);
        this.adjustlocalvars(nvars);
    }

    boolean funcname(expdesc v) {
        boolean ismethod = false;
        this.singlevar(v);
        while (this.t.token == 46) {
            this.fieldsel(v);
        }
        if (this.t.token == 58) {
            ismethod = true;
            this.fieldsel(v);
        }
        return ismethod;
    }

    void funcstat(int line) {
        expdesc v = new expdesc();
        expdesc b = new expdesc();
        this.next();
        boolean needself = this.funcname(v);
        this.body(b, needself, line);
        this.fs.storevar(v, b);
        this.fs.fixline(line);
    }

    void exprstat() {
        FuncState fs = this.fs;
        LHS_assign v = new LHS_assign();
        this.suffixedexp(v.v);
        if (this.t.token == 61 || this.t.token == 44) {
            v.prev = null;
            this.assignment(v, 1);
        } else {
            this.check_condition(v.v.k == 14, "syntax error");
            if (v.v.k == 14) {
                LexState.SETARG_C(fs.getcodePtr(v.v), 1);
            }
        }
    }

    void retstat() {
        int first;
        int nret;
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        if (this.block_follow(true) || this.t.token == 59) {
            nret = 0;
            first = 0;
        } else {
            nret = this.explist(e);
            if (this.hasmultret(e.k)) {
                fs.setmultret(e);
                if (e.k == 14 && nret == 1) {
                    LexState.SET_OPCODE(fs.getcodePtr(e), 30);
                    LexState._assert(Lua.GETARG_A(fs.getcode(e)) == fs.nactvar);
                }
                first = fs.nactvar;
                nret = -1;
            } else if (nret == 1) {
                first = fs.exp2anyreg(e);
            } else {
                fs.exp2nextreg(e);
                first = fs.nactvar;
                LexState._assert(nret == fs.freereg - first);
            }
        }
        fs.ret(first, nret);
        this.testnext(59);
    }

    void statement() {
        int line = this.linenumber;
        this.enterlevel();
        switch (this.t.token) {
            case 59: {
                this.next();
                break;
            }
            case 273: {
                this.ifstat(line);
                break;
            }
            case 290: {
                this.whilestat(line);
                break;
            }
            case 284: {
                this.switchstat(line);
                break;
            }
            case 264: {
                this.next();
                this.block();
                this.check_match(267, 264, line);
                break;
            }
            case 270: {
                this.forstat(line);
                break;
            }
            case 282: {
                this.repeatstat(line);
                break;
            }
            case 271: {
                this.funcstat(line);
                break;
            }
            case 274: {
                this.importstat();
                break;
            }
            case 278: {
                this.modulestat();
                break;
            }
            case 263: {
                this.deferstat();
                break;
            }
            case 289: {
                this.whenstat();
                break;
            }
            case 287: {
                this.trystat();
                break;
            }
            case 277: {
                this.next();
                if (this.testnext(271)) {
                    this.localfunc();
                    break;
                }
                this.localstat();
                break;
            }
            case 300: {
                this.next();
                this.labelstat(this.str_checkname(), line);
                break;
            }
            case 283: {
                this.next();
                this.retstat();
                break;
            }
            case 258: 
            case 261: {
                this.gotostat(this.fs.jump());
                if (this.block_follow(true)) break;
                this.syntaxerror("unreachable statement");
                break;
            }
            case 272: {
                this.gotostat(this.fs.jump());
                break;
            }
            default: {
                this.exprstat();
            }
        }
        if (this.fs.f.maxstacksize < this.fs.freereg || this.fs.freereg < this.fs.nactvar) {
            this.syntaxerror("statement");
        }
        this.fs.freereg = this.fs.nactvar;
        this.leavelevel();
    }

    void statlist() {
        while (!this.block_follow(true)) {
            if (this.t.token == 283) {
                this.statement();
                return;
            }
            this.statement();
        }
    }

    public void mainfunc(FuncState funcstate) {
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.open_func(funcstate, bl);
        this.fs.f.is_vararg = 1;
        expdesc v = new expdesc();
        v.init(7, 0);
        this.fs.newupvalue(this.envn, v);
        this.new_localvar(this.envn);
        expdesc env = new expdesc();
        FuncState.singlevaraux(this.fs, this.envn, env, 1);
        this.adjust_assign(1, 1, env);
        this.adjustlocalvars(1);
        this.next();
        if (this.testtoken(123) || this.testnext(304)) {
            this.retstat();
        } else {
            this.statlist();
        }
        this.check(301);
        this.close_func();
    }

    static {
        int i;
        RESERVED_LOCAL_VAR_KEYWORDS = new String[]{RESERVED_LOCAL_VAR_FOR_CONTROL, RESERVED_LOCAL_VAR_FOR_GENERATOR, RESERVED_LOCAL_VAR_FOR_INDEX, RESERVED_LOCAL_VAR_FOR_LIMIT, RESERVED_LOCAL_VAR_FOR_STATE, RESERVED_LOCAL_VAR_FOR_STEP};
        RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
        for (i = 0; i < RESERVED_LOCAL_VAR_KEYWORDS.length; ++i) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(RESERVED_LOCAL_VAR_KEYWORDS[i], Boolean.TRUE);
        }
        luaX_tokens = new String[]{"and", "break", "case", "catch", "continue", "default", "defer", "do", "else", "elseif", "end", "false", "finally", "for", "function", "goto", "if", "import", "in", "lambda", "local", "module", "nil", "not", "or", "repeat", "return", "switch", "then", "true", "try", "until", "when", "while", "..", "...", "==", ">=", "<=", "~=", "//", "<<", ">>", "::", "<eos>", "<number>", "<name>", "<string>", "<eof>"};
        luaX_cn_tokens = new String[]{"\u4e0e", "\u8df3\u51fa", "case", "\u6355\u83b7", "\u8df3\u8fc7", "\u9ed8\u8ba4", "\u5ef6\u65f6", "\u6267\u884c", "\u5426\u5219", "\u5426\u5219\u5982\u679c", "\u7ed3\u675f", "\u5047", "finally", "\u5faa\u73af", "\u51fd\u6570", "\u8df3\u8f6c", "\u5982\u679c", "\u5bfc\u5165", "\u5728", "lambda", "\u5c40\u90e8", "\u6a21\u5757", "\u65e0", "\u975e", "\u6216", "\u91cd\u590d", "\u8fd4\u56de", "switch", "\u90a3\u4e48", "\u771f", "\u5c1d\u8bd5", "\u76f4\u5230", "when", "\u5f53"};
        RESERVED = new Hashtable();
        for (i = 0; i < 34; ++i) {
            LuaString ts = LuaValue.valueOf(luaX_tokens[i]);
            RESERVED.put(ts, new Integer(257 + i));
        }
        luai_ctype_ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 4, 4, 4, 4, 4, 4, 4, 21, 21, 21, 21, 21, 21, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 5, 4, 21, 21, 21, 21, 21, 21, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        priority = new Priority[]{new Priority(10, 10), new Priority(10, 10), new Priority(11, 11), new Priority(11, 11), new Priority(14, 13), new Priority(11, 11), new Priority(11, 11), new Priority(6, 6), new Priority(4, 4), new Priority(5, 5), new Priority(7, 7), new Priority(7, 7), new Priority(9, 8), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(2, 2), new Priority(1, 1), new Priority(1, 1)};
    }

    static class LHS_assign {
        LHS_assign prev;
        expdesc v = new expdesc();

        LHS_assign() {
        }
    }

    static class Priority {
        final byte left;
        final byte right;

        public Priority(int i, int j) {
            this.left = (byte)i;
            this.right = (byte)j;
        }
    }

    static class ConsControl {
        expdesc v = new expdesc();
        expdesc t;
        int nh;
        int na;
        int tostore;

        ConsControl() {
        }
    }

    static class Dyndata {
        Vardesc[] actvar;
        int n_actvar = 0;
        Labeldesc[] gt;
        int n_gt = 0;
        Labeldesc[] label;
        int n_label = 0;

        Dyndata() {
        }
    }

    static class Labeldesc {
        LuaString name;
        int pc;
        int line;
        short nactvar;

        public Labeldesc(LuaString name, int pc, int line, short nactvar) {
            this.name = name;
            this.pc = pc;
            this.line = line;
            this.nactvar = nactvar;
        }
    }

    static class Vardesc {
        final short idx;

        Vardesc(int idx) {
            this.idx = (short)idx;
        }
    }

    static class expdesc {
        int k;
        final U u = new U();
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        expdesc() {
        }

        void init(int k, int i) {
            this.f.i = -1;
            this.t.i = -1;
            this.k = k;
            this.u.info = i;
        }

        boolean hasjumps() {
            return this.t.i != this.f.i;
        }

        boolean isnumeral() {
            return this.k == 5 && this.t.i == -1 && this.f.i == -1;
        }

        public void setvalue(expdesc other) {
            this.f.i = other.f.i;
            this.k = other.k;
            this.t.i = other.t.i;
            this.u._nval = other.u._nval;
            this.u.ind_idx = other.u.ind_idx;
            this.u.ind_t = other.u.ind_t;
            this.u.ind_vt = other.u.ind_vt;
            this.u.info = other.u.info;
        }

        protected expdesc clone() {
            expdesc c = new expdesc();
            c.setvalue(this);
            return c;
        }

        static class U {
            short ind_idx;
            short ind_t;
            short ind_vt;
            private LuaValue _nval;
            int info;

            U() {
            }

            public void setNval(LuaValue r) {
                this._nval = r;
            }

            public LuaValue nval() {
                return this._nval == null ? LuaInteger.valueOf(this.info) : this._nval;
            }
        }
    }

    private static class Token {
        int token;
        final SemInfo seminfo = new SemInfo();

        private Token() {
        }

        public void set(Token other) {
            this.token = other.token;
            this.seminfo.r = other.seminfo.r;
            this.seminfo.ts = other.seminfo.ts;
        }
    }

    private static class SemInfo {
        LuaValue r;
        LuaString ts;

        private SemInfo() {
        }
    }
}

