/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.OrphanedThread;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.DebugLib;

public class LuaThread
extends LuaValue {
    public static LuaValue s_metatable;
    public static int coroutine_count;
    public static long thread_orphan_check_interval;
    public static final int STATUS_INITIAL = 0;
    public static final int STATUS_SUSPENDED = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_NORMAL = 3;
    public static final int STATUS_DEAD = 4;
    public static final String[] STATUS_NAMES;
    public final State state;
    public static final int MAX_CALLSTACK = 256;
    public DebugLib.CallStack callstack;
    public final Globals globals;
    public final LuaTable registry = new LuaTable();
    public LuaValue errorfunc;

    public LuaThread(Globals globals) {
        this.state = new State(globals, this, null);
        this.state.status = 2;
        this.globals = globals;
        this.registry.set(1, (LuaValue)this);
        this.registry.set(2, (LuaValue)globals);
    }

    public LuaThread(Globals globals, LuaValue func) {
        LuaValue.assert_(func != null, "function cannot be null");
        this.state = new State(globals, this, func);
        this.globals = globals;
        this.registry.set(1, (LuaValue)this);
        this.registry.set(2, (LuaValue)globals);
    }

    @Override
    public int type() {
        return 8;
    }

    @Override
    public String typename() {
        return "thread";
    }

    @Override
    public boolean isthread() {
        return true;
    }

    @Override
    public LuaThread optthread(LuaThread defval) {
        return this;
    }

    @Override
    public LuaThread checkthread() {
        return this;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    public String getStatus() {
        return STATUS_NAMES[this.state.status];
    }

    public boolean isMainThread() {
        return this.state.function == null;
    }

    public Varargs resume(Varargs args) {
        State s = this.state;
        if (s.status > 1) {
            return LuaValue.varargsOf(LuaValue.FALSE, (Varargs)LuaValue.valueOf("cannot resume " + (s.status == 4 ? "dead" : "non-suspended") + " coroutine"));
        }
        return s.lua_resume(this, args);
    }

    static {
        coroutine_count = 0;
        thread_orphan_check_interval = 5000L;
        STATUS_NAMES = new String[]{"suspended", "suspended", "running", "normal", "dead"};
    }

    public static class State
    implements Runnable {
        private final Globals globals;
        final WeakReference lua_thread;
        public final LuaValue function;
        Varargs args = LuaValue.NONE;
        Varargs result = LuaValue.NONE;
        String error = null;
        public LuaValue hookfunc;
        public boolean hookline;
        public boolean hookcall;
        public boolean hookrtrn;
        public int hookcount;
        public boolean inhook;
        public int lastline;
        public int bytecodes;
        public int status = 0;

        State(Globals globals, LuaThread lua_thread, LuaValue function) {
            this.globals = globals;
            this.lua_thread = new WeakReference<LuaThread>(lua_thread);
            this.function = function;
        }

        @Override
        public synchronized void run() {
            try {
                Varargs a = this.args;
                this.args = LuaValue.NONE;
                this.result = this.function.invoke(a);
            }
            catch (Throwable t) {
                this.error = t.getMessage();
            }
            finally {
                this.status = 4;
                this.notify();
            }
        }

        public synchronized Varargs lua_resume(LuaThread new_thread, Varargs args) {
            LuaThread previous_thread = this.globals.running;
            try {
                this.globals.running = new_thread;
                this.args = args;
                if (this.status == 0) {
                    this.status = 2;
                    new Thread((Runnable)this, "Coroutine-" + ++coroutine_count).start();
                } else {
                    this.notify();
                }
                if (previous_thread != null) {
                    previous_thread.state.status = 3;
                }
                this.status = 2;
                this.wait();
                Varargs varargs = this.error != null ? LuaValue.varargsOf(LuaValue.FALSE, (Varargs)LuaValue.valueOf(this.error)) : LuaValue.varargsOf(LuaValue.TRUE, this.result);
                return varargs;
            }
            catch (InterruptedException ie) {
                throw new OrphanedThread();
            }
            finally {
                this.args = LuaValue.NONE;
                this.result = LuaValue.NONE;
                this.error = null;
                this.globals.running = previous_thread;
                if (previous_thread != null) {
                    this.globals.running.state.status = 2;
                }
            }
        }

        public synchronized Varargs lua_yield(Varargs args) {
            try {
                this.result = args;
                this.status = 1;
                this.notify();
                do {
                    this.wait(thread_orphan_check_interval);
                    if (this.lua_thread.get() != null) continue;
                    this.status = 4;
                    throw new OrphanedThread();
                } while (this.status == 1);
                Varargs varargs = this.args;
                return varargs;
            }
            catch (InterruptedException ie) {
                this.status = 4;
                throw new OrphanedThread();
            }
            finally {
                this.args = LuaValue.NONE;
                this.result = LuaValue.NONE;
            }
        }
    }
}

