/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.util.ArrayList;
import java.util.Vector;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Metatable;
import org.luaj.vm2.Varargs;

public class LuaList
extends LuaTable
implements Metatable {
    private static final LuaString N = LuaList.valueOf("n");
    private ArrayList<LuaValue> array = new ArrayList();
    protected Metatable m_metatable;
    private static final LuaTable.Slot[] NOBUCKETS = new LuaTable.Slot[0];

    public LuaList() {
        this.array = new ArrayList();
    }

    public LuaList(int narray) {
        this.array = new ArrayList(narray);
        this.presize(narray);
    }

    public LuaList(Varargs varargs) {
        this(varargs, 1);
    }

    public LuaList(Varargs varargs, int firstarg) {
        int nskip = firstarg - 1;
        int n = Math.max(varargs.narg() - nskip, 0);
        this.presize(n, 1);
        this.set(N, (LuaValue)LuaList.valueOf(n));
        for (int i = 1; i <= n; ++i) {
            this.set(i, varargs.arg(i + nskip));
        }
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public String typename() {
        return "table";
    }

    @Override
    public boolean istable() {
        return true;
    }

    @Override
    public LuaTable checktable() {
        return this;
    }

    @Override
    public LuaTable opttable(LuaTable defval) {
        return this;
    }

    @Override
    public void presize(int narray) {
    }

    @Override
    protected int getArrayLength() {
        return this.array.size();
    }

    @Override
    protected int getHashLength() {
        return 0;
    }

    @Override
    public LuaValue getmetatable() {
        return this.m_metatable != null ? this.m_metatable.toLuaValue() : null;
    }

    @Override
    public LuaValue setmetatable(LuaValue metatable) {
        boolean hadWeakKeys = this.m_metatable != null && this.m_metatable.useWeakKeys();
        boolean hadWeakValues = this.m_metatable != null && this.m_metatable.useWeakValues();
        this.m_metatable = LuaList.metatableOf(metatable);
        if (hadWeakKeys != (this.m_metatable != null && this.m_metatable.useWeakKeys()) || hadWeakValues != (this.m_metatable != null && this.m_metatable.useWeakValues())) {
            // empty if block
        }
        return this;
    }

    @Override
    public LuaValue get(int key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaList.gettable(this, LuaList.valueOf(key)) : v;
    }

    @Override
    public LuaValue get(LuaValue key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaList.gettable(this, key) : v;
    }

    @Override
    public LuaValue rawget(int key) {
        if (key > 0 && key <= this.array.size()) {
            LuaValue[] arr = new LuaValue[this.array.size()];
            this.array.toArray(arr);
            LuaValue v = this.m_metatable == null ? this.array.get(key - 1) : this.m_metatable.arrayget(arr, key - 1);
            return v != null ? v : NIL;
        }
        return NIL;
    }

    @Override
    public LuaValue rawget(LuaValue key) {
        if (key.eq_b(N)) {
            return LuaInteger.valueOf(this.rawlen());
        }
        if (!key.isinttype()) {
            throw new LuaError("array key only integer");
        }
        int ikey = key.toint();
        if (ikey > 0 && ikey <= this.array.size()) {
            LuaValue[] arr = new LuaValue[this.array.size()];
            this.array.toArray(arr);
            LuaValue v = this.m_metatable == null ? this.array.get(ikey - 1) : this.m_metatable.arrayget(arr, ikey - 1);
            return v != null ? v : NIL;
        }
        return LuaValue.NIL;
    }

    @Override
    public void set(int key, LuaValue value) {
        if (this.mConst) {
            throw new LuaError("can not be set a const table");
        }
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaList.settable(this, LuaInteger.valueOf(key), value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        if (this.mConst) {
            throw new LuaError("can not be set a const table");
        }
        if (!key.isvalidkey() && !this.metatag(NEWINDEX).isfunction()) {
            this.typerror("table index");
        }
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaList.settable(this, key, value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void rawset(int key, LuaValue value) {
        if (this.mConst) {
            throw new LuaError("can not be set a const table");
        }
        this.arrayset(key, value);
    }

    @Override
    public void rawset(LuaValue key, LuaValue value) {
        if (this.mConst) {
            throw new LuaError("can not be set a const table");
        }
        if (key.eq_b(N)) {
            this.fullList(value.checkint());
            return;
        }
        if (!key.isinttype()) {
            throw new LuaError("array key only integer");
        }
        this.arrayset(key.toint(), value);
    }

    private boolean arrayset(int key, LuaValue value) {
        if (key - 1 == this.array.size()) {
            this.array.add(value);
            return true;
        }
        if (key > 0 && key <= this.array.size()) {
            this.array.set(key - 1, value.isnil() ? null : (this.m_metatable != null ? this.m_metatable.wrap(value) : value));
            return true;
        }
        throw new LuaError("array insert position out of bounds");
    }

    private void fullList(int key) {
        int i;
        for (i = this.array.size(); i < key; ++i) {
            this.array.add(LuaValue.NIL);
        }
        for (i = this.array.size() - 1; i >= key; --i) {
            this.array.remove(i);
        }
    }

    @Override
    public LuaValue remove(int pos) {
        int n = this.rawlen();
        if (pos == 0) {
            pos = n;
        } else if (pos > n) {
            return NONE;
        }
        LuaValue v = this.rawget(pos);
        this.array.remove(pos - 1);
        return v.isnil() ? NONE : v;
    }

    @Override
    public void insert(int pos, LuaValue value) {
        if (pos == 0) {
            pos = this.rawlen() + 1;
        }
        if (pos == this.array.size() + 1) {
            this.array.add(value);
        } else if (pos > 0 && pos <= this.array.size()) {
            this.array.add(pos, value);
        } else {
            throw new LuaError("array insert position out of bounds");
        }
    }

    @Override
    public LuaValue concat(LuaString sep, int i, int j) {
        Buffer sb = new Buffer();
        if (i <= j) {
            sb.append(this.get(i).checkstring());
            while (++i <= j) {
                sb.append(sep);
                sb.append(this.get(i).checkstring());
            }
        }
        return sb.tostring();
    }

    @Override
    public int length() {
        return this.m_metatable != null ? this.len().toint() : this.rawlen();
    }

    @Override
    public LuaValue len() {
        LuaValue h = this.metatag(LEN);
        if (h.toboolean()) {
            return h.call(this);
        }
        return LuaInteger.valueOf(this.rawlen());
    }

    @Override
    public int rawlen() {
        int a = this.getArrayLength();
        int n = a + 1;
        int m = 0;
        while (n > m + 1) {
            int k = (n + m) / 2;
            if (!this.rawget(k).isnil()) {
                m = k;
                continue;
            }
            n = k;
        }
        return m;
    }

    @Override
    public Varargs next(LuaValue key) {
        int i = 0;
        if (!(key.isnil() || key.isinttype() && (i = key.toint()) > 0 && i <= this.array.size())) {
            i += 1 + this.array.size();
        }
        LuaValue[] arr = new LuaValue[this.array.size()];
        this.array.toArray(arr);
        while (i < this.array.size()) {
            if (this.array.get(i) != null) {
                LuaValue value;
                LuaValue luaValue = value = this.m_metatable == null ? this.array.get(i) : this.m_metatable.arrayget(arr, i);
                if (value != null) {
                    return LuaList.varargsOf(LuaInteger.valueOf(i + 1), (Varargs)value);
                }
            }
            ++i;
        }
        return NIL;
    }

    @Override
    public Varargs inext(LuaValue key) {
        int k = key.checkint() + 1;
        LuaValue v = this.rawget(k);
        return v.isnil() ? NONE : LuaList.varargsOf(LuaInteger.valueOf(k), (Varargs)v);
    }

    private void dropWeakArrayValues() {
        LuaValue[] arr = new LuaValue[this.array.size()];
        this.array.toArray(arr);
        for (int i = 0; i < this.array.size(); ++i) {
            this.m_metatable.arrayget(arr, i);
        }
    }

    private int countIntKeys(int[] nums) {
        int total = 0;
        int i = 1;
        for (int bit = 0; bit < 31 && i <= this.array.size(); ++bit) {
            int j = Math.min(this.array.size(), 1 << bit);
            int c = 0;
            while (i <= j) {
                if (this.array.get(i++ - 1) == null) continue;
                ++c;
            }
            nums[bit] = c;
            total += c;
        }
        return total;
    }

    @Override
    public void sort(LuaValue comparator) {
        int n;
        if (this.m_metatable != null && this.m_metatable.useWeakValues()) {
            this.dropWeakArrayValues();
        }
        for (n = this.array.size(); n > 0 && this.array.get(n - 1) == null; --n) {
        }
        if (n > 1) {
            this.heapSort(n, comparator);
        }
    }

    private void heapSort(int count, LuaValue cmpfunc) {
        this.heapify(count, cmpfunc);
        int end = count - 1;
        while (end > 0) {
            this.swap(end, 0);
            this.siftDown(0, --end, cmpfunc);
        }
    }

    private void heapify(int count, LuaValue cmpfunc) {
        for (int start = count / 2 - 1; start >= 0; --start) {
            this.siftDown(start, count - 1, cmpfunc);
        }
    }

    private void siftDown(int start, int end, LuaValue cmpfunc) {
        int root = start;
        while (root * 2 + 1 <= end) {
            int child = root * 2 + 1;
            if (child < end && this.compare(child, child + 1, cmpfunc)) {
                ++child;
            }
            if (this.compare(root, child, cmpfunc)) {
                this.swap(root, child);
                root = child;
                continue;
            }
            return;
        }
    }

    private boolean compare(int i, int j, LuaValue cmpfunc) {
        LuaValue b;
        LuaValue a;
        LuaValue[] arr = new LuaValue[this.array.size()];
        this.array.toArray(arr);
        if (this.m_metatable == null) {
            a = this.array.get(i);
            b = this.array.get(j);
        } else {
            a = this.m_metatable.arrayget(arr, i);
            b = this.m_metatable.arrayget(arr, j);
        }
        if (a == null || b == null) {
            return false;
        }
        if (!cmpfunc.isnil()) {
            return cmpfunc.call(a, b).toboolean();
        }
        return a.lt_b(b);
    }

    private void swap(int i, int j) {
        LuaValue a = this.array.get(i);
        this.array.set(i, this.array.get(j));
        this.array.set(j, a);
    }

    @Override
    public int keyCount() {
        LuaValue k = LuaValue.NIL;
        int i = 0;
        Varargs n;
        while (!(k = (n = this.next(k)).arg1()).isnil()) {
            ++i;
        }
        return i;
    }

    @Override
    public LuaValue[] keys() {
        Varargs n;
        Vector<LuaValue> l = new Vector<LuaValue>();
        LuaValue k = LuaValue.NIL;
        while (!(k = (n = this.next(k)).arg1()).isnil()) {
            l.addElement(k);
        }
        Object[] a = new LuaValue[l.size()];
        l.copyInto(a);
        return a;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return this.eq_b(val) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        if (this == val) {
            return true;
        }
        if (this.m_metatable == null || !val.istable()) {
            return false;
        }
        LuaValue valmt = val.getmetatable();
        return valmt != null && LuaValue.eqmtcall(this, this.m_metatable.toLuaValue(), val, valmt);
    }

    @Override
    public Varargs unpack() {
        return this.unpack(1, this.array.size());
    }

    @Override
    public Varargs unpack(int i) {
        return this.unpack(i, this.array.size());
    }

    @Override
    public Varargs unpack(int i, int j) {
        int n = j + 1 - i;
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return this.get(i);
            }
            case 2: {
                return LuaList.varargsOf(this.get(i), (Varargs)this.get(i + 1));
            }
        }
        if (n < 0) {
            return NONE;
        }
        LuaValue[] v = new LuaValue[n];
        while (--n >= 0) {
            v[n] = this.get(i + n);
        }
        return LuaList.varargsOf(v);
    }

    @Override
    public boolean useWeakKeys() {
        return false;
    }

    @Override
    public boolean useWeakValues() {
        return false;
    }

    @Override
    public LuaValue toLuaValue() {
        return this;
    }

    @Override
    public LuaValue wrap(LuaValue value) {
        return value;
    }

    @Override
    public LuaValue arrayget(LuaValue[] array, int index) {
        return array[index];
    }
}

