/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.LuajavaLib;

public class CoerceLuaToJava {
    static int SCORE_NULL_VALUE = 16;
    static int SCORE_WRONG_TYPE = 256;
    static int SCORE_UNCOERCIBLE = 65536;
    static final Map COERCIONS = Collections.synchronizedMap(new HashMap());

    public static Object coerce(LuaValue value, Class clazz) {
        return CoerceLuaToJava.getCoercion(clazz).coerce(value);
    }

    static final int inheritanceLevels(Class baseclass, Class subclass) {
        if (subclass == null) {
            return SCORE_UNCOERCIBLE;
        }
        if (baseclass == subclass) {
            return 0;
        }
        int min2 = Math.min(SCORE_UNCOERCIBLE, CoerceLuaToJava.inheritanceLevels(baseclass, subclass.getSuperclass()) + 1);
        Class<?>[] ifaces = subclass.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            min2 = Math.min(min2, CoerceLuaToJava.inheritanceLevels(baseclass, ifaces[i]) + 1);
        }
        return min2;
    }

    static Coercion getCoercion(Class c) {
        Coercion co = (Coercion)COERCIONS.get(c);
        if (co != null) {
            return co;
        }
        co = c.isArray() ? new ArrayCoercion(c.getComponentType()) : (Map.class.isAssignableFrom(c) ? new MapCoercion(c) : (List.class.isAssignableFrom(c) ? new ListCoercion(c) : new ObjectCoercion(c)));
        COERCIONS.put(c, co);
        return co;
    }

    static {
        BoolCoercion boolCoercion = new BoolCoercion();
        NumericCoercion byteCoercion = new NumericCoercion(0);
        NumericCoercion charCoercion = new NumericCoercion(1);
        NumericCoercion shortCoercion = new NumericCoercion(2);
        NumericCoercion intCoercion = new NumericCoercion(3);
        NumericCoercion longCoercion = new NumericCoercion(4);
        NumericCoercion floatCoercion = new NumericCoercion(5);
        NumericCoercion doubleCoercion = new NumericCoercion(6);
        StringCoercion stringCoercion = new StringCoercion(0);
        StringCoercion bytesCoercion = new StringCoercion(1);
        COERCIONS.put(Boolean.TYPE, boolCoercion);
        COERCIONS.put(Boolean.class, boolCoercion);
        COERCIONS.put(Byte.TYPE, byteCoercion);
        COERCIONS.put(Byte.class, byteCoercion);
        COERCIONS.put(Character.TYPE, charCoercion);
        COERCIONS.put(Character.class, charCoercion);
        COERCIONS.put(Short.TYPE, shortCoercion);
        COERCIONS.put(Short.class, shortCoercion);
        COERCIONS.put(Integer.TYPE, intCoercion);
        COERCIONS.put(Integer.class, intCoercion);
        COERCIONS.put(Long.TYPE, longCoercion);
        COERCIONS.put(Long.class, longCoercion);
        COERCIONS.put(Float.TYPE, floatCoercion);
        COERCIONS.put(Float.class, floatCoercion);
        COERCIONS.put(Double.TYPE, doubleCoercion);
        COERCIONS.put(Double.class, doubleCoercion);
        COERCIONS.put(String.class, stringCoercion);
        COERCIONS.put(byte[].class, bytesCoercion);
    }

    static final class ObjectCoercion
    implements Coercion {
        final Class targetType;

        ObjectCoercion(Class targetType) {
            this.targetType = targetType;
        }

        public String toString() {
            return "ObjectCoercion(" + this.targetType.getName() + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 3: {
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, value.isint() ? Integer.class : Double.class);
                }
                case 1: {
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, Boolean.class);
                }
                case 4: {
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, String.class);
                }
                case 7: {
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, value.touserdata().getClass());
                }
                case 5: {
                    if (this.targetType.isInterface()) {
                        return 10;
                    }
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, LuaTable.class);
                }
                case 6: {
                    if (this.targetType.isInterface()) {
                        return 10;
                    }
                    return CoerceLuaToJava.inheritanceLevels(this.targetType, LuaFunction.class);
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return CoerceLuaToJava.inheritanceLevels(this.targetType, value.getClass());
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (value.type()) {
                case 3: {
                    return value.isint() ? (Number)new Integer(value.toint()) : (Number)new Double(value.todouble());
                }
                case 1: {
                    return value.toboolean() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 4: {
                    return value.tojstring();
                }
                case 7: {
                    return value.optuserdata(this.targetType, null);
                }
                case 5: 
                case 6: {
                    if (this.targetType.isInterface()) {
                        return LuajavaLib.createProxy(this.targetType, value).touserdata();
                    }
                    return value;
                }
                case 0: {
                    return null;
                }
            }
            return value;
        }
    }

    static final class InterFaceCoercion
    implements Coercion {
        final Class componentType;
        final Coercion componentCoercion;

        public InterFaceCoercion(Class componentType) {
            this.componentType = componentType;
            this.componentCoercion = new ObjectCoercion(componentType);
        }

        public String toString() {
            return "InterFaceCoercion(" + this.componentType.getName() + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 5: 
                case 6: {
                    return 0;
                }
                case 7: {
                    return CoerceLuaToJava.inheritanceLevels(this.componentType, value.touserdata().getClass());
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return SCORE_UNCOERCIBLE;
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    return LuajavaLib.createProxy(this.componentType, value);
                }
                case 7: {
                    return value.touserdata();
                }
                case 0: {
                    return null;
                }
            }
            return null;
        }
    }

    static final class MapCoercion
    implements Coercion {
        final Class componentType;
        final Coercion componentCoercion;

        public MapCoercion(Class componentType) {
            this.componentType = componentType;
            this.componentCoercion = new ObjectCoercion(Object.class);
        }

        public String toString() {
            return "MapCoercion(" + this.componentType.getName() + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    return 0;
                }
                case 7: {
                    return CoerceLuaToJava.inheritanceLevels(this.componentType, value.touserdata().getClass());
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return SCORE_UNCOERCIBLE;
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    try {
                        Map map = this.componentType.equals(Map.class) ? new HashMap() : (Map)this.componentType.newInstance();
                        Varargs ret = value.next(LuaValue.NIL);
                        while (ret != LuaValue.NIL) {
                            LuaValue k = ret.arg1();
                            map.put(this.componentCoercion.coerce(k), this.componentCoercion.coerce(ret.arg(2)));
                            ret = value.next(k);
                        }
                        return map;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                case 7: {
                    return value.touserdata();
                }
                case 0: {
                    return null;
                }
            }
            return null;
        }
    }

    static final class ListCoercion
    implements Coercion {
        final Class componentType;
        final Coercion componentCoercion;

        public ListCoercion(Class componentType) {
            this.componentType = componentType;
            this.componentCoercion = new ObjectCoercion(Object.class);
        }

        public String toString() {
            return "ListCoercion(" + this.componentType.getName() + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    return 0;
                }
                case 7: {
                    return CoerceLuaToJava.inheritanceLevels(this.componentType, value.touserdata().getClass());
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return SCORE_UNCOERCIBLE;
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    try {
                        List list = this.componentType.equals(Map.class) ? new ArrayList() : (List)this.componentType.newInstance();
                        int n = value.length();
                        for (int i = 0; i < n; ++i) {
                            list.add(this.componentCoercion.coerce(value.get(i + 1)));
                        }
                        return list;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                case 7: {
                    return value.touserdata();
                }
                case 0: {
                    return null;
                }
            }
            return null;
        }
    }

    static final class ArrayCoercion
    implements Coercion {
        final Class componentType;
        final Coercion componentCoercion;

        public ArrayCoercion(Class componentType) {
            this.componentType = componentType;
            this.componentCoercion = CoerceLuaToJava.getCoercion(componentType);
        }

        public String toString() {
            return "ArrayCoercion(" + this.componentType.getName() + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    return value.length() == 0 ? 0 : this.check(value);
                }
                case 7: {
                    return CoerceLuaToJava.inheritanceLevels(this.componentType, value.touserdata().getClass().getComponentType());
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return SCORE_UNCOERCIBLE;
        }

        private int check(LuaValue value) {
            int n = 0;
            int len2 = value.length();
            int s = 1;
            if (len2 > 10) {
                s = len2 / 10;
            }
            for (int i = 0; i < len2; i += s) {
                int r = this.componentCoercion.score(value.get(i));
                if (r > n) {
                    n = r;
                }
                if (r == SCORE_WRONG_TYPE) break;
            }
            return n;
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (value.type()) {
                case 5: {
                    int n = value.length();
                    Object a = Array.newInstance(this.componentType, n);
                    for (int i = 0; i < n; ++i) {
                        Array.set(a, i, this.componentCoercion.coerce(value.get(i + 1)));
                    }
                    return a;
                }
                case 7: {
                    return value.touserdata();
                }
                case 0: {
                    return null;
                }
            }
            return null;
        }
    }

    static final class StringCoercion
    implements Coercion {
        public static final int TARGET_TYPE_STRING = 0;
        public static final int TARGET_TYPE_BYTES = 1;
        final int targetType;

        public StringCoercion(int targetType) {
            this.targetType = targetType;
        }

        public String toString() {
            return "StringCoercion(" + (this.targetType == 0 ? "String" : "byte[]") + ")";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 4: {
                    return value.checkstring().isValidUtf8() ? (this.targetType == 0 ? 0 : 1) : (this.targetType == 1 ? 0 : SCORE_WRONG_TYPE);
                }
                case 0: {
                    return SCORE_NULL_VALUE;
                }
            }
            return this.targetType == 0 ? SCORE_WRONG_TYPE : SCORE_UNCOERCIBLE;
        }

        @Override
        public Object coerce(LuaValue value) {
            if (value.isnil()) {
                return null;
            }
            if (this.targetType == 0) {
                return value.tojstring();
            }
            LuaString s = value.checkstring();
            byte[] b = new byte[s.m_length];
            s.copyInto(0, b, 0, b.length);
            return b;
        }
    }

    static final class NumericCoercion
    implements Coercion {
        static final int TARGET_TYPE_BYTE = 0;
        static final int TARGET_TYPE_CHAR = 1;
        static final int TARGET_TYPE_SHORT = 2;
        static final int TARGET_TYPE_INT = 3;
        static final int TARGET_TYPE_LONG = 4;
        static final int TARGET_TYPE_FLOAT = 5;
        static final int TARGET_TYPE_DOUBLE = 6;
        static final String[] TYPE_NAMES = new String[]{"byte", "char", "short", "int", "long", "float", "double"};
        final int targetType;

        public String toString() {
            return "NumericCoercion(" + TYPE_NAMES[this.targetType] + ")";
        }

        NumericCoercion(int targetType) {
            this.targetType = targetType;
        }

        @Override
        public int score(LuaValue value) {
            int fromStringPenalty = 0;
            if (value.type() == 4) {
                if ((value = value.tonumber()).isnil()) {
                    return SCORE_UNCOERCIBLE;
                }
                fromStringPenalty = 4;
            }
            if (value.isint()) {
                switch (this.targetType) {
                    case 0: {
                        int i = value.toint();
                        return fromStringPenalty + (i == (byte)i ? 0 : SCORE_WRONG_TYPE);
                    }
                    case 1: {
                        int i = value.toint();
                        return fromStringPenalty + (i == (byte)i ? 1 : (i == (char)i ? 0 : SCORE_WRONG_TYPE));
                    }
                    case 2: {
                        int i = value.toint();
                        return fromStringPenalty + (i == (byte)i ? 1 : (i == (short)i ? 0 : SCORE_WRONG_TYPE));
                    }
                    case 3: {
                        long i = value.tolong();
                        return fromStringPenalty + (i == (long)((byte)i) ? 2 : (i == (long)((char)i) || i == (long)((short)i) ? 1 : (i == (long)((int)i) ? 0 : SCORE_WRONG_TYPE)));
                    }
                    case 4: {
                        long i = value.tolong();
                        return fromStringPenalty + (i == (long)((byte)i) ? 3 : (i == (long)((char)i) || i == (long)((short)i) ? 2 : (i == (long)((int)i) ? 1 : 0)));
                    }
                    case 5: {
                        return fromStringPenalty + 1;
                    }
                    case 6: {
                        return fromStringPenalty + 2;
                    }
                }
                return SCORE_WRONG_TYPE;
            }
            if (value.isnumber()) {
                switch (this.targetType) {
                    case 0: {
                        return SCORE_WRONG_TYPE;
                    }
                    case 1: {
                        return SCORE_WRONG_TYPE;
                    }
                    case 2: {
                        return SCORE_WRONG_TYPE;
                    }
                    case 3: {
                        return SCORE_WRONG_TYPE;
                    }
                    case 4: {
                        double d = value.todouble();
                        return fromStringPenalty + (d == (double)((long)d) ? 0 : SCORE_WRONG_TYPE);
                    }
                    case 5: {
                        double d = value.todouble();
                        return fromStringPenalty + (d == (double)((float)d) ? 0 : SCORE_WRONG_TYPE);
                    }
                    case 6: {
                        double d = value.todouble();
                        return fromStringPenalty + (d == (double)((long)d) || d == (double)((float)d) ? 1 : 0);
                    }
                }
                return SCORE_WRONG_TYPE;
            }
            return SCORE_UNCOERCIBLE;
        }

        @Override
        public Object coerce(LuaValue value) {
            switch (this.targetType) {
                case 0: {
                    return new Byte((byte)value.toint());
                }
                case 1: {
                    return new Character((char)value.toint());
                }
                case 2: {
                    return new Short((short)value.toint());
                }
                case 3: {
                    return new Integer(value.toint());
                }
                case 4: {
                    return new Long(value.tolong());
                }
                case 5: {
                    return new Float((float)value.todouble());
                }
                case 6: {
                    return new Double(value.todouble());
                }
            }
            return null;
        }
    }

    static final class BoolCoercion
    implements Coercion {
        BoolCoercion() {
        }

        public String toString() {
            return "BoolCoercion()";
        }

        @Override
        public int score(LuaValue value) {
            switch (value.type()) {
                case 1: {
                    return 0;
                }
            }
            return 32;
        }

        @Override
        public Object coerce(LuaValue value) {
            return value.toboolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static interface Coercion {
        public int score(LuaValue var1);

        public Object coerce(LuaValue var1);
    }
}

