/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class CoroutineLib
extends TwoArgFunction {
    static int coroutine_count = 0;
    Globals globals;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        LuaTable coroutine = new LuaTable();
        coroutine.set("create", (LuaValue)new create());
        coroutine.set("resume", (LuaValue)new resume());
        coroutine.set("running", (LuaValue)new running());
        coroutine.set("status", (LuaValue)new status());
        coroutine.set("yield", (LuaValue)new yield());
        coroutine.set("wrap", (LuaValue)new wrap());
        env.set("coroutine", (LuaValue)coroutine);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("coroutine", (LuaValue)coroutine);
        }
        return coroutine;
    }

    static final class wrapper
    extends VarArgFunction {
        final LuaThread luathread;

        wrapper(LuaThread luathread) {
            this.luathread = luathread;
        }

        @Override
        public Varargs invoke(Varargs args) {
            Varargs result = this.luathread.resume(args);
            if (result.arg1().toboolean()) {
                return result.subargs(2);
            }
            return wrapper.error(result.arg(2).tojstring());
        }
    }

    final class wrap
    extends LibFunction {
        wrap() {
        }

        @Override
        public LuaValue call(LuaValue f) {
            LuaFunction func = f.checkfunction();
            LuaThread thread = new LuaThread(CoroutineLib.this.globals, func);
            return new wrapper(thread);
        }
    }

    final class yield
    extends VarArgFunction {
        yield() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return CoroutineLib.this.globals.yield(args);
        }
    }

    static final class status
    extends LibFunction {
        status() {
        }

        @Override
        public LuaValue call(LuaValue t) {
            LuaThread lt = t.checkthread();
            return status.valueOf(lt.getStatus());
        }
    }

    final class running
    extends VarArgFunction {
        running() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaThread r = CoroutineLib.this.globals.running;
            return running.varargsOf(r, (Varargs)running.valueOf(r.isMainThread()));
        }
    }

    static final class resume
    extends VarArgFunction {
        resume() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaThread t = args.checkthread(1);
            return t.resume(args.subargs(2));
        }
    }

    final class create
    extends LibFunction {
        create() {
        }

        @Override
        public LuaValue call(LuaValue f) {
            return new LuaThread(CoroutineLib.this.globals, f.checkfunction());
        }
    }
}

