/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.List;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.TableField;

public abstract class Visitor {
    public void visit(Chunk chunk) {
        chunk.block.accept(this);
    }

    public void visit(Block block) {
        this.visit(block.scope);
        if (block.stats != null) {
            int n = block.stats.size();
            for (int i = 0; i < n; ++i) {
                block.stats.get(i).accept(this);
            }
        }
    }

    public void visit(Stat.Assign stat) {
        this.visitVars(stat.vars);
        this.visitExps(stat.exps);
    }

    public void visit(Stat.Break breakstat) {
    }

    public void visit(Stat.FuncCallStat stat) {
        stat.funccall.accept(this);
    }

    public void visit(Stat.FuncDef stat) {
        stat.body.accept(this);
    }

    public void visit(Stat.GenericFor stat) {
        this.visit(stat.scope);
        this.visitNames(stat.names);
        this.visitExps(stat.exps);
        stat.block.accept(this);
    }

    public void visit(Stat.IfThenElse stat) {
        stat.ifexp.accept(this);
        stat.ifblock.accept(this);
        if (stat.elseifblocks != null) {
            int n = stat.elseifblocks.size();
            for (int i = 0; i < n; ++i) {
                stat.elseifexps.get(i).accept(this);
                stat.elseifblocks.get(i).accept(this);
            }
        }
        if (stat.elseblock != null) {
            this.visit(stat.elseblock);
        }
    }

    public void visit(Stat.LocalAssign stat) {
        this.visitNames(stat.names);
        this.visitExps(stat.values);
    }

    public void visit(Stat.LocalFuncDef stat) {
        this.visit(stat.name);
        stat.body.accept(this);
    }

    public void visit(Stat.NumericFor stat) {
        this.visit(stat.scope);
        this.visit(stat.name);
        stat.initial.accept(this);
        stat.limit.accept(this);
        if (stat.step != null) {
            stat.step.accept(this);
        }
        stat.block.accept(this);
    }

    public void visit(Stat.RepeatUntil stat) {
        stat.block.accept(this);
        stat.exp.accept(this);
    }

    public void visit(Stat.Return stat) {
        this.visitExps(stat.values);
    }

    public void visit(Stat.WhileDo stat) {
        stat.exp.accept(this);
        stat.block.accept(this);
    }

    public void visit(FuncBody body) {
        this.visit(body.scope);
        body.parlist.accept(this);
        body.block.accept(this);
    }

    public void visit(FuncArgs args) {
        this.visitExps(args.exps);
    }

    public void visit(TableField field) {
        if (field.name != null) {
            this.visit(field.name);
        }
        if (field.index != null) {
            field.index.accept(this);
        }
        field.rhs.accept(this);
    }

    public void visit(Exp.AnonFuncDef exp2) {
        exp2.body.accept(this);
    }

    public void visit(Exp.BinopExp exp2) {
        exp2.lhs.accept(this);
        exp2.rhs.accept(this);
    }

    public void visit(Exp.Constant exp2) {
    }

    public void visit(Exp.FieldExp exp2) {
        exp2.lhs.accept(this);
        this.visit(exp2.name);
    }

    public void visit(Exp.FuncCall exp2) {
        exp2.lhs.accept(this);
        exp2.args.accept(this);
    }

    public void visit(Exp.IndexExp exp2) {
        exp2.lhs.accept(this);
        exp2.exp.accept(this);
    }

    public void visit(Exp.MethodCall exp2) {
        exp2.lhs.accept(this);
        this.visit(exp2.name);
        exp2.args.accept(this);
    }

    public void visit(Exp.NameExp exp2) {
        this.visit(exp2.name);
    }

    public void visit(Exp.ParensExp exp2) {
        exp2.exp.accept(this);
    }

    public void visit(Exp.UnopExp exp2) {
        exp2.rhs.accept(this);
    }

    public void visit(Exp.VarargsExp exp2) {
    }

    public void visit(ParList pars) {
        this.visitNames(pars.names);
    }

    public void visit(TableConstructor table) {
        if (table.fields != null) {
            int n = table.fields.size();
            for (int i = 0; i < n; ++i) {
                table.fields.get(i).accept(this);
            }
        }
    }

    public void visitVars(List<Exp.VarExp> vars) {
        if (vars != null) {
            int n = vars.size();
            for (int i = 0; i < n; ++i) {
                vars.get(i).accept(this);
            }
        }
    }

    public void visitExps(List<Exp> exps) {
        if (exps != null) {
            int n = exps.size();
            for (int i = 0; i < n; ++i) {
                exps.get(i).accept(this);
            }
        }
    }

    public void visitNames(List<Name> names) {
        if (names != null) {
            int n = names.size();
            for (int i = 0; i < n; ++i) {
                this.visit(names.get(i));
            }
        }
    }

    public void visit(Name name) {
    }

    public void visit(String name) {
    }

    public void visit(NameScope scope) {
    }

    public void visit(Stat.Goto gotostat) {
    }

    public void visit(Stat.Label label) {
    }
}

