/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.luaj.vm2.LuaString;

public class Str {
    private Str() {
    }

    public static LuaString quoteString(String image) {
        String s = image.substring(1, image.length() - 1);
        byte[] bytes = Str.unquote(s);
        return LuaString.valueUsing(bytes);
    }

    public static LuaString charString(String image) {
        String s = image.substring(1, image.length() - 1);
        byte[] bytes = Str.unquote(s);
        return LuaString.valueUsing(bytes);
    }

    public static LuaString longString(String image) {
        int i = image.indexOf(91, image.indexOf(91) + 1) + 1;
        String s = image.substring(i, image.length() - i);
        byte[] b = Str.iso88591bytes(s);
        return LuaString.valueUsing(b);
    }

    public static byte[] iso88591bytes(String s) {
        try {
            return s.getBytes("ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ISO8859-1 not supported");
        }
    }

    public static byte[] unquote(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        char[] c = s.toCharArray();
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            if (c[i] == '\\' && i < n) {
                switch (c[++i]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int d = c[i++] - 48;
                        for (int j = 0; i < n && j < 2 && c[i] >= '0' && c[i] <= '9'; ++i, ++j) {
                            d = d * 10 + (c[i] - 48);
                        }
                        baos.write((byte)d);
                        --i;
                        break;
                    }
                    case 'a': {
                        baos.write(7);
                        break;
                    }
                    case 'b': {
                        baos.write(8);
                        break;
                    }
                    case 'f': {
                        baos.write(12);
                        break;
                    }
                    case 'n': {
                        baos.write(10);
                        break;
                    }
                    case 'r': {
                        baos.write(13);
                        break;
                    }
                    case 't': {
                        baos.write(9);
                        break;
                    }
                    case 'v': {
                        baos.write(11);
                        break;
                    }
                    case '\"': {
                        baos.write(34);
                        break;
                    }
                    case '\'': {
                        baos.write(39);
                        break;
                    }
                    case '\\': {
                        baos.write(92);
                        break;
                    }
                    default: {
                        baos.write((byte)c[i]);
                        break;
                    }
                }
                continue;
            }
            baos.write((byte)c[i]);
        }
        return baos.toByteArray();
    }
}

