/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.List;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.Variable;
import org.luaj.vm2.ast.Visitor;

public class NameResolver
extends Visitor {
    private NameScope scope = null;

    private void pushScope() {
        this.scope = new NameScope(this.scope);
    }

    private void popScope() {
        this.scope = this.scope.outerScope;
    }

    @Override
    public void visit(NameScope scope) {
    }

    @Override
    public void visit(Block block) {
        this.pushScope();
        block.scope = this.scope;
        super.visit(block);
        this.popScope();
    }

    @Override
    public void visit(FuncBody body) {
        this.pushScope();
        ++this.scope.functionNestingCount;
        body.scope = this.scope;
        super.visit(body);
        this.popScope();
    }

    @Override
    public void visit(Stat.LocalFuncDef stat) {
        this.defineLocalVar(stat.name);
        super.visit(stat);
    }

    @Override
    public void visit(Stat.NumericFor stat) {
        this.pushScope();
        stat.scope = this.scope;
        this.defineLocalVar(stat.name);
        super.visit(stat);
        this.popScope();
    }

    @Override
    public void visit(Stat.GenericFor stat) {
        this.pushScope();
        stat.scope = this.scope;
        this.defineLocalVars(stat.names);
        super.visit(stat);
        this.popScope();
    }

    @Override
    public void visit(Exp.NameExp exp2) {
        exp2.name.variable = this.resolveNameReference(exp2.name);
        super.visit(exp2);
    }

    @Override
    public void visit(Stat.FuncDef stat) {
        stat.name.name.variable = this.resolveNameReference(stat.name.name);
        stat.name.name.variable.hasassignments = true;
        super.visit(stat);
    }

    @Override
    public void visit(Stat.Assign stat) {
        super.visit(stat);
        int n = stat.vars.size();
        for (int i = 0; i < n; ++i) {
            Exp.VarExp v = stat.vars.get(i);
            v.markHasAssignment();
        }
    }

    @Override
    public void visit(Stat.LocalAssign stat) {
        int i;
        this.visitExps(stat.values);
        this.defineLocalVars(stat.names);
        int n = stat.names.size();
        int m = stat.values != null ? stat.values.size() : 0;
        boolean isvarlist = m > 0 && m < n && stat.values.get(m - 1).isvarargexp();
        for (i = 0; i < n && i < (isvarlist ? m - 1 : m); ++i) {
            if (!(stat.values.get(i) instanceof Exp.Constant)) continue;
            stat.names.get((int)i).variable.initialValue = ((Exp.Constant)stat.values.get((int)i)).value;
        }
        if (!isvarlist) {
            for (i = m; i < n; ++i) {
                stat.names.get((int)i).variable.initialValue = LuaValue.NIL;
            }
        }
    }

    @Override
    public void visit(ParList pars) {
        if (pars.names != null) {
            this.defineLocalVars(pars.names);
        }
        if (pars.isvararg) {
            this.scope.define("arg");
        }
        super.visit(pars);
    }

    protected void defineLocalVars(List<Name> names) {
        int n = names.size();
        for (int i = 0; i < n; ++i) {
            this.defineLocalVar(names.get(i));
        }
    }

    protected void defineLocalVar(Name name) {
        name.variable = this.scope.define(name.name);
    }

    protected Variable resolveNameReference(Name name) {
        Variable v = this.scope.find(name.name);
        if (v.isLocal() && this.scope.functionNestingCount != v.definingScope.functionNestingCount) {
            v.isupvalue = true;
        }
        return v;
    }
}

