/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;

public abstract class Varargs {
    public abstract LuaValue arg(int var1);

    public abstract int narg();

    public abstract LuaValue arg1();

    public Varargs eval() {
        return this;
    }

    public boolean isTailcall() {
        return false;
    }

    public int type(int i) {
        return this.arg(i).type();
    }

    public boolean isnil(int i) {
        return this.arg(i).isnil();
    }

    public boolean isfunction(int i) {
        return this.arg(i).isfunction();
    }

    public boolean isnumber(int i) {
        return this.arg(i).isnumber();
    }

    public boolean isstring(int i) {
        return this.arg(i).isstring();
    }

    public boolean istable(int i) {
        return this.arg(i).istable();
    }

    public boolean isthread(int i) {
        return this.arg(i).isthread();
    }

    public boolean isuserdata(int i) {
        return this.arg(i).isuserdata();
    }

    public boolean isvalue(int i) {
        return i > 0 && i <= this.narg();
    }

    public boolean optboolean(int i, boolean defval) {
        return this.arg(i).optboolean(defval);
    }

    public LuaClosure optclosure(int i, LuaClosure defval) {
        return this.arg(i).optclosure(defval);
    }

    public double optdouble(int i, double defval) {
        return this.arg(i).optdouble(defval);
    }

    public LuaFunction optfunction(int i, LuaFunction defval) {
        return this.arg(i).optfunction(defval);
    }

    public int optint(int i, int defval) {
        return this.arg(i).optint(defval);
    }

    public LuaInteger optinteger(int i, LuaInteger defval) {
        return this.arg(i).optinteger(defval);
    }

    public long optlong(int i, long defval) {
        return this.arg(i).optlong(defval);
    }

    public LuaNumber optnumber(int i, LuaNumber defval) {
        return this.arg(i).optnumber(defval);
    }

    public String optjstring(int i, String defval) {
        return this.arg(i).optjstring(defval);
    }

    public LuaString optstring(int i, LuaString defval) {
        return this.arg(i).optstring(defval);
    }

    public LuaTable opttable(int i, LuaTable defval) {
        return this.arg(i).opttable(defval);
    }

    public LuaThread optthread(int i, LuaThread defval) {
        return this.arg(i).optthread(defval);
    }

    public Object optuserdata(int i, Object defval) {
        return this.arg(i).optuserdata(defval);
    }

    public Object optuserdata(int i, Class c, Object defval) {
        return this.arg(i).optuserdata(c, defval);
    }

    public LuaValue optvalue(int i, LuaValue defval) {
        return i > 0 && i <= this.narg() ? this.arg(i) : defval;
    }

    public boolean checkboolean(int i) {
        return this.arg(i).checkboolean();
    }

    public LuaClosure checkclosure(int i) {
        return this.arg(i).checkclosure();
    }

    public double checkdouble(int i) {
        return this.arg(i).checknumber().todouble();
    }

    public LuaFunction checkfunction(int i) {
        return this.arg(i).checkfunction();
    }

    public int checkint(int i) {
        return this.arg(i).checknumber().toint();
    }

    public LuaInteger checkinteger(int i) {
        return this.arg(i).checkinteger();
    }

    public long checklong(int i) {
        return this.arg(i).checknumber().tolong();
    }

    public LuaNumber checknumber(int i) {
        return this.arg(i).checknumber();
    }

    public String checkjstring(int i) {
        return this.arg(i).checkjstring();
    }

    public LuaString checkstring(int i) {
        return this.arg(i).checkstring();
    }

    public LuaTable checktable(int i) {
        return this.arg(i).checktable();
    }

    public LuaThread checkthread(int i) {
        return this.arg(i).checkthread();
    }

    public Object checkuserdata(int i) {
        return this.arg(i).checkuserdata();
    }

    public Object checkuserdata(int i, Class c) {
        return this.arg(i).checkuserdata(c);
    }

    public LuaValue checkvalue(int i) {
        return i <= this.narg() ? this.arg(i) : LuaValue.argerror(i, "value expected");
    }

    public LuaValue checknotnil(int i) {
        return this.arg(i).checknotnil();
    }

    public void argcheck(boolean test, int i, String msg) {
        if (!test) {
            LuaValue.argerror(i, msg);
        }
    }

    public boolean isnoneornil(int i) {
        return i > this.narg() || this.arg(i).isnil();
    }

    public boolean toboolean(int i) {
        return this.arg(i).toboolean();
    }

    public byte tobyte(int i) {
        return this.arg(i).tobyte();
    }

    public char tochar(int i) {
        return this.arg(i).tochar();
    }

    public double todouble(int i) {
        return this.arg(i).todouble();
    }

    public float tofloat(int i) {
        return this.arg(i).tofloat();
    }

    public int toint(int i) {
        return this.arg(i).toint();
    }

    public long tolong(int i) {
        return this.arg(i).tolong();
    }

    public String tojstring(int i) {
        return this.arg(i).tojstring();
    }

    public short toshort(int i) {
        return this.arg(i).toshort();
    }

    public Object touserdata(int i) {
        return this.arg(i).touserdata();
    }

    public Object touserdata(int i, Class c) {
        return this.arg(i).touserdata(c);
    }

    public String tojstring() {
        Buffer sb = new Buffer();
        sb.append("(");
        int n = this.narg();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(this.arg(i).tojstring());
        }
        sb.append(")");
        return sb.tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public abstract Varargs subargs(int var1);

    void copyto(LuaValue[] dest, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[offset + i] = this.arg(i + 1);
        }
    }

    public Varargs dealias() {
        int n = this.narg();
        switch (n) {
            case 0: {
                return LuaValue.NONE;
            }
            case 1: {
                return this.arg1();
            }
            case 2: {
                return new PairVarargs(this.arg1(), this.arg(2));
            }
        }
        LuaValue[] v = new LuaValue[n];
        this.copyto(v, 0, n);
        return new ArrayVarargs(v, LuaValue.NONE);
    }

    static final class ArrayPartVarargs
    extends Varargs {
        private final int offset;
        private final LuaValue[] v;
        private final int length;
        private final Varargs more;

        ArrayPartVarargs(LuaValue[] v, int offset, int length) {
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = LuaValue.NONE;
        }

        public ArrayPartVarargs(LuaValue[] v, int offset, int length, Varargs more) {
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = more;
        }

        @Override
        public LuaValue arg(int i) {
            return i < 1 ? LuaValue.NIL : (i <= this.length ? this.v[this.offset + i - 1] : this.more.arg(i - this.length));
        }

        @Override
        public int narg() {
            return this.length + this.more.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.length > 0 ? this.v[this.offset] : this.more.arg1();
        }

        @Override
        public Varargs subargs(int start) {
            if (start <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (start == 1) {
                return this;
            }
            if (start > this.length) {
                return this.more.subargs(start - this.length);
            }
            return LuaValue.varargsOf(this.v, this.offset + start - 1, this.length - (start - 1), this.more);
        }

        @Override
        void copyto(LuaValue[] dest, int offset, int length) {
            int n = Math.min(this.length, length);
            System.arraycopy(this.v, this.offset, dest, offset, n);
            this.more.copyto(dest, offset + n, length - n);
        }
    }

    static final class ArrayVarargs
    extends Varargs {
        private final LuaValue[] v;
        private final Varargs r;

        ArrayVarargs(LuaValue[] v, Varargs r) {
            this.v = v;
            this.r = r;
        }

        @Override
        public LuaValue arg(int i) {
            return i < 1 ? LuaValue.NIL : (i <= this.v.length ? this.v[i - 1] : this.r.arg(i - this.v.length));
        }

        @Override
        public int narg() {
            return this.v.length + this.r.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.v.length > 0 ? this.v[0] : this.r.arg1();
        }

        @Override
        public Varargs subargs(int start) {
            if (start <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (start == 1) {
                return this;
            }
            if (start > this.v.length) {
                return this.r.subargs(start - this.v.length);
            }
            return LuaValue.varargsOf(this.v, start - 1, this.v.length - (start - 1), this.r);
        }

        @Override
        void copyto(LuaValue[] dest, int offset, int length) {
            int n = Math.min(this.v.length, length);
            System.arraycopy(this.v, 0, dest, offset, n);
            this.r.copyto(dest, offset + n, length - n);
        }
    }

    static final class PairVarargs
    extends Varargs {
        private final LuaValue v1;
        private final Varargs v2;

        PairVarargs(LuaValue v1, Varargs v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public LuaValue arg(int i) {
            return i == 1 ? this.v1 : this.v2.arg(i - 1);
        }

        @Override
        public int narg() {
            return 1 + this.v2.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.v1;
        }

        @Override
        public Varargs subargs(int start) {
            if (start == 1) {
                return this;
            }
            if (start == 2) {
                return this.v2;
            }
            if (start > 2) {
                return this.v2.subargs(start - 1);
            }
            return LuaValue.argerror(1, "start must be > 0");
        }
    }

    static class SubVarargs
    extends Varargs {
        private final Varargs v;
        private final int start;
        private final int end;

        public SubVarargs(Varargs varargs, int start, int end) {
            this.v = varargs;
            this.start = start;
            this.end = end;
        }

        @Override
        public LuaValue arg(int i) {
            return (i += this.start - 1) >= this.start && i <= this.end ? this.v.arg(i) : LuaValue.NIL;
        }

        @Override
        public LuaValue arg1() {
            return this.v.arg(this.start);
        }

        @Override
        public int narg() {
            return this.end + 1 - this.start;
        }

        @Override
        public Varargs subargs(int start) {
            if (start == 1) {
                return this;
            }
            int newstart = this.start + start - 1;
            if (start > 0) {
                if (newstart >= this.end) {
                    return LuaValue.NONE;
                }
                if (newstart == this.end) {
                    return this.v.arg(this.end);
                }
                if (newstart == this.end - 1) {
                    return new PairVarargs(this.v.arg(this.end - 1), this.v.arg(this.end));
                }
                return new SubVarargs(this.v, newstart, this.end);
            }
            return new SubVarargs(this.v, newstart, this.end);
        }
    }
}

