/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.PrintStream;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;

public class LuaUtf8String
extends LuaValue {
    public static LuaValue s_metatable;
    public final char[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private int m_hashcode;
    static final int RECENT_STRINGS_CACHE_SIZE = 128;
    static final int RECENT_STRINGS_MAX_LENGTH = 32;
    private boolean isHascode;
    private String m_string;

    public static LuaUtf8String valueOfString(String string) {
        char[] c = string.toCharArray();
        return LuaUtf8String.valueUsing(c, 0, c.length);
    }

    public static LuaUtf8String valueOfString(LuaString string) {
        char[] c = string.toCharArray();
        return LuaUtf8String.valueUsing(c, 0, c.length);
    }

    private static LuaUtf8String valueFromCopy(char[] bytes, int off, int len2) {
        char[] copy = new char[len2];
        System.arraycopy(bytes, off, copy, 0, len2);
        return new LuaUtf8String(copy, 0, len2);
    }

    public static LuaUtf8String valueUsing(char[] bytes, int off, int len2) {
        return new LuaUtf8String(bytes, off, len2);
    }

    public static LuaUtf8String valueOf(char[] bytes) {
        return LuaUtf8String.valueOf(bytes, 0, bytes.length);
    }

    public static LuaUtf8String valueOf(char[] bytes, int off, int len2) {
        return LuaUtf8String.valueUsing(bytes, off, len2);
    }

    public static LuaUtf8String valueUsing(char[] bytes) {
        return LuaUtf8String.valueUsing(bytes, 0, bytes.length);
    }

    private LuaUtf8String(char[] bytes, int offset, int length) {
        this.m_bytes = bytes;
        this.m_offset = offset;
        this.m_length = length;
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String typename() {
        return "string";
    }

    @Override
    public String tojstring() {
        if (this.m_string == null) {
            this.m_string = LuaUtf8String.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
        }
        return this.m_string;
    }

    @Override
    public LuaValue neg() {
        double d = this.scannumber();
        return Double.isNaN(d) ? super.neg() : LuaUtf8String.valueOf(-d);
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(ADD, rhs) : rhs.add(d);
    }

    @Override
    public LuaValue add(double rhs) {
        return LuaUtf8String.valueOf(this.checkarith() + rhs);
    }

    public LuaValue add(int rhs) {
        return LuaUtf8String.valueOf(this.checkarith() + (double)rhs);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(SUB, rhs) : rhs.subFrom(d);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaUtf8String.valueOf(this.checkarith() - rhs);
    }

    public LuaValue sub(int rhs) {
        return LuaUtf8String.valueOf(this.checkarith() - (double)rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaUtf8String.valueOf(lhs - this.checkarith());
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MUL, rhs) : rhs.mul(d);
    }

    @Override
    public LuaValue mul(double rhs) {
        return LuaUtf8String.valueOf(this.checkarith() * rhs);
    }

    public LuaValue mul(int rhs) {
        return LuaUtf8String.valueOf(this.checkarith() * (double)rhs);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(POW, rhs) : rhs.powWith(d);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(DIV, rhs) : rhs.divInto(d);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.checkarith());
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MOD, rhs) : rhs.modFrom(d);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.checkarith());
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) > 0 ? LuaValue.TRUE : FALSE) : super.lt(rhs);
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) > 0 : super.lt_b(rhs);
    }

    public boolean lt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE) : super.lteq(rhs);
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) >= 0 : super.lteq_b(rhs);
    }

    public boolean lteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) < 0 ? LuaValue.TRUE : FALSE) : super.gt(rhs);
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) < 0 : super.gt_b(rhs);
    }

    public boolean gt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE) : super.gteq(rhs);
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) <= 0 : super.gteq_b(rhs);
    }

    public boolean gteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue concat(LuaValue rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public Buffer concat(Buffer rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public LuaValue concatTo(LuaNumber lhs) {
        return this.concatTo(lhs.strvalue());
    }

    public LuaValue concatTo(LuaUtf8String lhs) {
        char[] b = new char[lhs.m_length + this.m_length];
        System.arraycopy(lhs.m_bytes, lhs.m_offset, b, 0, lhs.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, b, lhs.m_length, this.m_length);
        return LuaUtf8String.valueUsing(b, 0, b.length);
    }

    @Override
    public int strcmp(LuaValue lhs) {
        return -lhs.strcmp(this);
    }

    public int strcmp(LuaUtf8String rhs) {
        int i = 0;
        for (int j = 0; i < this.m_length && j < rhs.m_length; ++i, ++j) {
            if (this.m_bytes[this.m_offset + i] == rhs.m_bytes[rhs.m_offset + j]) continue;
            return this.m_bytes[this.m_offset + i] - rhs.m_bytes[rhs.m_offset + j];
        }
        return this.m_length - rhs.m_length;
    }

    private double checkarith() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.aritherror();
        }
        return d;
    }

    @Override
    public int checkint() {
        return (int)this.checkdouble();
    }

    @Override
    public LuaInteger checkinteger() {
        return LuaUtf8String.valueOf(this.checkint());
    }

    @Override
    public long checklong() {
        return (long)this.checkdouble();
    }

    @Override
    public double checkdouble() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return d;
    }

    @Override
    public LuaNumber checknumber() {
        return LuaUtf8String.valueOf(this.checkdouble());
    }

    @Override
    public LuaNumber checknumber(String msg) {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            LuaUtf8String.error(msg);
        }
        return LuaUtf8String.valueOf(d);
    }

    @Override
    public boolean isnumber() {
        double d = this.scannumber();
        return !Double.isNaN(d);
    }

    @Override
    public boolean isint() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        int i = (int)d;
        return (double)i == d;
    }

    @Override
    public boolean islong() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    @Override
    public byte tobyte() {
        return (byte)this.toint();
    }

    @Override
    public char tochar() {
        return (char)this.toint();
    }

    @Override
    public double todouble() {
        double d = this.scannumber();
        return Double.isNaN(d) ? 0.0 : d;
    }

    @Override
    public float tofloat() {
        return (float)this.todouble();
    }

    @Override
    public int toint() {
        return (int)this.tolong();
    }

    @Override
    public long tolong() {
        return (long)this.todouble();
    }

    @Override
    public short toshort() {
        return (short)this.toint();
    }

    @Override
    public double optdouble(double defval) {
        return this.checkdouble();
    }

    @Override
    public int optint(int defval) {
        return this.checkint();
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return this.checkinteger();
    }

    @Override
    public long optlong(long defval) {
        return this.checklong();
    }

    @Override
    public LuaNumber optnumber(LuaNumber defval) {
        return this.checknumber();
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return LuaUtf8String.toLuaString(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    public LuaValue tostring() {
        return LuaUtf8String.toLuaString(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    public String optjstring(String defval) {
        return this.tojstring();
    }

    @Override
    public LuaString strvalue() {
        return LuaUtf8String.toLuaString(this.m_bytes, this.m_offset, this.m_length);
    }

    public static LuaString toLuaString(char[] bytes, int off, int len2) {
        char[] b = new char[len2];
        for (int i = 0; i < len2; ++i) {
            b[i] = bytes[i + off];
        }
        byte[] b2 = new byte[LuaUtf8String.lengthAsUtf8(b)];
        LuaString.encodeToUtf8(b, b.length, b2, 0);
        return LuaString.valueUsing(b2, 0, b2.length);
    }

    public LuaUtf8String substring(int beginIndex, int endIndex) {
        int off = this.m_offset + beginIndex;
        int len2 = endIndex - beginIndex;
        return len2 >= this.m_length / 2 ? LuaUtf8String.valueUsing(this.m_bytes, off, len2) : LuaUtf8String.valueOf(this.m_bytes, off, len2);
    }

    public int hashCode() {
        if (this.isHascode) {
            return this.m_hashcode;
        }
        this.m_hashcode = LuaUtf8String.hashCode(this.m_bytes, this.m_offset, this.m_length);
        this.isHascode = true;
        return this.m_hashcode;
    }

    public static int hashCode(char[] bytes, int offset, int length) {
        int h = length;
        int step = (length >> 5) + 1;
        for (int l1 = length; l1 >= step; l1 -= step) {
            h ^= (h << 5) + (h >> 2) + (bytes[offset + l1 - 1] & 0xFF);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LuaUtf8String) {
            return this.raweq((LuaUtf8String)o);
        }
        return false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this);
    }

    public boolean raweq(LuaUtf8String s) {
        if (this == s) {
            return true;
        }
        if (s.m_length != this.m_length) {
            return false;
        }
        if (s.m_bytes == this.m_bytes && s.m_offset == this.m_offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.m_length; ++i) {
            if (s.m_bytes[s.m_offset + i] == this.m_bytes[this.m_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaUtf8String a, int i, LuaUtf8String b, int j, int n) {
        return LuaUtf8String.equals(a.m_bytes, a.m_offset + i, b.m_bytes, b.m_offset + j, n);
    }

    private boolean byteseq(char[] bytes, int off, int len2) {
        return this.m_length == len2 && LuaUtf8String.equals(this.m_bytes, this.m_offset, bytes, off, len2);
    }

    public static boolean equals(char[] a, int i, char[] b, int j, int n) {
        if (a.length < i + n || b.length < j + n) {
            return false;
        }
        while (--n >= 0) {
            if (a[i++] == b[j++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public int rawlen() {
        return this.m_length;
    }

    public int luaByte(int index) {
        return this.m_bytes[this.m_offset + index];
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    @Override
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    public LuaString checkstring() {
        return LuaUtf8String.toLuaString(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int strOffset, char[] bytes, int arrayOffset, int len2) {
        System.arraycopy(this.m_bytes, this.m_offset + strOffset, bytes, arrayOffset, len2);
    }

    public int indexOfAny(LuaUtf8String accept) {
        int ilimit = this.m_offset + this.m_length;
        int jlimit = accept.m_offset + accept.m_length;
        for (int i = this.m_offset; i < ilimit; ++i) {
            for (int j = accept.m_offset; j < jlimit; ++j) {
                if (this.m_bytes[i] != accept.m_bytes[j]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte b, int start) {
        for (int i = start; i < this.m_length; ++i) {
            if (this.m_bytes[this.m_offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaUtf8String s, int start) {
        int slen = s.length();
        int limit = this.m_length - slen;
        for (int i = start; i <= limit; ++i) {
            if (!LuaUtf8String.equals(this.m_bytes, this.m_offset + i, s.m_bytes, s.m_offset, slen)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LuaUtf8String s) {
        int limit;
        int slen = s.length();
        for (int i = limit = this.m_length - slen; i >= 0; --i) {
            if (!LuaUtf8String.equals(this.m_bytes, this.m_offset + i, s.m_bytes, s.m_offset, slen)) continue;
            return i;
        }
        return -1;
    }

    public static String decodeAsUtf8(char[] bytes, int offset, int length) {
        return new String(bytes, offset, length);
    }

    public static int lengthAsUtf8(char[] chars) {
        int b;
        int i = b = chars.length;
        while (--i >= 0) {
            char c = chars[i];
            if (c < '\u0080') continue;
            b += c >= '\u0800' ? 2 : 1;
        }
        return b;
    }

    public boolean isValidUtf8() {
        int i = this.m_offset;
        int j = this.m_offset + this.m_length;
        while (i < j) {
            char c;
            if ((c = this.m_bytes[i++]) >= '\u0000' || (c & 0xE0) == 192 && i < j && (this.m_bytes[i++] & 0xC0) == 128 || (c & 0xF0) == 224 && i + 1 < j && (this.m_bytes[i++] & 0xC0) == 128 && (this.m_bytes[i++] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    @Override
    public LuaValue tonumber() {
        double d = this.scannumber();
        return Double.isNaN(d) ? NIL : LuaUtf8String.valueOf(d);
    }

    public LuaValue tonumber(int base) {
        double d = this.scannumber(base);
        return Double.isNaN(d) ? NIL : LuaUtf8String.valueOf(d);
    }

    public double scannumber() {
        int i;
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.m_bytes[i] == ' '; ++i) {
        }
        while (i < j && this.m_bytes[j - 1] == ' ') {
            --j;
        }
        if (i >= j) {
            return Double.NaN;
        }
        if (this.m_bytes[i] == '0' && i + 1 < j && (this.m_bytes[i + 1] == 'x' || this.m_bytes[i + 1] == 'X')) {
            return this.scanlong(16, i + 2, j);
        }
        double l = this.scanlong(10, i, j);
        return Double.isNaN(l) ? this.scandouble(i, j) : l;
    }

    public double scannumber(int base) {
        int i;
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.m_bytes[i] == ' '; ++i) {
        }
        while (i < j && this.m_bytes[j - 1] == ' ') {
            --j;
        }
        if (i >= j) {
            return Double.NaN;
        }
        return this.scanlong(base, i, j);
    }

    private double scanlong(int base, int start, int end) {
        int i;
        long x = 0L;
        boolean neg = this.m_bytes[start] == '-';
        int n = i = neg ? start + 1 : start;
        while (i < end) {
            int digit = this.m_bytes[i] - (base <= 10 || this.m_bytes[i] >= '0' && this.m_bytes[i] <= '9' ? 48 : (this.m_bytes[i] >= 'A' && this.m_bytes[i] <= 'Z' ? 55 : 87));
            if (digit < 0 || digit >= base) {
                return Double.NaN;
            }
            if ((x = x * (long)base + (long)digit) < 0L) {
                return Double.NaN;
            }
            ++i;
        }
        return neg ? (double)(-x) : (double)x;
    }

    private double scandouble(int start, int end) {
        if (end > start + 64) {
            end = start + 64;
        }
        block5: for (int i = start; i < end; ++i) {
            switch (this.m_bytes[i]) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] c = new char[end - start];
        for (int i = start; i < end; ++i) {
            c[i - start] = this.m_bytes[i];
        }
        try {
            return Double.parseDouble(new String(c));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void printToStream(PrintStream ps) {
        int n = this.m_length;
        for (int i = 0; i < n; ++i) {
            char c = this.m_bytes[this.m_offset + i];
            ps.print(c);
        }
    }
}

