/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.lib.jse.JsePlatform;

public class luac {
    private static final String version = "Luaj-jse 3.0.1Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar luac [options] [filenames].\nAvailable options are:\n  -        process stdin\n  -l       list\n  -o name  output to file 'name' (default is \"luac.out\")\n  -p       parse only\n  -s       strip debug information\n  -e       little endian format for numbers\n  -i<n>    number format 'n', (n=0,1 or 4, default=0)\n  -v       show version information\n  -c enc  \tuse the supplied encoding 'enc' for input files\n  --       stop handling options\n";
    private boolean list = false;
    private String output = "luac.out";
    private boolean parseonly = false;
    private boolean stripdebug = false;
    private boolean littleendian = false;
    private int numberformat = 0;
    private boolean versioninfo = false;
    private boolean processing = true;
    private String encoding = null;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        new luac(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private luac(String[] args) throws IOException {
        try {
            block20: for (int i = 0; i < args.length; ++i) {
                if (!this.processing || !args[i].startsWith("-") || args[i].length() <= 1) continue;
                switch (args[i].charAt(1)) {
                    case 'l': {
                        this.list = true;
                        continue block20;
                    }
                    case 'o': {
                        if (++i >= args.length) {
                            luac.usageExit();
                        }
                        this.output = args[i];
                        continue block20;
                    }
                    case 'p': {
                        this.parseonly = true;
                        continue block20;
                    }
                    case 's': {
                        this.stripdebug = true;
                        continue block20;
                    }
                    case 'e': {
                        this.littleendian = true;
                        continue block20;
                    }
                    case 'i': {
                        if (args[i].length() <= 2) {
                            luac.usageExit();
                        }
                        this.numberformat = Integer.parseInt(args[i].substring(2));
                        continue block20;
                    }
                    case 'v': {
                        this.versioninfo = true;
                        continue block20;
                    }
                    case 'c': {
                        if (++i >= args.length) {
                            luac.usageExit();
                        }
                        this.encoding = args[i];
                        continue block20;
                    }
                    case '-': {
                        if (args[i].length() > 2) {
                            luac.usageExit();
                        }
                        this.processing = false;
                        continue block20;
                    }
                    default: {
                        luac.usageExit();
                    }
                }
            }
            if (this.versioninfo) {
                System.out.println(version);
            }
            try (FileOutputStream fos = new FileOutputStream(this.output);){
                Globals globals = JsePlatform.standardGlobals();
                this.processing = true;
                block21: for (int i = 0; i < args.length; ++i) {
                    if (!this.processing || !args[i].startsWith("-")) {
                        String chunkname = args[i].substring(0, args[i].length() - 4);
                        this.processScript(globals, new FileInputStream(args[i]), chunkname, fos);
                        continue;
                    }
                    if (args[i].length() <= 1) {
                        this.processScript(globals, System.in, "=stdin", fos);
                        continue;
                    }
                    switch (args[i].charAt(1)) {
                        case 'c': 
                        case 'o': {
                            ++i;
                            continue block21;
                        }
                        case '-': {
                            this.processing = false;
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(Globals globals, InputStream script, String chunkname, OutputStream out) throws IOException {
        try {
            Prototype chunk;
            script = new BufferedInputStream(script);
            Prototype prototype = chunk = this.encoding != null ? globals.compilePrototype(new InputStreamReader(script, this.encoding), chunkname) : globals.compilePrototype(script, chunkname);
            if (this.list) {
                Print.printCode(chunk);
            }
            if (!this.parseonly) {
                DumpState.dump(chunk, out, this.stripdebug, this.numberformat, this.littleendian);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            script.close();
        }
    }
}

