/*
 * Decompiled with CFR 0.152.
 */
package cn.mythoi.processor;

import cn.mythoi.annotation.LuaRunner;
import cn.mythoi.util.JCTreeUtils;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class LuaRunnerProcessor
extends AbstractProcessor {
    private Messager messager;
    private Context context;
    private JavacElements elementUtils;
    private TreeMaker treeMaker;
    private JavacTrees trees;
    private Filer mFiler;
    private Set<String> stringSet = new TreeSet<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.elementUtils = (JavacElements)processingEnv.getElementUtils();
        this.treeMaker = TreeMaker.instance(this.context);
        this.trees = JavacTrees.instance(processingEnv);
        this.mFiler = processingEnv.getFiler();
        JCTreeUtils.init(this.messager, this.context, this.elementUtils, this.treeMaker);
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> methodElementSet = roundEnv.getElementsAnnotatedWith(LuaRunner.class);
        methodElementSet.forEach(element -> {
            String className = element.getEnclosingElement().toString();
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)this.trees.getTree(element.getEnclosingElement());
            JCTree.JCAnnotation annotationAutowired = this.treeMaker.Annotation(JCTreeUtils.memberAccess("org.springframework.beans.factory.annotation.Autowired"), List.nil());
            JCTree.JCVariableDecl simpleCallComponentVariableDecl = JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(2L), JCTreeUtils.memberAccess("cn.mythoi.component.SimpleCallComponent"), "__simpleCallComponent", null);
            simpleCallComponentVariableDecl.mods.annotations = simpleCallComponentVariableDecl.mods.annotations.prepend(annotationAutowired);
            if (this.stringSet.add(className)) {
                jcClassDecl.defs = jcClassDecl.defs.prepend(simpleCallComponentVariableDecl);
            }
            LuaRunner annotation = element.getAnnotation(LuaRunner.class);
            String annotationValue = annotation.value().replace("\\", "/").trim();
            String annotationFuncName = annotation.func();
            String[] params = annotation.params();
            int annotationType = annotation.type();
            JCTree.JCMethodDecl jcMethodDecl = (JCTree.JCMethodDecl)this.trees.getTree((Element)element);
            if (jcMethodDecl.mods.getFlags().toString().contains("static")) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "LuaRunner\u6ce8\u89e3\u4e0d\u652f\u6301\u9759\u6001\u7c7b\u578b\uff01");
                return;
            }
            JCTree.JCVariableDecl globalsBlock = JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("org.luaj.vm2.Globals"), "globals", this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("org.luaj.vm2.lib.jse.JsePlatform.standardGlobals"), List.nil()));
            JCTree.JCVariableDecl chunkBlock1 = JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("org.luaj.vm2.LuaValue"), "chunk1", this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("globals.loadfile"), List.of(this.treeMaker.Binary(JCTree.Tag.PLUS, this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("__simpleCallComponent.getBaseRunnerPath"), List.nil()), this.treeMaker.Literal(annotationValue)))));
            List<JCTree.JCExpression> paramsList = List.nil();
            List<JCTree.JCExpression> paramsTypeList = List.nil();
            for (JCTree.JCVariableDecl param : jcMethodDecl.params) {
                paramsList = paramsList.append(this.treeMaker.Ident(param.name));
                paramsTypeList = paramsTypeList.append(param.vartype);
            }
            JCTree.JCExpressionStatement _this = this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("globals.jset"), List.of(this.treeMaker.Literal("_this"), this.treeMaker.Ident(this.elementUtils.getName("this")))));
            List<JCTree.JCExpressionStatement> paramList = List.nil();
            JCTree.JCExpressionStatement luaValueExecBlock1 = this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("chunk1.call"), List.nil()));
            for (String param : params) {
                JCTree.JCExpressionStatement exec = this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("globals.jset"), List.of(this.treeMaker.Literal("_" + param), this.treeMaker.Ident(this.elementUtils.getName(param)))));
                paramList = paramList.append(exec);
            }
            JCTree.JCVariableDecl chunkBlock2 = JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("org.luaj.vm2.LuaValue"), "chunk2", this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("globals.get"), List.of(this.treeMaker.Literal(annotationFuncName))));
            JCTree.JCVariableDecl luaValueExecBlock2 = JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("java.lang.Object"), "jcallReturn", this.treeMaker.Apply(paramsTypeList, JCTreeUtils.memberAccess("chunk2.jcall"), paramsList));
            switch (annotationType) {
                case 1: {
                    jcMethodDecl.body = this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2, new JCTree.JCStatement[]{jcMethodDecl.body})));
                    break;
                }
                case 2: {
                    jcMethodDecl.body = this.treeMaker.Block(0L, List.of(this.treeMaker.Try(jcMethodDecl.body, List.nil(), this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2))))));
                    break;
                }
                case 3: {
                    if (jcMethodDecl.restype.getKind() != Tree.Kind.PRIMITIVE_TYPE) {
                        jcMethodDecl.body = this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2, new JCTree.JCStatement[]{this.treeMaker.Return(this.treeMaker.TypeCast(jcMethodDecl.restype, (JCTree.JCExpression)this.treeMaker.Ident(this.elementUtils.getName("jcallReturn"))))})));
                        break;
                    }
                    jcMethodDecl.body = this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2)));
                    break;
                }
                case 4: {
                    JCTree.JCExpressionStatement _exception = this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), JCTreeUtils.memberAccess("globals.jset"), List.of(this.treeMaker.Literal("_exception"), this.treeMaker.Ident(this.elementUtils.getName("exception")))));
                    List<JCTree.JCCatch> catchList = jcMethodDecl.restype.getKind() != Tree.Kind.PRIMITIVE_TYPE ? List.of(this.treeMaker.Catch(JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("java.lang.Exception"), "exception", null), this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this, new JCTree.JCStatement[]{_exception}).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2, new JCTree.JCStatement[]{this.treeMaker.Return(this.treeMaker.TypeCast(jcMethodDecl.restype, (JCTree.JCExpression)this.treeMaker.Ident(this.elementUtils.getName("jcallReturn"))))}))))) : List.of(this.treeMaker.Catch(JCTreeUtils.makeVarDef(this.treeMaker.Modifiers(0L), JCTreeUtils.memberAccess("java.lang.Exception"), "exception", null), this.treeMaker.Block(0L, List.of(globalsBlock, chunkBlock1, _this, new JCTree.JCStatement[]{_exception}).appendList(paramList).appendList(List.of(luaValueExecBlock1, chunkBlock2, luaValueExecBlock2)))));
                    jcMethodDecl.body = this.treeMaker.Block(0L, List.of(this.treeMaker.Try(jcMethodDecl.body, catchList, null)));
                }
            }
        });
        return true;
    }

    private void generateFile(String str) {
        try {
            File file = new File("/Users/mythoi/code/dbCustomProcFile");
            FileWriter fw = new FileWriter(file);
            fw.append(str);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printMsg(e.toString());
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotataions = new LinkedHashSet<String>();
        annotataions.add(LuaRunner.class.getCanonicalName());
        return annotataions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void printMsg(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }
}

