/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.util;

import db.sql.api.impl.tookit.Objects;
import java.io.File;
import java.util.regex.Matcher;

public final class PathUtils {
    @SafeVarargs
    public static String buildPackage(String ... packages) {
        StringBuilder builder = new StringBuilder();
        for (String pkg : packages) {
            if (Objects.isNull((Object)pkg) || (pkg = pkg.trim()).length() < 1) continue;
            builder.append(pkg).append(".");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @SafeVarargs
    public static String buildFilePath(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (Objects.isNull((Object)path) || (path = path.trim()).trim().length() <= 0) continue;
            if (builder.length() > 0) {
                builder.append(File.separator);
            }
            builder.append(path);
        }
        if (File.separator.equals("/")) {
            return builder.toString().replaceAll("\\\\", Matcher.quoteReplacement(File.separator));
        }
        return builder.toString().replaceAll("\\/", Matcher.quoteReplacement(File.separator));
    }
}

