/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.util;

import cn.mybatis.mp.core.mybatis.mapper.context.Pager;
import cn.mybatis.mp.core.sql.executor.chain.DeleteChain;
import cn.mybatis.mp.core.sql.executor.chain.InsertChain;
import cn.mybatis.mp.core.sql.executor.chain.QueryChain;
import cn.mybatis.mp.core.sql.executor.chain.UpdateChain;
import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.db.IdAutoType;
import cn.mybatis.mp.db.annotations.LogicDelete;
import cn.mybatis.mp.db.annotations.Table;
import cn.mybatis.mp.db.annotations.TableField;
import cn.mybatis.mp.db.annotations.TableId;
import cn.mybatis.mp.db.annotations.TenantId;
import cn.mybatis.mp.db.annotations.Version;
import cn.mybatis.mp.generator.core.config.ContainerType;
import cn.mybatis.mp.generator.core.config.EntityConfig;
import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.core.database.meta.EntityInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Mapper;

public class GeneratorUtil {
    public static String getEntityName(GeneratorConfig generatorConfig, String tableName) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getNameConvert() == null) {
            entityConfig.nameConvert(table -> NamingUtil.firstToUpperCase((String)NamingUtil.underlineToCamel((String)table)));
        }
        return entityConfig.getNameConvert().apply(tableName);
    }

    public static String getEntityFieldName(GeneratorConfig generatorConfig, String columnName) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getFieldNameConverter() == null) {
            return entityConfig.getFieldNamingStrategy().getName(columnName, true);
        }
        return entityConfig.getFieldNameConverter().apply(columnName);
    }

    public static String getEntityFieldRemarks(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getRemarksConverter() == null) {
            return columnInfo.getRemarks();
        }
        return entityConfig.getRemarksConverter().apply(columnInfo);
    }

    public static Class<?> getColumnType(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        Class<?> type = generatorConfig.getEntityConfig().getTypeMapping().get(columnInfo.getJdbcType());
        if (type == null) {
            return Object.class;
        }
        return type;
    }

    public static List<String> buildEntityImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        classList.add(Table.class.getName());
        if (!entityInfo.getIdFieldInfoList().isEmpty()) {
            classList.add(TableId.class.getName());
            classList.add(IdAutoType.class.getName());
        }
        if (generatorConfig.getEntityConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getEntityConfig().getSuperClass());
        }
        if (generatorConfig.getEntityConfig().isLombok()) {
            classList.add("lombok.Data");
            if (generatorConfig.getEntityConfig().isLombokBuilder()) {
                classList.add(generatorConfig.getEntityConfig().hasSuperClass() ? "lombok.experimental.SuperBuilder" : "lombok.Builder");
                classList.add("lombok.NoArgsConstructor");
            }
            if (generatorConfig.getEntityConfig().hasSuperClass()) {
                classList.add("lombok.EqualsAndHashCode");
                classList.add("lombok.ToString");
            }
            if (generatorConfig.getEntityConfig().isCreateFieldClass()) {
                classList.add("lombok.experimental.FieldNameConstants");
            }
        }
        entityInfo.getFieldInfoList().forEach(item -> {
            classList.add(item.getType().getName());
            if (item.isNeedTableField(generatorConfig.getEntityConfig())) {
                classList.add(TableField.class.getName());
            }
            if (item.getColumnInfo().isVersion()) {
                classList.add(Version.class.getName());
            } else if (item.getColumnInfo().isTenantId()) {
                classList.add(TenantId.class.getName());
            } else if (item.getColumnInfo().isLogicDelete()) {
                classList.add(LogicDelete.class.getName());
            }
        });
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildMapperImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getMapperConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getMapperConfig().getSuperClass());
        }
        if (generatorConfig.getMapperConfig().isMapperAnnotation()) {
            classList.add(Mapper.class.getName());
        }
        if (entityInfo.hasMultiId()) {
            entityInfo.getIdFieldInfoList().forEach(item -> classList.add(item.getType().getName()));
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildDaoImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoConfig().getSuperClass());
        }
        if (entityInfo.hasMultiId()) {
            entityInfo.getIdFieldInfoList().forEach(item -> classList.add(item.getType().getName()));
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static void buildDaoImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoImplConfig().getSuperClass());
        }
        if (entityInfo.hasMultiId()) {
            entityInfo.getIdFieldInfoList().forEach(item -> classList.add(item.getType().getName()));
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
        if (generatorConfig.getDaoConfig().isEnable()) {
            classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        }
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add("org.springframework.stereotype.Repository");
            classList.add("org.springframework.beans.factory.annotation.Autowired");
            data.put("repositoryAnnotationName", "Repository");
            data.put("autowiredAnnotationName", "Autowired");
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add("org.noear.solon.annotation.Component");
            classList.add("org.noear.solon.annotation.Inject");
            classList.add("org.noear.solon.annotation.Init");
            data.put("repositoryAnnotationName", "Component");
            data.put("autowiredAnnotationName", "Inject");
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static List<String> buildServiceImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static void buildServiceImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceImplConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        if (generatorConfig.getDaoConfig().isEnable()) {
            classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        } else if (generatorConfig.getDaoImplConfig().isEnable()) {
            classList.add(entityInfo.getDaoImplPackage() + "." + entityInfo.getDaoImplName());
        }
        if (generatorConfig.getServiceConfig().isEnable()) {
            classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
        }
        if (generatorConfig.getServiceImplConfig().isInjectMapper() || !generatorConfig.getServiceImplConfig().isInjectDao(generatorConfig)) {
            classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
            classList.add(QueryChain.class.getName());
            classList.add(UpdateChain.class.getName());
            classList.add(InsertChain.class.getName());
            classList.add(DeleteChain.class.getName());
        }
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add("org.springframework.stereotype.Service");
            classList.add("org.springframework.beans.factory.annotation.Autowired");
            data.put("serviceAnnotationName", "Service");
            data.put("autowiredAnnotationName", "Autowired");
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add("org.noear.solon.annotation.Component");
            classList.add("org.noear.solon.annotation.Inject");
            data.put("serviceAnnotationName", "Component");
            data.put("autowiredAnnotationName", "Inject");
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static void buildActionImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getActionConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getActionConfig().getSuperClass());
        }
        if (generatorConfig.getActionConfig().getReturnClass() != null) {
            classList.add(generatorConfig.getActionConfig().getReturnClass());
        }
        if (entityInfo.hasMultiId() && (generatorConfig.getActionConfig().isEnableGet() || generatorConfig.getActionConfig().isEnableDelete())) {
            entityInfo.getIdFieldInfoList().forEach(item -> classList.add(item.getType().getName()));
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        if (generatorConfig.getActionConfig().isInjectService(generatorConfig)) {
            if (generatorConfig.getServiceConfig().isEnable()) {
                classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
            } else if (generatorConfig.getServiceImplConfig().isEnable()) {
                classList.add(entityInfo.getServiceImplPackage() + "." + entityInfo.getServiceImplName());
            }
        }
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add("org.springframework.web.bind.annotation.RestController");
            classList.add("org.springframework.web.bind.annotation.RequestMapping");
            classList.add("org.springframework.beans.factory.annotation.Autowired");
            data.put("controllerAnnotationName", "RestController");
            data.put("requestMappingAnnotationName", "RequestMapping");
            data.put("autowiredAnnotationName", "Autowired");
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add("org.noear.solon.annotation.Controller");
            classList.add("org.noear.solon.annotation.Mapping");
            classList.add("org.noear.solon.core.handle.MethodType");
            classList.add("org.noear.solon.annotation.Inject");
            data.put("controllerAnnotationName", "Controller");
            data.put("requestMappingAnnotationName", "Mapping");
            data.put("autowiredAnnotationName", "Inject");
        }
        if (generatorConfig.getActionConfig().isEnableSave() || generatorConfig.getActionConfig().isEnableUpdate()) {
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add("org.springframework.web.bind.annotation.PostMapping");
                data.put("postMappingAnnotationName", "PostMapping");
            } else {
                classList.add("org.noear.solon.annotation.Post");
                classList.add("org.noear.solon.annotation.Mapping");
                classList.add("org.noear.solon.core.handle.MethodType");
                data.put("postMappingAnnotationName", "Mapping");
            }
        }
        if (generatorConfig.getActionConfig().isEnableGet() || generatorConfig.getActionConfig().isEnableFind()) {
            if (generatorConfig.getActionConfig().isEnableFind()) {
                classList.add(Pager.class.getName());
            }
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add("org.springframework.web.bind.annotation.GetMapping");
                data.put("getMappingAnnotationName", "GetMapping");
            } else {
                classList.add("org.noear.solon.annotation.Get");
                classList.add("org.noear.solon.annotation.Mapping");
                data.put("getMappingAnnotationName", "Mapping");
            }
        }
        if (generatorConfig.getActionConfig().isEnableDelete()) {
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add("org.springframework.web.bind.annotation.DeleteMapping");
                data.put("deleteMappingAnnotationName", "DeleteMapping");
            } else {
                classList.add("org.noear.solon.annotation.Delete");
                classList.add("org.noear.solon.annotation.Mapping");
                data.put("deleteMappingAnnotationName", "Mapping");
            }
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static List<String> buildImports(List<String> classList) {
        return classList.stream().filter(item -> !item.startsWith("java.lang")).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }
}

