/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.template;

import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.EntityInfo;
import cn.mybatis.mp.generator.core.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.core.util.PathUtils;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class MapperXmlTemplateBuilder
extends AbstractTemplateBuilder {
    public MapperXmlTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getMapperXmlConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return PathUtils.buildFilePath(this.generatorConfig.getBaseFilePath(), this.generatorConfig.getResourcePath(), this.generatorConfig.getMapperXmlConfig().getPackageName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)), this.entityInfo.getName()) + ".xml";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/mapper.xml";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("entityConfig", this.generatorConfig.getEntityConfig());
        data.put("mapperXmlConfig", this.generatorConfig.getMapperXmlConfig());
        data.put("mapperConfig", this.generatorConfig.getMapperConfig());
        data.put("daoConfig", this.generatorConfig.getDaoConfig());
        data.put("daoImplConfig", this.generatorConfig.getDaoImplConfig());
        data.put("serviceConfig", this.generatorConfig.getServiceConfig());
        data.put("serviceImplConfig", this.generatorConfig.getServiceImplConfig());
        data.put("generatorConfig", this.generatorConfig);
        data.put("containerType", (Object)this.generatorConfig.getContainerType());
        return data;
    }
}

