/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.config;

import cn.mybatis.mp.generator.core.config.ActionConfig;
import cn.mybatis.mp.generator.core.config.ColumnConfig;
import cn.mybatis.mp.generator.core.config.ContainerType;
import cn.mybatis.mp.generator.core.config.DaoConfig;
import cn.mybatis.mp.generator.core.config.DaoImplConfig;
import cn.mybatis.mp.generator.core.config.DataBaseConfig;
import cn.mybatis.mp.generator.core.config.EntityConfig;
import cn.mybatis.mp.generator.core.config.MapperConfig;
import cn.mybatis.mp.generator.core.config.MapperXmlConfig;
import cn.mybatis.mp.generator.core.config.ServiceConfig;
import cn.mybatis.mp.generator.core.config.ServiceImplConfig;
import cn.mybatis.mp.generator.core.config.TableConfig;
import cn.mybatis.mp.generator.core.template.ActionTemplateBuilder;
import cn.mybatis.mp.generator.core.template.DaoImplTemplateBuilder;
import cn.mybatis.mp.generator.core.template.DaoTemplateBuilder;
import cn.mybatis.mp.generator.core.template.EntityTemplateBuilder;
import cn.mybatis.mp.generator.core.template.ITemplateBuilder;
import cn.mybatis.mp.generator.core.template.MapperTemplateBuilder;
import cn.mybatis.mp.generator.core.template.MapperXmlTemplateBuilder;
import cn.mybatis.mp.generator.core.template.ServiceImplTemplateBuilder;
import cn.mybatis.mp.generator.core.template.ServiceTemplateBuilder;
import cn.mybatis.mp.generator.core.template.engine.TemplateEngine;
import db.sql.api.DbType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import lombok.Generated;

public class GeneratorConfig {
    private final boolean ignoreTable = false;
    private final List<Class<? extends ITemplateBuilder>> templateBuilders = new ArrayList<Class<? extends ITemplateBuilder>>();
    private DataBaseConfig dataBaseConfig;
    private ColumnConfig columnConfig = new ColumnConfig();
    private TableConfig tableConfig = new TableConfig();
    private MapperXmlConfig mapperXmlConfig = new MapperXmlConfig();
    private MapperConfig mapperConfig = new MapperConfig();
    private EntityConfig entityConfig = new EntityConfig();
    private DaoConfig daoConfig = new DaoConfig();
    private DaoImplConfig daoImplConfig = new DaoImplConfig();
    private ServiceConfig serviceConfig = new ServiceConfig();
    private ServiceImplConfig serviceImplConfig = new ServiceImplConfig();
    private ActionConfig actionConfig = new ActionConfig();
    private String charset = "utf-8";
    private ContainerType containerType = ContainerType.SPRING;
    private boolean ignoreView = false;
    private boolean finishOpen = false;
    private String baseFilePath = System.getProperty("user.dir") + "/generate";
    private String resourcePath;
    private String javaPath;
    private String basePackage;
    private String templateRootPath = "templates";
    private String author;
    private int swaggerVersion = 3;
    private boolean fileCover = true;
    private TemplateEngine templateEngine;

    public GeneratorConfig(String jdbcUrl, String username, String password) {
        this.templateBuilders.add(EntityTemplateBuilder.class);
        this.templateBuilders.add(MapperTemplateBuilder.class);
        this.templateBuilders.add(MapperXmlTemplateBuilder.class);
        this.templateBuilders.add(DaoTemplateBuilder.class);
        this.templateBuilders.add(DaoImplTemplateBuilder.class);
        this.templateBuilders.add(ServiceTemplateBuilder.class);
        this.templateBuilders.add(ServiceImplTemplateBuilder.class);
        this.templateBuilders.add(ActionTemplateBuilder.class);
        this.dataBaseConfig = new DataBaseConfig(jdbcUrl, username, password);
    }

    public GeneratorConfig(DbType dbType, DataSource dataSource) {
        this.templateBuilders.add(EntityTemplateBuilder.class);
        this.templateBuilders.add(MapperTemplateBuilder.class);
        this.templateBuilders.add(MapperXmlTemplateBuilder.class);
        this.templateBuilders.add(DaoTemplateBuilder.class);
        this.templateBuilders.add(DaoImplTemplateBuilder.class);
        this.templateBuilders.add(ServiceTemplateBuilder.class);
        this.templateBuilders.add(ServiceImplTemplateBuilder.class);
        this.templateBuilders.add(ActionTemplateBuilder.class);
        this.dataBaseConfig = new DataBaseConfig(dbType, dataSource);
    }

    public GeneratorConfig charset(String charset) {
        this.charset = charset;
        return this;
    }

    public GeneratorConfig containerType(ContainerType containerType) {
        this.containerType = containerType;
        return this;
    }

    public GeneratorConfig fileCover(boolean cover) {
        this.fileCover = cover;
        return this;
    }

    public GeneratorConfig dataBaseConfig(Consumer<DataBaseConfig> consumer) {
        consumer.accept(this.dataBaseConfig);
        return this;
    }

    public GeneratorConfig templateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public GeneratorConfig templateRootPath(String templateRootPath) {
        this.templateRootPath = templateRootPath;
        return this;
    }

    public GeneratorConfig templateBuilders(Consumer<List<Class<? extends ITemplateBuilder>>> consumer) {
        consumer.accept(this.templateBuilders);
        return this;
    }

    public GeneratorConfig baseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
        return this;
    }

    public GeneratorConfig resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public GeneratorConfig javaPath(String javaPath) {
        this.javaPath = javaPath;
        return this;
    }

    public GeneratorConfig basePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public GeneratorConfig author(String author) {
        this.author = author;
        return this;
    }

    public GeneratorConfig ignoreView(boolean ignoreView) {
        this.ignoreView = ignoreView;
        return this;
    }

    public GeneratorConfig tableConfig(Consumer<TableConfig> consumer) {
        consumer.accept(this.tableConfig);
        return this;
    }

    public GeneratorConfig columnConfig(Consumer<ColumnConfig> consumer) {
        consumer.accept(this.columnConfig);
        return this;
    }

    public GeneratorConfig entityConfig(Consumer<EntityConfig> consumer) {
        consumer.accept(this.entityConfig);
        return this;
    }

    public GeneratorConfig mapperConfig(Consumer<MapperConfig> consumer) {
        consumer.accept(this.mapperConfig);
        return this;
    }

    public GeneratorConfig mapperXmlConfig(Consumer<MapperXmlConfig> consumer) {
        consumer.accept(this.mapperXmlConfig);
        return this;
    }

    public GeneratorConfig daoConfig(Consumer<DaoConfig> consumer) {
        consumer.accept(this.daoConfig);
        return this;
    }

    public GeneratorConfig daoImplConfig(Consumer<DaoImplConfig> consumer) {
        consumer.accept(this.daoImplConfig);
        return this;
    }

    public GeneratorConfig serviceConfig(Consumer<ServiceConfig> consumer) {
        consumer.accept(this.serviceConfig);
        return this;
    }

    public GeneratorConfig serviceImplConfig(Consumer<ServiceImplConfig> consumer) {
        consumer.accept(this.serviceImplConfig);
        return this;
    }

    public GeneratorConfig actionConfig(Consumer<ActionConfig> consumer) {
        consumer.accept(this.actionConfig);
        return this;
    }

    public GeneratorConfig finishOpen(boolean finishOpen) {
        this.finishOpen = finishOpen;
        return this;
    }

    public GeneratorConfig swaggerVersion(int swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
        return this;
    }

    public void setDataBaseConfig(DataBaseConfig dataBaseConfig) {
        this.dataBaseConfig = dataBaseConfig;
    }

    public void setColumnConfig(ColumnConfig columnConfig) {
        this.columnConfig = columnConfig;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public void setEntityConfig(EntityConfig entityConfig) {
        this.entityConfig = entityConfig;
    }

    public void setMapperXmlConfig(MapperXmlConfig mapperXmlConfig) {
        this.mapperXmlConfig = mapperXmlConfig;
    }

    public void setMapperConfig(MapperConfig mapperConfig) {
        this.mapperConfig = mapperConfig;
    }

    public void setDaoConfig(DaoConfig daoConfig) {
        this.daoConfig = daoConfig;
    }

    public void setDaoImplConfig(DaoImplConfig daoImplConfig) {
        this.daoImplConfig = daoImplConfig;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public void setServiceImplConfig(ServiceImplConfig serviceImplConfig) {
        this.serviceImplConfig = serviceImplConfig;
    }

    public void setActionConfig(ActionConfig actionConfig) {
        this.actionConfig = actionConfig;
    }

    @Generated
    public boolean isIgnoreTable() {
        return this.ignoreTable;
    }

    @Generated
    public List<Class<? extends ITemplateBuilder>> getTemplateBuilders() {
        return this.templateBuilders;
    }

    @Generated
    public DataBaseConfig getDataBaseConfig() {
        return this.dataBaseConfig;
    }

    @Generated
    public ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    @Generated
    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    @Generated
    public MapperXmlConfig getMapperXmlConfig() {
        return this.mapperXmlConfig;
    }

    @Generated
    public MapperConfig getMapperConfig() {
        return this.mapperConfig;
    }

    @Generated
    public EntityConfig getEntityConfig() {
        return this.entityConfig;
    }

    @Generated
    public DaoConfig getDaoConfig() {
        return this.daoConfig;
    }

    @Generated
    public DaoImplConfig getDaoImplConfig() {
        return this.daoImplConfig;
    }

    @Generated
    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Generated
    public ServiceImplConfig getServiceImplConfig() {
        return this.serviceImplConfig;
    }

    @Generated
    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    @Generated
    public String getCharset() {
        return this.charset;
    }

    @Generated
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Generated
    public boolean isIgnoreView() {
        return this.ignoreView;
    }

    @Generated
    public boolean isFinishOpen() {
        return this.finishOpen;
    }

    @Generated
    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    @Generated
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Generated
    public String getJavaPath() {
        return this.javaPath;
    }

    @Generated
    public String getBasePackage() {
        return this.basePackage;
    }

    @Generated
    public String getTemplateRootPath() {
        return this.templateRootPath;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public int getSwaggerVersion() {
        return this.swaggerVersion;
    }

    @Generated
    public boolean isFileCover() {
        return this.fileCover;
    }

    @Generated
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }
}

