/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.template;

import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.EntityInfo;
import cn.mybatis.mp.generator.core.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.core.util.GeneratorUtil;
import cn.mybatis.mp.generator.core.util.PathUtils;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class DaoImplTemplateBuilder
extends AbstractTemplateBuilder {
    public DaoImplTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getDaoImplConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return PathUtils.buildFilePath(this.generatorConfig.getBaseFilePath(), this.generatorConfig.getJavaPath(), this.entityInfo.getDaoImplPackage().replaceAll("\\.", Matcher.quoteReplacement(File.separator)), this.entityInfo.getDaoImplName()) + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/dao.impl";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        GeneratorUtil.buildDaoImplImports(this.generatorConfig, this.entityInfo, data);
        if (this.generatorConfig.getDaoImplConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getDaoImplConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getDaoImplConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getDaoImplConfig().getSuperClass();
            data.put("superExtend", " extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("entityConfig", this.generatorConfig.getEntityConfig());
        data.put("mapperConfig", this.generatorConfig.getMapperConfig());
        data.put("daoConfig", this.generatorConfig.getDaoConfig());
        data.put("daoImplConfig", this.generatorConfig.getDaoImplConfig());
        data.put("serviceConfig", this.generatorConfig.getServiceConfig());
        data.put("serviceImplConfig", this.generatorConfig.getServiceImplConfig());
        data.put("generatorConfig", this.generatorConfig);
        data.put("containerType", (Object)this.generatorConfig.getContainerType());
        return data;
    }
}

