/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.database.meta;

import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.generator.core.config.ActionConfig;
import cn.mybatis.mp.generator.core.config.DaoConfig;
import cn.mybatis.mp.generator.core.config.DaoImplConfig;
import cn.mybatis.mp.generator.core.config.EntityConfig;
import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.config.MapperConfig;
import cn.mybatis.mp.generator.core.config.ServiceConfig;
import cn.mybatis.mp.generator.core.config.ServiceImplConfig;
import cn.mybatis.mp.generator.core.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.core.database.meta.EntityFieldInfo;
import cn.mybatis.mp.generator.core.database.meta.TableInfo;
import cn.mybatis.mp.generator.core.util.ClassUtils;
import cn.mybatis.mp.generator.core.util.GeneratorUtil;
import cn.mybatis.mp.generator.core.util.PathUtils;
import db.sql.api.impl.tookit.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class EntityInfo {
    public final String serviceName;
    public final String servicePackage;
    public final String serviceImplName;
    public final String serviceImplPackage;
    public final String actionName;
    public final String actionPackage;
    private final TableInfo tableInfo;
    private final String name;
    private final String remarks;
    private final EntityFieldInfo idFieldInfo;
    private final List<EntityFieldInfo> idFieldInfoList;
    private final List<EntityFieldInfo> allFieldInfoList;
    private final List<EntityFieldInfo> fieldInfoList;
    private final List<EntityFieldInfo> excludeFieldInfoList;
    private final String entityPackage;
    private final String mapperName;
    private final String mapperPackage;
    private final String daoName;
    private final String daoPackage;
    private final String daoImplName;
    private final String daoImplPackage;
    private boolean hasIgnorePrefix = false;

    public EntityInfo(GeneratorConfig generatorConfig, TableInfo tableInfo) {
        String handledTableName = NamingUtil.removePrefix((String)tableInfo.getName(), generatorConfig.getTableConfig().getTablePrefixes());
        this.hasIgnorePrefix = handledTableName != tableInfo.getName();
        this.name = GeneratorUtil.getEntityName(generatorConfig, handledTableName);
        this.remarks = tableInfo.getRemarks();
        this.tableInfo = tableInfo;
        this.idFieldInfo = tableInfo.getIdColumnInfo() != null ? new EntityFieldInfo(generatorConfig, this, tableInfo.getIdColumnInfo()) : null;
        this.idFieldInfoList = tableInfo.getIdColumnInfoList().stream().map(item -> new EntityFieldInfo(generatorConfig, this, (ColumnInfo)item)).collect(Collectors.toList());
        this.allFieldInfoList = tableInfo.getColumnInfoList().stream().map(item -> new EntityFieldInfo(generatorConfig, this, (ColumnInfo)item)).collect(Collectors.toList());
        this.excludeFieldInfoList = this.allFieldInfoList.stream().filter(item -> generatorConfig.getEntityConfig().getExcludeColumns().contains(item.getColumnInfo().getName()) || generatorConfig.getEntityConfig().getExcludeColumns().contains(item.getColumnInfo().getName().toUpperCase())).collect(Collectors.toList());
        ArrayList<EntityFieldInfo> fieldInfoList = new ArrayList<EntityFieldInfo>(this.allFieldInfoList);
        fieldInfoList.removeAll(this.excludeFieldInfoList);
        this.fieldInfoList = fieldInfoList;
        this.entityPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getEntityConfig().getPackageName());
        this.mapperName = this.name + generatorConfig.getMapperConfig().getSuffix();
        this.mapperPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getMapperConfig().getPackageName());
        this.daoName = this.name + generatorConfig.getDaoConfig().getSuffix();
        this.daoPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getDaoConfig().getPackageName());
        this.daoImplName = this.name + generatorConfig.getDaoImplConfig().getSuffix();
        this.daoImplPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getDaoImplConfig().getPackageName());
        this.serviceName = this.name + generatorConfig.getServiceConfig().getSuffix();
        this.servicePackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getServiceConfig().getPackageName());
        this.serviceImplName = this.name + generatorConfig.getServiceImplConfig().getSuffix();
        this.serviceImplPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getServiceImplConfig().getPackageName());
        this.actionName = this.name + generatorConfig.getActionConfig().getSuffix();
        this.actionPackage = PathUtils.buildPackage(generatorConfig.getBasePackage(), generatorConfig.getActionConfig().getPackageName());
    }

    public boolean hasId() {
        return !this.idFieldInfoList.isEmpty();
    }

    public boolean hasMultiId() {
        return this.idFieldInfoList.size() > 1;
    }

    public String buildTable(EntityConfig entityConfig) {
        StringBuilder stringBuilder = new StringBuilder("@Table(");
        stringBuilder.append("value =\"").append(this.getTableInfo().getName()).append("\",");
        if (!entityConfig.isSchema() && this.getTableInfo().getSchema() != null && !this.getTableInfo().getSchema().isEmpty()) {
            stringBuilder.append("schema = \"").append(this.getTableInfo().getSchema()).append("\",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String buildClassFullName(EntityConfig entityConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        if (entityConfig.getSuperClass() != null) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(entityConfig.getSuperClass()));
        }
        if (entityConfig.isSerial()) {
            stringBuilder.append("  implements java.io.Serializable");
        }
        return stringBuilder.toString();
    }

    public String buildMapperClassFullName(MapperConfig mapperConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getMapperName());
        if (Objects.nonNull((Object)mapperConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(mapperConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)mapperConfig.getSuperClass())) {
            stringBuilder.append(this.buildGeneric());
        }
        return stringBuilder.toString();
    }

    public String buildDaoClassFullName(DaoConfig daoConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getDaoName());
        if (Objects.nonNull((Object)daoConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(daoConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)daoConfig.getSuperClass()) && daoConfig.isGeneric()) {
            stringBuilder.append(this.buildGenericWithId());
        }
        return stringBuilder.toString();
    }

    public String buildDaoImplClassFullName(DaoConfig daoConfig, DaoImplConfig daoImplConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getDaoImplName());
        if (Objects.nonNull((Object)daoImplConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(daoImplConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)daoImplConfig.getSuperClass()) && daoConfig.isGeneric()) {
            stringBuilder.append(this.buildGenericWithId());
        }
        if (daoConfig.isEnable()) {
            stringBuilder.append(" implements ").append(this.getDaoName());
        }
        return stringBuilder.toString();
    }

    public String buildServiceClassFullName(ServiceConfig serviceConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getServiceName());
        if (Objects.nonNull((Object)serviceConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(serviceConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)serviceConfig.getSuperClass()) && serviceConfig.isGeneric()) {
            stringBuilder.append(this.buildGenericWithId());
        }
        return stringBuilder.toString();
    }

    public String buildServiceImplClassFullName(ServiceConfig serviceConfig, ServiceImplConfig serviceImplConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getServiceImplName());
        if (Objects.nonNull((Object)serviceImplConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(serviceImplConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)serviceImplConfig.getSuperClass()) && serviceImplConfig.isGeneric()) {
            stringBuilder.append(this.buildGenericWithId());
        }
        if (serviceConfig.isEnable()) {
            stringBuilder.append(" implements ").append(this.getServiceName());
        }
        return stringBuilder.toString();
    }

    public String buildActionClassFullName(ActionConfig actionConfig) {
        StringBuilder stringBuilder = new StringBuilder(this.getActionName());
        if (Objects.nonNull((Object)actionConfig.getSuperClass())) {
            stringBuilder.append(" extends ").append(ClassUtils.getClassSimpleName(actionConfig.getSuperClass()));
        }
        if (Objects.nonNull((Object)actionConfig.getSuperClass()) && actionConfig.isGeneric()) {
            stringBuilder.append(this.buildGenericWithId());
        }
        return stringBuilder.toString();
    }

    public String buildGeneric() {
        return "<" + this.getName() + ">";
    }

    public String buildGenericWithId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getName()).append(", ");
        if (Objects.nonNull((Object)this.idFieldInfo)) {
            stringBuilder.append(Objects.nonNull((Object)this.idFieldInfo) ? this.idFieldInfo.getTypeName() : "Void");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getServicePackage() {
        return this.servicePackage;
    }

    @Generated
    public String getServiceImplName() {
        return this.serviceImplName;
    }

    @Generated
    public String getServiceImplPackage() {
        return this.serviceImplPackage;
    }

    @Generated
    public String getActionName() {
        return this.actionName;
    }

    @Generated
    public String getActionPackage() {
        return this.actionPackage;
    }

    @Generated
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRemarks() {
        return this.remarks;
    }

    @Generated
    public EntityFieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }

    @Generated
    public List<EntityFieldInfo> getIdFieldInfoList() {
        return this.idFieldInfoList;
    }

    @Generated
    public List<EntityFieldInfo> getAllFieldInfoList() {
        return this.allFieldInfoList;
    }

    @Generated
    public List<EntityFieldInfo> getFieldInfoList() {
        return this.fieldInfoList;
    }

    @Generated
    public List<EntityFieldInfo> getExcludeFieldInfoList() {
        return this.excludeFieldInfoList;
    }

    @Generated
    public String getEntityPackage() {
        return this.entityPackage;
    }

    @Generated
    public String getMapperName() {
        return this.mapperName;
    }

    @Generated
    public String getMapperPackage() {
        return this.mapperPackage;
    }

    @Generated
    public String getDaoName() {
        return this.daoName;
    }

    @Generated
    public String getDaoPackage() {
        return this.daoPackage;
    }

    @Generated
    public String getDaoImplName() {
        return this.daoImplName;
    }

    @Generated
    public String getDaoImplPackage() {
        return this.daoImplPackage;
    }

    @Generated
    public boolean isHasIgnorePrefix() {
        return this.hasIgnorePrefix;
    }

    @Generated
    public String toString() {
        return "EntityInfo(serviceName=" + this.getServiceName() + ", servicePackage=" + this.getServicePackage() + ", serviceImplName=" + this.getServiceImplName() + ", serviceImplPackage=" + this.getServiceImplPackage() + ", actionName=" + this.getActionName() + ", actionPackage=" + this.getActionPackage() + ", tableInfo=" + this.getTableInfo() + ", name=" + this.getName() + ", remarks=" + this.getRemarks() + ", idFieldInfo=" + this.getIdFieldInfo() + ", idFieldInfoList=" + this.getIdFieldInfoList() + ", allFieldInfoList=" + this.getAllFieldInfoList() + ", fieldInfoList=" + this.getFieldInfoList() + ", excludeFieldInfoList=" + this.getExcludeFieldInfoList() + ", entityPackage=" + this.getEntityPackage() + ", mapperName=" + this.getMapperName() + ", mapperPackage=" + this.getMapperPackage() + ", daoName=" + this.getDaoName() + ", daoPackage=" + this.getDaoPackage() + ", daoImplName=" + this.getDaoImplName() + ", daoImplPackage=" + this.getDaoImplPackage() + ", hasIgnorePrefix=" + this.isHasIgnorePrefix() + ")";
    }
}

