/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.database.meta;

import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.generator.core.config.EntityConfig;
import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.core.database.meta.EntityInfo;
import cn.mybatis.mp.generator.core.util.GeneratorUtil;
import lombok.Generated;

public class EntityFieldInfo {
    private final EntityInfo entityInfo;
    private final ColumnInfo columnInfo;
    private final String name;
    private final Class<?> type;
    private final String typeName;
    private final String remarks;
    private final boolean select;
    private final boolean update;
    private final String defaultTableIdCode;
    private final boolean alwaysAnnotation;
    private boolean hasIgnorePrefix = false;

    public EntityFieldInfo(GeneratorConfig generatorConfig, EntityInfo entityInfo, ColumnInfo columnInfo) {
        this.entityInfo = entityInfo;
        this.columnInfo = columnInfo;
        String columnName = columnInfo.getName();
        String handledTableName = NamingUtil.removePrefix((String)columnName, generatorConfig.getColumnConfig().getColumnPrefixes());
        this.hasIgnorePrefix = handledTableName != columnName;
        this.update = !generatorConfig.getColumnConfig().getDisableUpdateColumns().contains(columnName);
        this.name = GeneratorUtil.getEntityFieldName(generatorConfig, handledTableName);
        this.remarks = GeneratorUtil.getEntityFieldRemarks(generatorConfig, columnInfo);
        this.type = GeneratorUtil.getColumnType(generatorConfig, columnInfo);
        this.select = this.type == byte[].class ? false : !generatorConfig.getColumnConfig().getDisableSelectColumns().contains(columnInfo.getName());
        this.typeName = this.type.getSimpleName();
        this.defaultTableIdCode = generatorConfig.getEntityConfig().getDefaultTableIdCode();
        this.alwaysAnnotation = generatorConfig.getEntityConfig().isAlwaysAnnotation();
    }

    public boolean isNeedTableField(EntityConfig entityConfig) {
        return this.alwaysAnnotation || this.hasIgnorePrefix || !this.select || !this.update || entityConfig.isDefaultValueEnable() && this.getColumnInfo().getDefaultValue() != null;
    }

    public String buildTableField(EntityConfig entityConfig) {
        StringBuilder stringBuilder = new StringBuilder("@TableField(");
        if (this.alwaysAnnotation || this.hasIgnorePrefix) {
            stringBuilder.append("value =\"").append(this.getColumnInfo().getName()).append("\",");
        }
        if (!this.select) {
            stringBuilder.append("select = false,");
        }
        if (!this.update) {
            stringBuilder.append("update = false,");
        }
        if (entityConfig.isDefaultValueEnable() && this.getColumnInfo().getDefaultValue() != null) {
            stringBuilder.append("defaultValue = \"").append(this.getColumnInfo().getDefaultValue().replace("\"", "\\\"")).append("\",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getterMethodName() {
        return (this.type == Boolean.class ? "is" : "get") + NamingUtil.firstToUpperCase((String)this.name);
    }

    public String setterMethodName() {
        return "set" + NamingUtil.firstToUpperCase((String)this.name);
    }

    public String buildTableIdCode() {
        if (!this.columnInfo.isPrimaryKey()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("@TableId");
        if (this.columnInfo.isAutoIncrement()) {
            stringBuilder.append("(IdAutoType.AUTO)");
        } else {
            if (this.defaultTableIdCode != null) {
                return this.defaultTableIdCode;
            }
            stringBuilder.append("(IdAutoType.NONE)");
        }
        return stringBuilder.toString();
    }

    @Generated
    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    @Generated
    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getRemarks() {
        return this.remarks;
    }

    @Generated
    public boolean isSelect() {
        return this.select;
    }

    @Generated
    public boolean isUpdate() {
        return this.update;
    }

    @Generated
    public String getDefaultTableIdCode() {
        return this.defaultTableIdCode;
    }

    @Generated
    public boolean isAlwaysAnnotation() {
        return this.alwaysAnnotation;
    }

    @Generated
    public boolean isHasIgnorePrefix() {
        return this.hasIgnorePrefix;
    }

    @Generated
    public String toString() {
        return "EntityFieldInfo(columnInfo=" + this.getColumnInfo() + ", name=" + this.getName() + ", type=" + this.getType() + ", typeName=" + this.getTypeName() + ", remarks=" + this.getRemarks() + ", select=" + this.isSelect() + ", update=" + this.isUpdate() + ", defaultTableIdCode=" + this.getDefaultTableIdCode() + ", alwaysAnnotation=" + this.isAlwaysAnnotation() + ", hasIgnorePrefix=" + this.isHasIgnorePrefix() + ")";
    }
}

