/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.database.meta;

import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.core.database.meta.TableInfo;
import cn.mybatis.mp.generator.core.util.StringCodeSafeUtil;
import db.sql.api.impl.tookit.Objects;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaDataQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableMetaDataQuery.class);
    protected final DatabaseMetaData metaData;
    protected final GeneratorConfig generatorConfig;
    protected final String connDatabaseName;
    protected final String connSchema;

    public TableMetaDataQuery(GeneratorConfig generatorConfig, Connection connection) throws SQLException {
        this.metaData = connection.getMetaData();
        this.connSchema = connection.getSchema();
        this.generatorConfig = generatorConfig;
        this.connDatabaseName = connection.getCatalog();
    }

    private boolean isTableNeedInclude(String tableName) {
        if (this.generatorConfig.getTableConfig().getExcludeTables().contains(tableName)) {
            return false;
        }
        return this.generatorConfig.getTableConfig().getIncludeTables().isEmpty() || this.generatorConfig.getTableConfig().getIncludeTables().contains(tableName);
    }

    private List<TableInfo> getTableInfoList(String databaseName, String schema, String tableNamePattern, String[] types) {
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        try (ResultSet resultSet = this.metaData.getTables(databaseName, schema, tableNamePattern, types);){
            while (resultSet.next()) {
                String TABLE_NAME = resultSet.getString("TABLE_NAME");
                String tableName = TABLE_NAME;
                if (tableName.toUpperCase().equals(tableName)) {
                    tableName = tableName.toLowerCase();
                }
                if (!this.isTableNeedInclude(TABLE_NAME) && !this.isTableNeedInclude(tableName)) continue;
                TableInfo tableInfo = new TableInfo();
                tableInfo.setName(tableName);
                String remarks = resultSet.getString("REMARKS");
                tableInfo.setRemarks(StringCodeSafeUtil.removeSpecialCharacters(remarks));
                tableInfo.setTableType(resultSet.getString("TABLE_TYPE"));
                tableInfo.setSchema(resultSet.getString("TABLE_SCHEM"));
                tableInfo.setCatalog(resultSet.getString("TABLE_CAT"));
                tableInfo.setColumnInfoList(this.getColumnInfo(tableInfo, TABLE_NAME));
                List<ColumnInfo> idColumnInfoList = tableInfo.getColumnInfoList().stream().filter(item -> item.isPrimaryKey()).collect(Collectors.toList());
                if (!idColumnInfoList.isEmpty() && idColumnInfoList.size() == 1) {
                    tableInfo.setIdColumnInfo(idColumnInfoList.get(0));
                }
                tableInfo.setIdColumnInfoList(idColumnInfoList);
                tables.add(tableInfo);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f\u51fa\u73b0\u9519\u8bef", e);
        }
        return tables;
    }

    public List<TableInfo> getTableInfoList(boolean includeTable, boolean includeView) {
        String schema;
        String[] types;
        if (includeTable && includeView) {
            types = new String[]{"TABLE", "VIEW"};
        } else if (includeTable) {
            types = new String[]{"TABLE"};
        } else if (includeView) {
            types = new String[]{"VIEW"};
        } else {
            throw new RuntimeException("includeTable or includeView must be true");
        }
        String databaseName = this.generatorConfig.getDataBaseConfig().getDatabaseName();
        if (databaseName == null) {
            databaseName = this.connDatabaseName;
        }
        String string = schema = Objects.isNull((Object)(schema = this.generatorConfig.getDataBaseConfig().getSchema())) ? this.connSchema : schema;
        if (this.generatorConfig.getTableConfig().getIncludeTables().isEmpty() || this.generatorConfig.getTableConfig().getIncludeTables().size() > 5) {
            return this.getTableInfoList(databaseName, schema, null, types);
        }
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        for (String table : this.generatorConfig.getTableConfig().getIncludeTables()) {
            List<TableInfo> list = this.getTableInfoList(databaseName, schema, table, types);
            if (list.isEmpty()) {
                list = this.getTableInfoList(databaseName, schema, table.toUpperCase(), types);
            }
            tables.addAll(list);
        }
        return tables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ColumnInfo> getColumnInfo(TableInfo tableInfo, String tableName) {
        HashSet<String> primaryKeys = new HashSet<String>();
        if (!tableInfo.isView()) {
            try (ResultSet primaryKeysResultSet = this.metaData.getPrimaryKeys(tableInfo.getCatalog(), tableInfo.getSchema(), tableName);){
                while (primaryKeysResultSet.next()) {
                    String columnName = primaryKeysResultSet.getString("COLUMN_NAME");
                    if (columnName.toUpperCase().equals(columnName)) {
                        columnName = columnName.toLowerCase();
                    }
                    primaryKeys.add(columnName);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("\u8bfb\u53d6\u8868\u4e3b\u952e\u4fe1\u606f:" + tableInfo.getName() + "\u9519\u8bef:", e);
            }
        }
        if (primaryKeys.isEmpty()) {
            log.warn("\u5f53\u524d\u8868:{}\uff0c\u5b58\u5728\u65e0\u4e3b\u952e\u60c5\u51b5\uff01", (Object)tableInfo.getName());
        }
        ArrayList<ColumnInfo> columnsInfoList = new ArrayList<ColumnInfo>();
        try (ResultSet resultSet = this.metaData.getColumns(tableInfo.getCatalog(), tableInfo.getSchema(), tableName, "%");){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                if (columnName.toUpperCase().equals(columnName)) {
                    columnName = columnName.toLowerCase();
                }
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setTableInfo(tableInfo);
                columnInfo.setName(columnName);
                columnInfo.setPrimaryKey(primaryKeys.contains(columnInfo.getName()));
                columnInfo.setTypeName(resultSet.getString("TYPE_NAME"));
                columnInfo.setJdbcType(JdbcType.forCode((int)resultSet.getInt("DATA_TYPE")));
                columnInfo.setLength(resultSet.getInt("COLUMN_SIZE"));
                columnInfo.setScale(resultSet.getInt("DECIMAL_DIGITS"));
                String remarks = resultSet.getString("REMARKS");
                columnInfo.setRemarks(StringCodeSafeUtil.removeSpecialCharacters(remarks));
                columnInfo.setDefaultValue(this.generatorConfig.getColumnConfig().getDefaultValueConvert().apply(resultSet.getString("COLUMN_DEF")));
                columnInfo.setNullable(resultSet.getInt("NULLABLE") == 1);
                columnInfo.setVersion(columnName.equals(this.generatorConfig.getColumnConfig().getVersionColumn()));
                columnInfo.setTenantId(columnName.equals(this.generatorConfig.getColumnConfig().getTenantIdColumn()));
                columnInfo.setLogicDelete(columnName.equals(this.generatorConfig.getColumnConfig().getLogicDeleteColumn()));
                try {
                    columnInfo.setAutoIncrement("YES".equals(resultSet.getString("IS_AUTOINCREMENT")));
                }
                catch (SQLException e) {
                    log.error("\u83b7\u53d6\u81ea\u589e\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                }
                columnsInfoList.add(columnInfo);
            }
            ArrayList<ColumnInfo> arrayList = columnsInfoList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f:" + tableInfo.getName() + "\u9519\u8bef:", e);
        }
    }
}

