/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core.config;

import cn.mybatis.mp.generator.core.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.core.strategy.NamingStrategy;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.ibatis.type.JdbcType;

public class EntityConfig {
    private final List<String> excludeColumns = new ArrayList<String>();
    private final Map<JdbcType, Class<?>> typeMapping = new HashMap();
    private boolean swagger = false;
    private boolean serial = false;
    private String superClass;
    private boolean lombok = true;
    private boolean lombokBuilder = false;
    private boolean schema = false;
    private boolean defaultValueEnable = true;
    private String defaultTableIdCode;
    private String logicDeleteCode;
    private String packageName = "DO";
    private Function<String, String> nameConvert;
    private NamingStrategy fieldNamingStrategy = NamingStrategy.UNDERLINE_TO_CAMEL;
    private Function<String, String> fieldNameConverter;
    private Function<ColumnInfo, String> remarksConverter;
    private boolean alwaysAnnotation;

    public EntityConfig() {
        this.typeMapping.put(JdbcType.BIT, Boolean.class);
        this.typeMapping.put(JdbcType.TINYINT, Byte.class);
        this.typeMapping.put(JdbcType.SMALLINT, Integer.class);
        this.typeMapping.put(JdbcType.INTEGER, Integer.class);
        this.typeMapping.put(JdbcType.BIGINT, Long.class);
        this.typeMapping.put(JdbcType.FLOAT, Double.class);
        this.typeMapping.put(JdbcType.REAL, Double.class);
        this.typeMapping.put(JdbcType.DOUBLE, Double.class);
        this.typeMapping.put(JdbcType.NUMERIC, BigDecimal.class);
        this.typeMapping.put(JdbcType.DECIMAL, BigDecimal.class);
        this.typeMapping.put(JdbcType.CHAR, Character.class);
        this.typeMapping.put(JdbcType.VARCHAR, String.class);
        this.typeMapping.put(JdbcType.LONGVARCHAR, String.class);
        this.typeMapping.put(JdbcType.DATE, LocalDateTime.class);
        this.typeMapping.put(JdbcType.TIME, LocalTime.class);
        this.typeMapping.put(JdbcType.TIMESTAMP, LocalDateTime.class);
        this.typeMapping.put(JdbcType.BINARY, byte[].class);
        this.typeMapping.put(JdbcType.VARBINARY, byte[].class);
        this.typeMapping.put(JdbcType.LONGVARBINARY, byte[].class);
        this.typeMapping.put(JdbcType.BLOB, byte[].class);
        this.typeMapping.put(JdbcType.CLOB, String.class);
        this.typeMapping.put(JdbcType.BOOLEAN, Boolean.class);
        this.typeMapping.put(JdbcType.NVARCHAR, String.class);
        this.typeMapping.put(JdbcType.NCHAR, String.class);
        this.typeMapping.put(JdbcType.NCLOB, String.class);
        this.typeMapping.put(JdbcType.LONGNVARCHAR, String.class);
        this.typeMapping.put(JdbcType.DATETIMEOFFSET, OffsetDateTime.class);
        this.typeMapping.put(JdbcType.TIME_WITH_TIMEZONE, OffsetTime.class);
        this.typeMapping.put(JdbcType.TIMESTAMP_WITH_TIMEZONE, OffsetDateTime.class);
    }

    public EntityConfig swagger(boolean enable) {
        this.swagger = enable;
        return this;
    }

    public EntityConfig serial(boolean enable) {
        this.serial = enable;
        return this;
    }

    public EntityConfig superClass(String superClass) {
        this.superClass = superClass;
        return this;
    }

    public EntityConfig excludeColumns(String ... columns) {
        this.excludeColumns.addAll(Arrays.asList(columns));
        return this;
    }

    public EntityConfig superClass(Class superClass) {
        this.superClass = superClass.getName();
        return this;
    }

    public EntityConfig lombok(boolean enable) {
        this.lombok = enable;
        return this;
    }

    public EntityConfig lombokBuilder(boolean enable) {
        this.lombokBuilder = enable;
        return this;
    }

    public EntityConfig defaultValueEnable(boolean enable) {
        this.defaultValueEnable = enable;
        return this;
    }

    public EntityConfig schema(boolean schema) {
        this.schema = schema;
        return this;
    }

    public EntityConfig packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public EntityConfig typeMapping(Consumer<Map<JdbcType, Class<?>>> consumer) {
        consumer.accept(this.typeMapping);
        return this;
    }

    public EntityConfig nameConvert(Function<String, String> nameConvert) {
        this.nameConvert = nameConvert;
        return this;
    }

    public EntityConfig fieldNamingStrategy(NamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
        return this;
    }

    public EntityConfig fieldNameConverter(Function<String, String> fieldNameConverter) {
        this.fieldNameConverter = fieldNameConverter;
        return this;
    }

    public EntityConfig remarksConverter(Function<ColumnInfo, String> remarksConverter) {
        this.remarksConverter = remarksConverter;
        return this;
    }

    public EntityConfig defaultTableIdCode(String defaultTableIdCode) {
        this.defaultTableIdCode = defaultTableIdCode;
        return this;
    }

    public EntityConfig logicDeleteCode(String logicDeleteCode) {
        this.logicDeleteCode = logicDeleteCode;
        return this;
    }

    public EntityConfig alwaysAnnotation(boolean alwaysAnnotation) {
        this.alwaysAnnotation = alwaysAnnotation;
        return this;
    }

    public boolean isAlwaysAnnotation() {
        return this.alwaysAnnotation;
    }

    @Generated
    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    @Generated
    public Map<JdbcType, Class<?>> getTypeMapping() {
        return this.typeMapping;
    }

    @Generated
    public boolean isSwagger() {
        return this.swagger;
    }

    @Generated
    public boolean isSerial() {
        return this.serial;
    }

    @Generated
    public String getSuperClass() {
        return this.superClass;
    }

    @Generated
    public boolean isLombok() {
        return this.lombok;
    }

    @Generated
    public boolean isLombokBuilder() {
        return this.lombokBuilder;
    }

    @Generated
    public boolean isSchema() {
        return this.schema;
    }

    @Generated
    public boolean isDefaultValueEnable() {
        return this.defaultValueEnable;
    }

    @Generated
    public String getDefaultTableIdCode() {
        return this.defaultTableIdCode;
    }

    @Generated
    public String getLogicDeleteCode() {
        return this.logicDeleteCode;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public Function<String, String> getNameConvert() {
        return this.nameConvert;
    }

    @Generated
    public NamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    @Generated
    public Function<String, String> getFieldNameConverter() {
        return this.fieldNameConverter;
    }

    @Generated
    public Function<ColumnInfo, String> getRemarksConverter() {
        return this.remarksConverter;
    }
}

