/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.core;

import cn.mybatis.mp.generator.core.config.GeneratorConfig;
import cn.mybatis.mp.generator.core.database.meta.EntityInfo;
import cn.mybatis.mp.generator.core.database.meta.TableInfo;
import cn.mybatis.mp.generator.core.database.meta.TableMetaDataQuery;
import cn.mybatis.mp.generator.core.template.ITemplateBuilder;
import cn.mybatis.mp.generator.core.template.engine.FreemarkerTemplateEngine;
import cn.mybatis.mp.generator.core.template.engine.TemplateEngine;
import cn.mybatis.mp.generator.core.util.RuntimeUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FastGenerator.class);
    private final GeneratorConfig generatorConfig;

    public FastGenerator(GeneratorConfig generatorConfig) {
        this.generatorConfig = generatorConfig;
    }

    public void create() {
        List entityInfoList;
        try {
            Connection connection = this.generatorConfig.getDataBaseConfig().getConnection();
            Object object = null;
            try {
                TableMetaDataQuery tableMetaDataQuery = new TableMetaDataQuery(this.generatorConfig, connection);
                List<TableInfo> tableInfoList = tableMetaDataQuery.getTableInfoList(!this.generatorConfig.isIgnoreTable(), !this.generatorConfig.isIgnoreView());
                log.info("mybatis-mp-generator found {} tables and {} views", (Object)tableInfoList.stream().filter(tableInfo -> !tableInfo.isView()).count(), (Object)tableInfoList.stream().filter(tableInfo -> tableInfo.isView()).count());
                entityInfoList = tableInfoList.stream().map(item -> new EntityInfo(this.generatorConfig, (TableInfo)item)).collect(Collectors.toList());
            }
            catch (Throwable tableMetaDataQuery) {
                object = tableMetaDataQuery;
                throw tableMetaDataQuery;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable tableMetaDataQuery) {
                            ((Throwable)object).addSuppressed(tableMetaDataQuery);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        log.info("mybatis-mp-generator's base file path is {}", (Object)this.generatorConfig.getBaseFilePath());
        TemplateEngine templateEngine = this.generatorConfig.getTemplateEngine();
        templateEngine = templateEngine == null ? new FreemarkerTemplateEngine() : templateEngine;
        for (EntityInfo entityInfo : entityInfoList) {
            for (Class<? extends ITemplateBuilder> templateBuilderClass : this.generatorConfig.getTemplateBuilders()) {
                ITemplateBuilder templateBuilder;
                try {
                    templateBuilder = templateBuilderClass.getConstructor(GeneratorConfig.class, EntityInfo.class).newInstance(this.generatorConfig, entityInfo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!templateBuilder.enable()) continue;
                templateEngine.render(templateBuilder);
            }
        }
        if (this.generatorConfig.isFinishOpen()) {
            RuntimeUtils.openDir(this.generatorConfig.getBaseFilePath());
        }
    }
}

