/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.BaseTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FloatTypeHandler
extends BaseTypeHandler<Float> {
    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 6);
        } else {
            ps.setFloat(i, ((Float)parameter).floatValue());
        }
    }

    @Override
    public Float getNullableResult(ResultSet rs, String columnName) throws SQLException {
        float result = rs.getFloat(columnName);
        return result == 0.0f && rs.wasNull() ? null : Float.valueOf(result);
    }

    @Override
    public Float getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        float result = rs.getFloat(columnIndex);
        return result == 0.0f && rs.wasNull() ? null : Float.valueOf(result);
    }

    @Override
    public Float getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        float result = cs.getFloat(columnIndex);
        return result == 0.0f && cs.wasNull() ? null : Float.valueOf(result);
    }
}

