/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.BaseTypeHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobTypeHandler
extends BaseTypeHandler<byte[]> {
    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 2004);
        } else {
            byte[] arr = (byte[])parameter;
            ByteArrayInputStream bis = new ByteArrayInputStream(arr);
            ps.setBinaryStream(i, (InputStream)bis, arr.length);
        }
    }

    @Override
    public byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }

    @Override
    public byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }

    @Override
    public byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Blob blob = cs.getBlob(columnIndex);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }
}

