/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.rabbitmq;

import cn.myafx.rabbitmq.ExchangeConfig;
import cn.myafx.rabbitmq.IJsonMapper;
import cn.myafx.rabbitmq.IMQPool;
import cn.myafx.rabbitmq.ISubException;
import cn.myafx.rabbitmq.ISubHander;
import cn.myafx.rabbitmq.MapperDto;
import cn.myafx.rabbitmq.PubMsgConfig;
import cn.myafx.rabbitmq.QueueConfig;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MQPool
implements IMQPool {
    private Object lockCreate = new Object();
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private String clientName;
    private Channel subChannel;
    private Object lockSubChannel = new Object();
    private Object lockGetSubChannel = new Object();
    private int maxPushPool = 3;
    private Queue<Channel> pubChannelQueue;
    private IJsonMapper mapper;
    private List<MQConsumer<?>> consumerList;
    public ISubException subExceptionHander;

    private boolean isNullOrEmpty(String value) {
        return value == null || value == "";
    }

    public MQPool(String hostName, Integer port, String userName, String password, String virtualHost, Integer maxPushPool, Integer networkRecoveryInterval, String clientName, IJsonMapper mapper) throws Exception {
        if (this.isNullOrEmpty(hostName)) {
            throw new Exception("hostName is null!");
        }
        if (port == null) {
            port = 5672;
        }
        if (port <= 0 || 65535 <= port) {
            throw new Exception("port is error!");
        }
        if (this.isNullOrEmpty(userName)) {
            throw new Exception("userName is null!");
        }
        if (mapper == null) {
            throw new Exception("mapper is null!");
        }
        if (virtualHost == null) {
            virtualHost = "/";
        }
        if (maxPushPool == null || maxPushPool <= 0) {
            maxPushPool = 3;
        }
        if (networkRecoveryInterval == null || networkRecoveryInterval <= 0) {
            networkRecoveryInterval = 15;
        }
        if (this.isNullOrEmpty(clientName)) {
            clientName = "Afx.RabbitMQ";
        }
        this.clientName = clientName;
        this.maxPushPool = maxPushPool;
        this.mapper = mapper;
        this.pubChannelQueue = new LinkedList<Channel>();
        this.consumerList = new ArrayList();
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(hostName);
        this.connectionFactory.setPort(port.intValue());
        this.connectionFactory.setUsername(userName);
        this.connectionFactory.setPassword(password);
        this.connectionFactory.setVirtualHost(virtualHost);
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setNetworkRecoveryInterval(networkRecoveryInterval * 1000);
    }

    @Override
    public boolean isOpen() {
        return this.connection != null ? this.connection.isOpen() : false;
    }

    @Override
    public int getHeartbeat() {
        return this.connection != null ? this.connection.getHeartbeat() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        if (this.connection != null) {
            return this.connection;
        }
        Object object = this.lockCreate;
        synchronized (object) {
            if (this.connection == null) {
                this.connection = this.connectionFactory.newConnection(this.clientName);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getSubChannel() throws Exception {
        if (this.subChannel != null) {
            return this.subChannel;
        }
        Connection con = this.getConnection();
        Object object = this.lockCreate;
        synchronized (object) {
            if (this.subChannel == null) {
                this.subChannel = con.createChannel();
            }
        }
        return this.subChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishChannel getPubChannel() throws Exception {
        Channel ch = null;
        Object object = this.lockGetSubChannel;
        synchronized (object) {
            ch = this.pubChannelQueue.poll();
            if (ch == null) {
                Connection con = this.getConnection();
                ch = con.createChannel();
            }
        }
        return new PublishChannel(this, ch);
    }

    private <T> MapperDto serialize(T m) throws Exception {
        MapperDto result = new MapperDto();
        if (m instanceof byte[]) {
            byte[] arr = (byte[])m;
            result.contentType = "application/octet-stream";
            result.body = arr;
        } else if (m instanceof String) {
            String s = (String)m;
            result.contentType = "text/plain";
            result.body = s.getBytes("utf-8");
        } else {
            result.contentType = "application/json";
            String json = this.mapper.serialize(m);
            result.body = json.getBytes("utf-8");
        }
        return result;
    }

    private <T> T deserialize(byte[] buffer, Class<T> clazz) throws Exception {
        Class<byte[]> t = byte[].class;
        if (t == clazz) {
            byte[] o = buffer;
            return (T)o;
        }
        if (String.class == clazz) {
            String o = new String(buffer, "utf-8");
            return (T)o;
        }
        String json = new String(buffer, "utf-8");
        T m = this.mapper.deserialize(json, clazz);
        return m;
    }

    @Override
    public void exchangeDeclare(String exchange, String type, Boolean durable, Boolean autoDelete, Map<String, Object> arguments) throws Exception {
        if (this.isNullOrEmpty(exchange)) {
            exchange = "amq.direct";
        }
        if (this.isNullOrEmpty(type)) {
            type = "direct";
        }
        if (durable == null) {
            durable = true;
        }
        if (autoDelete == null) {
            autoDelete = false;
        }
        try (PublishChannel ph = this.getPubChannel();){
            ph.Channel.exchangeDeclare(exchange, type, durable.booleanValue(), autoDelete.booleanValue(), arguments);
        }
    }

    @Override
    public void exchangeDeclare(ExchangeConfig config) throws Exception {
        if (config == null) {
            throw new Exception("config is null!");
        }
        this.exchangeDeclare(config.Exchange, config.Type, config.Durable, config.AutoDelete, config.Arguments);
    }

    @Override
    public void exchangeDeclare(List<ExchangeConfig> configs) throws Exception {
        if (configs == null) {
            throw new Exception("configs is null!");
        }
        try (PublishChannel ph = this.getPubChannel();){
            for (ExchangeConfig item : configs) {
                ph.Channel.exchangeDeclare(item.Exchange, item.Type, item.Durable, item.AutoDelete, item.Arguments);
            }
        }
    }

    @Override
    public void queueDeclare(QueueConfig config) throws Exception {
        if (config == null) {
            throw new Exception("config is null!");
        }
        if (this.isNullOrEmpty(config.Queue)) {
            throw new Exception("config.Queue is null!");
        }
        if (this.isNullOrEmpty(config.Exchange)) {
            throw new Exception("config.Exchange is null!");
        }
        try (PublishChannel ph = this.getPubChannel();){
            ph.Channel.queueDeclare(config.Queue, config.Durable, config.Exclusive, config.AutoDelete, config.QueueArguments);
            if (config.RoutingKey == null) {
                config.RoutingKey = "";
            }
            ph.Channel.queueBind(config.Queue, config.Exchange, config.RoutingKey, config.BindArguments);
            if (!this.isNullOrEmpty(config.DelayQueue) && config.Queue != config.DelayQueue && (config.RoutingKey != config.DelayRoutingKey || this.isNullOrEmpty(config.DelayRoutingKey) && this.isNullOrEmpty(config.RoutingKey))) {
                HashMap<String, String> dic = new HashMap<String, String>(2);
                dic.put("x-dead-letter-exchange", config.Exchange);
                dic.put("x-dead-letter-routing-key", config.RoutingKey);
                ph.Channel.queueDeclare(config.DelayQueue, config.Durable, config.Exclusive, config.AutoDelete, dic);
                if (config.DelayRoutingKey == null) {
                    config.DelayRoutingKey = "";
                }
                ph.Channel.queueBind(config.DelayQueue, config.Exchange, config.DelayRoutingKey, null);
            }
        }
    }

    @Override
    public void queueDeclare(List<QueueConfig> queues) throws Exception {
        if (queues == null) {
            throw new Exception("queues is null!");
        }
        for (QueueConfig item : queues) {
            if (item == null) {
                throw new Exception("queues.item is null!");
            }
            if (this.isNullOrEmpty(item.Queue)) {
                throw new Exception("queues item.Queue is null!");
            }
            if (!this.isNullOrEmpty(item.Exchange)) continue;
            throw new Exception("queues item.Exchange is null!");
        }
        try (PublishChannel ph = this.getPubChannel();){
            for (QueueConfig config : queues) {
                ph.Channel.queueDeclare(config.Queue, config.Durable, config.Exclusive, config.AutoDelete, config.QueueArguments);
                if (config.RoutingKey == null) {
                    config.RoutingKey = "";
                }
                ph.Channel.queueBind(config.Queue, config.Exchange, config.RoutingKey, config.BindArguments);
                if (this.isNullOrEmpty(config.DelayQueue) || config.Queue == config.DelayQueue || config.RoutingKey == config.DelayRoutingKey && (!this.isNullOrEmpty(config.DelayRoutingKey) || !this.isNullOrEmpty(config.RoutingKey))) continue;
                HashMap<String, String> dic = new HashMap<String, String>(2);
                dic.put("x-dead-letter-exchange", config.Exchange);
                dic.put("x-dead-letter-routing-key", config.RoutingKey);
                ph.Channel.queueDeclare(config.DelayQueue, config.Durable, config.Exclusive, config.AutoDelete, dic);
                if (config.DelayRoutingKey == null) {
                    config.DelayRoutingKey = "";
                }
                ph.Channel.queueBind(config.DelayQueue, config.Exchange, config.DelayRoutingKey, null);
            }
        }
    }

    @Override
    public <T> boolean pub(T msg, String routingKey, Integer expire, String exchange, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (msg == null) {
            throw new Exception("msg is null!");
        }
        if (this.isNullOrEmpty(exchange)) {
            exchange = "amq.direct";
        }
        if (expire != null && expire < 1) {
            throw new Exception("expire(" + expire + ") is error!");
        }
        if (persistent == null) {
            persistent = false;
        }
        MapperDto mapper = this.serialize(msg);
        try (PublishChannel ph = this.getPubChannel();){
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            builder.contentType(mapper.contentType);
            builder.contentEncoding(mapper.contentEncoding);
            builder.deliveryMode(Integer.valueOf(persistent != false ? 2 : 1));
            if (expire != null) {
                builder.expiration(Integer.toString(expire * 1000));
            }
            if (headers != null) {
                builder.headers(headers);
            }
            if (routingKey == null) {
                routingKey = "";
            }
            AMQP.BasicProperties props = builder.build();
            ph.Channel.basicPublish(exchange, routingKey, props, mapper.body);
        }
        return true;
    }

    @Override
    public <T> boolean pub(T msg, PubMsgConfig config, Integer expire, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (config == null) {
            throw new Exception("config is null!");
        }
        return this.pub(msg, config.RoutingKey, expire, config.Exchange, persistent, headers);
    }

    @Override
    public <T> boolean pub(List<T> msgList, String routingKey, Integer expire, String exchange, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (msgList == null) {
            throw new Exception("msgList is null!");
        }
        if (msgList.size() == 0) {
            return true;
        }
        if (this.isNullOrEmpty(exchange)) {
            exchange = "amq.direct";
        }
        if (expire != null && expire < 1) {
            throw new Exception("expire(" + expire + ") is error!");
        }
        if (persistent == null) {
            persistent = false;
        }
        try (PublishChannel ph = this.getPubChannel();){
            for (T msg : msgList) {
                MapperDto mapper = this.serialize(msg);
                AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
                builder.contentType(mapper.contentType);
                builder.contentEncoding(mapper.contentEncoding);
                builder.deliveryMode(Integer.valueOf(persistent != false ? 2 : 1));
                if (expire != null) {
                    builder.expiration(Integer.toString(expire * 1000));
                }
                if (headers != null) {
                    builder.headers(headers);
                }
                if (routingKey == null) {
                    routingKey = "";
                }
                AMQP.BasicProperties props = builder.build();
                ph.Channel.basicPublish(exchange, routingKey, props, mapper.body);
            }
        }
        return true;
    }

    @Override
    public <T> boolean pub(List<T> msgList, PubMsgConfig config, Integer expire, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (config == null) {
            throw new Exception("config is null!");
        }
        return this.pub(msgList, config.RoutingKey, expire, config.Exchange, persistent, headers);
    }

    @Override
    public <T> boolean pubDelay(T msg, String delayRoutingKey, Integer delay, String exchange, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (delay == null || delay < 1) {
            throw new Exception("delay is error!");
        }
        return this.pub(msg, delayRoutingKey, delay, exchange, persistent, headers);
    }

    @Override
    public <T> boolean pubDelay(T msg, PubMsgConfig config, Integer delay, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (config == null) {
            throw new Exception("config is null!");
        }
        return this.pub(msg, config.DelayRoutingKey, delay, config.Exchange, persistent, headers);
    }

    @Override
    public <T> boolean pubDelay(List<T> msgList, String delayRoutingKey, Integer delay, String exchange, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (msgList == null) {
            throw new Exception("msgList is null!");
        }
        if (msgList.size() == 0) {
            return true;
        }
        if (delay == null || delay < 1) {
            throw new Exception("delay is error!");
        }
        return this.pub(msgList, delayRoutingKey, delay, exchange, persistent, headers);
    }

    @Override
    public <T> boolean pubDelay(List<T> msgList, PubMsgConfig config, Integer delay, Boolean persistent, Map<String, Object> headers) throws Exception {
        if (msgList == null) {
            throw new Exception("msgList is null!");
        }
        if (msgList.size() == 0) {
            return true;
        }
        if (config == null) {
            throw new Exception("config is null!");
        }
        if (delay == null || delay < 1) {
            throw new Exception("delay is error!");
        }
        return this.pub(msgList, config, delay, persistent, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void sub(ISubHander<T> hander, Class<T> clazz, String queue, Boolean autoAck) throws Exception {
        if (hander == null) {
            throw new Exception("hander is null!");
        }
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (this.isNullOrEmpty(queue)) {
            throw new Exception("queue is null!");
        }
        Channel channel = this.getSubChannel();
        if (autoAck == null) {
            autoAck = false;
        }
        Object object = this.lockSubChannel;
        synchronized (object) {
            MQConsumer<T> consumer = new MQConsumer<T>(channel, this, hander, clazz, queue, autoAck, this.subExceptionHander);
            this.consumerList.add(consumer);
            channel.basicQos(0, 1, false);
            channel.basicConsume(queue, autoAck.booleanValue(), consumer);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.subChannel != null) {
            try {
                if (this.subChannel.isOpen()) {
                    this.subChannel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.subChannel = null;
        if (this.pubChannelQueue != null) {
            Channel ph = this.pubChannelQueue.poll();
            while (ph != null) {
                try {
                    if (!ph.isOpen()) continue;
                    ph.close();
                }
                catch (Exception exception) {}
            }
        }
        this.pubChannelQueue = null;
        if (this.connection != null) {
            try {
                if (this.connection.isOpen()) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.consumerList != null) {
            for (MQConsumer<?> c : this.consumerList) {
                c.close();
            }
        }
        this.consumerList = null;
    }

    private class PublishChannel
    implements AutoCloseable {
        private MQPool pool;
        public Channel Channel;

        public PublishChannel(MQPool pool, Channel channel) {
            this.pool = pool;
            this.Channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            if (this.Channel != null && this.pool != null && this.pool.pubChannelQueue != null) {
                if (this.pool.maxPushPool > this.pool.pubChannelQueue.size()) {
                    Object object = this.pool.lockGetSubChannel;
                    synchronized (object) {
                        this.pool.pubChannelQueue.add(this.Channel);
                    }
                } else {
                    this.Channel.close();
                }
            }
            this.pool = null;
            this.Channel = null;
        }
    }

    private class MQConsumer<T>
    extends DefaultConsumer
    implements AutoCloseable {
        private MQPool pool;
        private ISubHander<T> subHander;
        private Class<T> clazz;
        private String queue;
        private Boolean autoAck;
        private ISubException exHander;

        public MQConsumer(Channel channel, MQPool pool, ISubHander<T> subHander, Class<T> clazz, String queue, Boolean autoAck, ISubException exHander) {
            super(channel);
            this.pool = pool;
            this.subHander = subHander;
            this.clazz = clazz;
            this.queue = queue;
            this.autoAck = autoAck;
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            boolean handerOk = false;
            try {
                T m = this.pool.deserialize(body, this.clazz);
                handerOk = m != null ? this.subHander.hander(m, (BasicProperties)properties) : true;
            }
            catch (Exception ex) {
                try {
                    this.exHander.hander(this.queue, ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.autoAck.booleanValue()) {
                if (handerOk) {
                    this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                } else {
                    this.getChannel().basicNack(envelope.getDeliveryTag(), false, true);
                }
            }
        }

        @Override
        public void close() throws Exception {
            this.pool = null;
            this.subHander = null;
            this.clazz = null;
            this.queue = null;
        }
    }
}

