/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.rabbitmq;

import cn.myafx.rabbitmq.ExchangeConfig;
import cn.myafx.rabbitmq.IMQConfig;
import cn.myafx.rabbitmq.PubMsgConfig;
import cn.myafx.rabbitmq.QueueConfig;
import cn.myafx.rabbitmq.SubMsgConfig;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MQConfig
implements IMQConfig {
    private Map<String, ExchangeConfig> exchangeMap;
    private Map<String, QueueConfig> queueMap;
    private Map<String, PubMsgConfig> pubMsgMap;
    private Map<String, SubMsgConfig> subMsgMap;

    private boolean isNullOrEmpty(String value) {
        return value == null || value == "";
    }

    public MQConfig(String xmlFile) throws Exception {
        if (this.isNullOrEmpty(xmlFile)) {
            throw new Exception("xmlFile is null!");
        }
        File f = new File(xmlFile);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("xmlFile(" + xmlFile + ") not found!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(f);
        this.load(doc);
    }

    public MQConfig(InputStream stream) throws Exception {
        this.load(stream);
    }

    public MQConfig(URL url) throws Exception {
        if (url == null) {
            throw new Exception("url is null!");
        }
        try (InputStream stream = url.openStream();){
            this.load(stream);
        }
    }

    private void load(InputStream stream) throws Exception {
        if (stream == null) {
            throw new Exception("stream is null!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(stream);
        this.load(doc);
    }

    private void load(Document doc) throws Exception {
        Element rootElement = doc.getDocumentElement();
        NodeList nodes = rootElement.getChildNodes();
        block12: for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element node = (Element)n;
            switch (node.getNodeName()) {
                case "Exchange": {
                    this.loadExchange(node);
                    continue block12;
                }
                case "Queue": {
                    this.loadQueue(node);
                    continue block12;
                }
                case "PubMsg": {
                    this.loadPubMsg(node);
                    continue block12;
                }
                case "SubMsg": {
                    this.loadSubMsg(node);
                }
            }
        }
    }

    private void loadExchange(Element rootElement) throws Exception {
        NodeList nodes = rootElement.getChildNodes();
        this.exchangeMap = new HashMap<String, ExchangeConfig>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element item;
            Node in = nodes.item(i);
            if (!(in instanceof Element) || (item = (Element)in).getNodeName() != "Key") continue;
            String s = item.getAttribute("exchange");
            if (this.isNullOrEmpty(s)) {
                throw new Exception("Exchange config is null!");
            }
            if (this.exchangeMap.containsKey(s)) {
                throw new Exception("Exchange config (" + s + ") is repeat\uff01");
            }
            ExchangeConfig m = new ExchangeConfig();
            m.Exchange = s;
            s = item.getAttribute("type");
            if (!this.isNullOrEmpty(s)) {
                m.Type = s;
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("durable"))) {
                boolean bl = m.Durable = s.toLowerCase().equals("true") || s.equals("1");
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("autoDelete"))) {
                m.AutoDelete = s.toLowerCase().equals("true") || s.equals("1");
            }
            NodeList args = item.getChildNodes();
            for (int j = 0; j < args.getLength(); ++j) {
                Element rel;
                Node rnode = args.item(j);
                if (!(rnode instanceof Element) || (rel = (Element)rnode).getNodeName() != "Arguments") continue;
                String k = rel.getAttribute("key");
                String v = rel.getAttribute("value");
                if (this.isNullOrEmpty(k) || this.isNullOrEmpty(v)) continue;
                if (m.Arguments == null) {
                    m.Arguments = new HashMap<String, Object>(args.getLength());
                }
                if (m.Arguments.containsKey(k)) continue;
                m.Arguments.put(k, v);
            }
            this.exchangeMap.put(m.Exchange, m);
        }
    }

    private void loadQueue(Element rootElement) throws Exception {
        NodeList nodes = rootElement.getChildNodes();
        this.queueMap = new HashMap<String, QueueConfig>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element item;
            Node qn = nodes.item(i);
            if (!(qn instanceof Element) || (item = (Element)qn).getNodeName() != "Key") continue;
            String s = item.getAttribute("queue");
            if (this.isNullOrEmpty(s)) {
                throw new Exception("queue config is null!");
            }
            if (this.queueMap.containsKey(s)) {
                throw new Exception("queue config (" + s + ") is repeat!");
            }
            QueueConfig m = new QueueConfig();
            m.Queue = s;
            s = item.getAttribute("routingKey");
            if (!this.isNullOrEmpty(s)) {
                m.RoutingKey = s;
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("delayQueue"))) {
                m.DelayQueue = s;
                s = item.getAttribute("delayRoutingKey");
                if (!this.isNullOrEmpty(s)) {
                    m.DelayRoutingKey = s;
                }
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("durable"))) {
                boolean bl = m.Durable = s.toLowerCase().equals("true") || s.equals("1");
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("exclusive"))) {
                boolean bl = m.Exclusive = s.toLowerCase().equals("true") || s.equals("1");
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("autoDelete"))) {
                boolean bl = m.AutoDelete = s.toLowerCase().equals("true") || s.equals("1");
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("isQueueParam"))) {
                boolean bl = m.IsQueueParam = s.toLowerCase().equals("true") || s.equals("1");
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("isRoutingKeyParam"))) {
                m.IsRoutingKeyParam = s.toLowerCase().equals("true") || s.equals("1");
            }
            NodeList args = item.getChildNodes();
            for (int j = 0; j < args.getLength(); ++j) {
                Element rel;
                String n;
                Node an = args.item(j);
                if (!(an instanceof Element) || (n = (rel = (Element)an).getNodeName()) != "QueueArguments" && n != "BindArguments") continue;
                String k = rel.getAttribute("key");
                String v = rel.getAttribute("value");
                if (this.isNullOrEmpty(k) || this.isNullOrEmpty(v)) continue;
                if (n == "QueueArguments") {
                    if (m.QueueArguments == null) {
                        m.QueueArguments = new HashMap<String, Object>(args.getLength());
                    }
                    if (m.QueueArguments.containsKey(k)) continue;
                    m.QueueArguments.put(k, v);
                    continue;
                }
                if (m.BindArguments == null) {
                    m.BindArguments = new HashMap<String, Object>(args.getLength());
                }
                if (m.BindArguments.containsKey(k)) continue;
                m.BindArguments.put(k, v);
            }
            this.queueMap.put(m.Queue, m);
        }
    }

    private void loadPubMsg(Element rootElement) throws Exception {
        NodeList nodes = rootElement.getChildNodes();
        this.pubMsgMap = new HashMap<String, PubMsgConfig>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element item;
            Node in = nodes.item(i);
            if (!(in instanceof Element) || (item = (Element)in).getNodeName() != "Key") continue;
            String s = item.getAttribute("name");
            if (this.isNullOrEmpty(s)) {
                throw new Exception("PubMsg name config is null!");
            }
            if (this.pubMsgMap.containsKey(s)) {
                throw new Exception("PubMsg name (" + s + ") is repeat\uff01");
            }
            PubMsgConfig m = new PubMsgConfig();
            m.Name = s;
            s = item.getAttribute("routingKey");
            if (!this.isNullOrEmpty(s)) {
                m.RoutingKey = s;
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("delayRoutingKey"))) {
                m.DelayRoutingKey = s;
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("exchange"))) {
                m.Exchange = s;
            }
            if (!this.isNullOrEmpty(s = item.getAttribute("isRoutingKeyParam"))) {
                m.IsRoutingKeyParam = s.toLowerCase().equals("true") || s.equals("1");
            }
            this.pubMsgMap.put(m.Name, m);
        }
    }

    private void loadSubMsg(Element rootElement) throws Exception {
        NodeList nodes = rootElement.getChildNodes();
        this.subMsgMap = new HashMap<String, SubMsgConfig>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element item;
            Node in = nodes.item(i);
            if (!(in instanceof Element) || (item = (Element)in).getNodeName() != "Key") continue;
            String s = item.getAttribute("name");
            if (this.isNullOrEmpty(s)) {
                throw new Exception("SubMsg name config is null!");
            }
            if (this.subMsgMap.containsKey(s)) {
                throw new Exception("SubMsg name (" + s + ") is repeat!");
            }
            SubMsgConfig m = new SubMsgConfig();
            m.Name = s;
            s = item.getAttribute("queue");
            if (this.isNullOrEmpty(s)) {
                throw new Exception("SubMsg queue config is null!");
            }
            m.Queue = s;
            s = item.getAttribute("isQueueParam");
            if (!this.isNullOrEmpty(s)) {
                m.IsQueueParam = s.toLowerCase().equals("true") || s.equals("1");
            }
            this.subMsgMap.put(m.Name, m);
        }
    }

    @Override
    public List<ExchangeConfig> getExchanges() {
        if (this.exchangeMap == null) {
            return null;
        }
        ArrayList<ExchangeConfig> list = new ArrayList<ExchangeConfig>(this.exchangeMap.size());
        this.exchangeMap.forEach((k, v) -> list.add((ExchangeConfig)v));
        return list;
    }

    @Override
    public List<QueueConfig> getQueues() {
        if (this.queueMap == null) {
            return null;
        }
        ArrayList<QueueConfig> list = new ArrayList<QueueConfig>(this.queueMap.size());
        this.queueMap.forEach((k, v) -> list.add((QueueConfig)v));
        return list;
    }

    @Override
    public PubMsgConfig getPubConfig(String name) {
        if (this.pubMsgMap == null) {
            return null;
        }
        return this.pubMsgMap.get(name);
    }

    @Override
    public SubMsgConfig getSubConfig(String name) {
        if (this.subMsgMap == null) {
            return null;
        }
        return this.subMsgMap.get(name);
    }

    @Override
    public void close() throws Exception {
        this.exchangeMap = null;
        this.queueMap = null;
        this.pubMsgMap = null;
        this.subMsgMap = null;
    }
}

