/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.ArrayTypeHandler;
import cn.myafx.data.type.BigDecimalTypeHandler;
import cn.myafx.data.type.BigIntegerTypeHandler;
import cn.myafx.data.type.BlobByteObjectArrayTypeHandler;
import cn.myafx.data.type.BlobInputStreamTypeHandler;
import cn.myafx.data.type.BlobTypeHandler;
import cn.myafx.data.type.BooleanTypeHandler;
import cn.myafx.data.type.ByteArrayTypeHandler;
import cn.myafx.data.type.ByteObjectArrayTypeHandler;
import cn.myafx.data.type.ByteTypeHandler;
import cn.myafx.data.type.CharacterTypeHandler;
import cn.myafx.data.type.ClobReaderTypeHandler;
import cn.myafx.data.type.ClobTypeHandler;
import cn.myafx.data.type.DateOnlyTypeHandler;
import cn.myafx.data.type.DateTypeHandler;
import cn.myafx.data.type.DoubleTypeHandler;
import cn.myafx.data.type.EnumTypeHandler;
import cn.myafx.data.type.FloatTypeHandler;
import cn.myafx.data.type.InstantTypeHandler;
import cn.myafx.data.type.IntegerTypeHandler;
import cn.myafx.data.type.JapaneseDateTypeHandler;
import cn.myafx.data.type.JdbcType;
import cn.myafx.data.type.LocalDateTimeTypeHandler;
import cn.myafx.data.type.LocalDateTypeHandler;
import cn.myafx.data.type.LocalTimeTypeHandler;
import cn.myafx.data.type.LongTypeHandler;
import cn.myafx.data.type.MappedJdbcTypes;
import cn.myafx.data.type.MappedTypes;
import cn.myafx.data.type.MonthTypeHandler;
import cn.myafx.data.type.NClobTypeHandler;
import cn.myafx.data.type.NStringTypeHandler;
import cn.myafx.data.type.OffsetDateTimeTypeHandler;
import cn.myafx.data.type.OffsetTimeTypeHandler;
import cn.myafx.data.type.ShortTypeHandler;
import cn.myafx.data.type.SqlDateTypeHandler;
import cn.myafx.data.type.SqlTimeTypeHandler;
import cn.myafx.data.type.SqlTimestampTypeHandler;
import cn.myafx.data.type.SqlxmlTypeHandler;
import cn.myafx.data.type.StringTypeHandler;
import cn.myafx.data.type.TimeOnlyTypeHandler;
import cn.myafx.data.type.TypeException;
import cn.myafx.data.type.TypeHandler;
import cn.myafx.data.type.TypeReference;
import cn.myafx.data.type.YearMonthTypeHandler;
import cn.myafx.data.type.YearTypeHandler;
import cn.myafx.data.type.ZonedDateTimeTypeHandler;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeHandlerRegistry {
    private final Map<JdbcType, TypeHandler<?>> jdbcTypeHandlerMap = new EnumMap(JdbcType.class);
    private final Map<Type, Map<JdbcType, TypeHandler<?>>> typeHandlerMap = new ConcurrentHashMap();
    private final Map<Class<?>, TypeHandler<?>> allTypeHandlersMap = new HashMap();
    private static final Map<JdbcType, TypeHandler<?>> NULL_TYPE_HANDLER_MAP = Collections.emptyMap();
    private Class<?> defaultEnumTypeHandler = EnumTypeHandler.class;

    public TypeHandlerRegistry() {
        this.register(Boolean.class, new BooleanTypeHandler());
        this.register(Boolean.TYPE, new BooleanTypeHandler());
        this.register(JdbcType.BOOLEAN, new BooleanTypeHandler());
        this.register(JdbcType.BIT, new BooleanTypeHandler());
        this.register(Byte.class, new ByteTypeHandler());
        this.register(Byte.TYPE, new ByteTypeHandler());
        this.register(JdbcType.TINYINT, new ByteTypeHandler());
        this.register(Short.class, new ShortTypeHandler());
        this.register(Short.TYPE, new ShortTypeHandler());
        this.register(JdbcType.SMALLINT, new ShortTypeHandler());
        this.register(Integer.class, new IntegerTypeHandler());
        this.register(Integer.TYPE, new IntegerTypeHandler());
        this.register(JdbcType.INTEGER, new IntegerTypeHandler());
        this.register(Long.class, new LongTypeHandler());
        this.register(Long.TYPE, new LongTypeHandler());
        this.register(Float.class, new FloatTypeHandler());
        this.register(Float.TYPE, new FloatTypeHandler());
        this.register(JdbcType.FLOAT, new FloatTypeHandler());
        this.register(Double.class, new DoubleTypeHandler());
        this.register(Double.TYPE, new DoubleTypeHandler());
        this.register(JdbcType.DOUBLE, new DoubleTypeHandler());
        this.register(Reader.class, new ClobReaderTypeHandler());
        this.register(String.class, new StringTypeHandler());
        this.register(String.class, JdbcType.CHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.CLOB, new ClobTypeHandler());
        this.register(String.class, JdbcType.VARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.LONGVARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCLOB, new NClobTypeHandler());
        this.register(JdbcType.CHAR, new StringTypeHandler());
        this.register(JdbcType.VARCHAR, new StringTypeHandler());
        this.register(JdbcType.CLOB, new ClobTypeHandler());
        this.register(JdbcType.LONGVARCHAR, new StringTypeHandler());
        this.register(JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(JdbcType.NCHAR, new NStringTypeHandler());
        this.register(JdbcType.NCLOB, new NClobTypeHandler());
        this.register(Object.class, JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(BigInteger.class, new BigIntegerTypeHandler());
        this.register(JdbcType.BIGINT, new LongTypeHandler());
        this.register(BigDecimal.class, new BigDecimalTypeHandler());
        this.register(JdbcType.REAL, new BigDecimalTypeHandler());
        this.register(JdbcType.DECIMAL, new BigDecimalTypeHandler());
        this.register(JdbcType.NUMERIC, new BigDecimalTypeHandler());
        this.register(InputStream.class, new BlobInputStreamTypeHandler());
        this.register(Byte[].class, new ByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.BLOB, new BlobByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.LONGVARBINARY, new BlobByteObjectArrayTypeHandler());
        this.register(byte[].class, new ByteArrayTypeHandler());
        this.register(byte[].class, JdbcType.BLOB, new BlobTypeHandler());
        this.register(byte[].class, JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.BLOB, new BlobTypeHandler());
        this.register(java.util.Date.class, new DateTypeHandler());
        this.register(java.util.Date.class, JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(java.util.Date.class, JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(JdbcType.TIMESTAMP, new DateTypeHandler());
        this.register(JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(Date.class, new SqlDateTypeHandler());
        this.register(Time.class, new SqlTimeTypeHandler());
        this.register(Timestamp.class, new SqlTimestampTypeHandler());
        this.register(String.class, JdbcType.SQLXML, new SqlxmlTypeHandler());
        this.register(Instant.class, new InstantTypeHandler());
        this.register(LocalDateTime.class, new LocalDateTimeTypeHandler());
        this.register(LocalDate.class, new LocalDateTypeHandler());
        this.register(LocalTime.class, new LocalTimeTypeHandler());
        this.register(OffsetDateTime.class, new OffsetDateTimeTypeHandler());
        this.register(OffsetTime.class, new OffsetTimeTypeHandler());
        this.register(ZonedDateTime.class, new ZonedDateTimeTypeHandler());
        this.register(Month.class, new MonthTypeHandler());
        this.register(Year.class, new YearTypeHandler());
        this.register(YearMonth.class, new YearMonthTypeHandler());
        this.register(JapaneseDate.class, new JapaneseDateTypeHandler());
        this.register(Character.class, new CharacterTypeHandler());
        this.register(Character.TYPE, new CharacterTypeHandler());
    }

    public void setDefaultEnumTypeHandler(Class<?> typeHandler) {
        this.defaultEnumTypeHandler = typeHandler;
    }

    public boolean hasTypeHandler(Class<?> javaType) throws TypeException {
        return this.hasTypeHandler(javaType, null);
    }

    public boolean hasTypeHandler(TypeReference<?> javaTypeReference) throws TypeException {
        return this.hasTypeHandler(javaTypeReference, null);
    }

    public boolean hasTypeHandler(Class<?> javaType, JdbcType jdbcType) throws TypeException {
        return javaType != null && this.getTypeHandler((Type)javaType, jdbcType) != null;
    }

    public boolean hasTypeHandler(TypeReference<?> javaTypeReference, JdbcType jdbcType) throws TypeException {
        return javaTypeReference != null && this.getTypeHandler(javaTypeReference, jdbcType) != null;
    }

    public TypeHandler<?> getMappingTypeHandler(Class<? extends TypeHandler<?>> handlerType) {
        return this.allTypeHandlersMap.get(handlerType);
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type) throws TypeException {
        return this.getTypeHandler((Type)type, null);
    }

    public <T> TypeHandler<T> getTypeHandler(TypeReference<T> javaTypeReference) throws TypeException {
        return this.getTypeHandler(javaTypeReference, null);
    }

    public TypeHandler<?> getTypeHandler(JdbcType jdbcType) {
        return this.jdbcTypeHandlerMap.get((Object)jdbcType);
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type, JdbcType jdbcType) throws TypeException {
        return this.getTypeHandler((Type)type, jdbcType);
    }

    public <T> TypeHandler<T> getTypeHandler(TypeReference<T> javaTypeReference, JdbcType jdbcType) throws TypeException {
        return this.getTypeHandler(javaTypeReference.getRawType(), jdbcType);
    }

    private <T> TypeHandler<T> getTypeHandler(Type type, JdbcType jdbcType) throws TypeException {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.getJdbcHandlerMap(type);
        TypeHandler<?> handler = null;
        if (jdbcHandlerMap != null) {
            handler = jdbcHandlerMap.get((Object)jdbcType);
            if (handler == null) {
                handler = jdbcHandlerMap.get(null);
            }
            if (handler == null) {
                handler = this.pickSoleHandler(jdbcHandlerMap);
            }
        }
        return handler;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMap(Type type) throws TypeException {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(type);
        if (jdbcHandlerMap != null) {
            return NULL_TYPE_HANDLER_MAP.equals(jdbcHandlerMap) ? null : jdbcHandlerMap;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (Enum.class.isAssignableFrom(clazz)) {
                Class enumClass = clazz.isAnonymousClass() ? clazz.getSuperclass() : clazz;
                jdbcHandlerMap = this.getJdbcHandlerMapForEnumInterfaces(enumClass, enumClass);
                if (jdbcHandlerMap == null) {
                    this.register(enumClass, this.getInstance(enumClass, this.defaultEnumTypeHandler));
                    return this.typeHandlerMap.get(enumClass);
                }
            } else {
                jdbcHandlerMap = this.getJdbcHandlerMapForSuperclass(clazz);
            }
        }
        this.typeHandlerMap.put(type, jdbcHandlerMap == null ? NULL_TYPE_HANDLER_MAP : jdbcHandlerMap);
        return jdbcHandlerMap;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMapForEnumInterfaces(Class<?> clazz, Class<?> enumClazz) throws TypeException {
        for (Class<?> iface : clazz.getInterfaces()) {
            Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(iface);
            if (jdbcHandlerMap == null) {
                jdbcHandlerMap = this.getJdbcHandlerMapForEnumInterfaces(iface, enumClazz);
            }
            if (jdbcHandlerMap == null) continue;
            HashMap newMap = new HashMap();
            for (Map.Entry<JdbcType, TypeHandler<?>> entry : jdbcHandlerMap.entrySet()) {
                newMap.put(entry.getKey(), this.getInstance(enumClazz, entry.getValue().getClass()));
            }
            return newMap;
        }
        return null;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMapForSuperclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || Object.class.equals(superclass)) {
            return null;
        }
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(superclass);
        if (jdbcHandlerMap != null) {
            return jdbcHandlerMap;
        }
        return this.getJdbcHandlerMapForSuperclass(superclass);
    }

    private TypeHandler<?> pickSoleHandler(Map<JdbcType, TypeHandler<?>> jdbcHandlerMap) {
        TypeHandler<?> soleHandler = null;
        for (TypeHandler<?> handler : jdbcHandlerMap.values()) {
            if (soleHandler == null) {
                soleHandler = handler;
                continue;
            }
            if (handler.getClass().equals(soleHandler.getClass())) continue;
            return null;
        }
        return soleHandler;
    }

    public void register(JdbcType jdbcType, TypeHandler<?> handler) {
        this.jdbcTypeHandlerMap.put(jdbcType, handler);
    }

    public <T> void register(TypeHandler<T> typeHandler) {
        boolean mappedTypeFound = false;
        MappedTypes mappedTypes = typeHandler.getClass().getAnnotation(MappedTypes.class);
        if (mappedTypes != null) {
            for (Class<?> handledType : mappedTypes.value()) {
                this.register((Type)handledType, (TypeHandler<? extends T>)typeHandler);
                mappedTypeFound = true;
            }
        }
        if (!mappedTypeFound && typeHandler instanceof TypeReference) {
            try {
                TypeReference typeReference = (TypeReference)((Object)typeHandler);
                this.register(typeReference.getRawType(), typeHandler);
                mappedTypeFound = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!mappedTypeFound) {
            this.register((Class)null, typeHandler);
        }
    }

    public <T> void register(Class<T> javaType, TypeHandler<? extends T> typeHandler) {
        this.register((Type)javaType, typeHandler);
    }

    private <T> void register(Type javaType, TypeHandler<? extends T> typeHandler) {
        MappedJdbcTypes mappedJdbcTypes = typeHandler.getClass().getAnnotation(MappedJdbcTypes.class);
        if (mappedJdbcTypes != null) {
            for (JdbcType handledJdbcType : mappedJdbcTypes.value()) {
                this.register(javaType, handledJdbcType, typeHandler);
            }
            if (mappedJdbcTypes.includeNullJdbcType()) {
                this.register(javaType, null, typeHandler);
            }
        } else {
            this.register(javaType, null, typeHandler);
        }
    }

    public <T> void register(TypeReference<T> javaTypeReference, TypeHandler<? extends T> handler) {
        this.register(javaTypeReference.getRawType(), handler);
    }

    public <T> void register(Class<T> type, JdbcType jdbcType, TypeHandler<? extends T> handler) {
        this.register((Type)type, jdbcType, (TypeHandler<?>)handler);
    }

    private void register(Type javaType, JdbcType jdbcType, TypeHandler<?> handler) {
        if (javaType != null) {
            Map<JdbcType, TypeHandler<?>> map = this.typeHandlerMap.get(javaType);
            if (map == null || map == NULL_TYPE_HANDLER_MAP) {
                map = new HashMap();
            }
            map.put(jdbcType, handler);
            this.typeHandlerMap.put(javaType, map);
        }
        this.allTypeHandlersMap.put(handler.getClass(), handler);
    }

    public void register(Class<?> typeHandlerClass) throws TypeException {
        boolean mappedTypeFound = false;
        MappedTypes mappedTypes = typeHandlerClass.getAnnotation(MappedTypes.class);
        if (mappedTypes != null) {
            for (Class<?> javaTypeClass : mappedTypes.value()) {
                this.register(javaTypeClass, typeHandlerClass);
                mappedTypeFound = true;
            }
        }
        if (!mappedTypeFound) {
            this.register(this.getInstance(null, typeHandlerClass));
        }
    }

    public void register(String javaTypeClassName, String typeHandlerClassName) throws Exception {
        this.register(Class.forName(javaTypeClassName), Class.forName(typeHandlerClassName));
    }

    public void register(Class<?> javaTypeClass, Class<?> typeHandlerClass) throws TypeException {
        this.register(javaTypeClass, this.getInstance(javaTypeClass, typeHandlerClass));
    }

    public void register(Class<?> javaTypeClass, JdbcType jdbcType, Class<?> typeHandlerClass) throws TypeException {
        this.register(javaTypeClass, jdbcType, this.getInstance(javaTypeClass, typeHandlerClass));
    }

    public <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) throws TypeException {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, e);
        }
    }

    public Collection<TypeHandler<?>> getTypeHandlers() {
        return Collections.unmodifiableCollection(this.allTypeHandlersMap.values());
    }
}

