/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.BaseTypeHandler;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.JapaneseDate;

public class JapaneseDateTypeHandler
extends BaseTypeHandler<JapaneseDate> {
    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 91);
        } else {
            ps.setDate(i, Date.valueOf(LocalDate.ofEpochDay(((JapaneseDate)parameter).toEpochDay())));
        }
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Date date = rs.getDate(columnName);
        return JapaneseDateTypeHandler.getJapaneseDate(date);
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Date date = rs.getDate(columnIndex);
        return JapaneseDateTypeHandler.getJapaneseDate(date);
    }

    @Override
    public JapaneseDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Date date = cs.getDate(columnIndex);
        return JapaneseDateTypeHandler.getJapaneseDate(date);
    }

    private static JapaneseDate getJapaneseDate(Date date) {
        if (date != null) {
            return JapaneseDate.from(date.toLocalDate());
        }
        return null;
    }
}

