/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.BaseTypeHandler;
import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobTypeHandler
extends BaseTypeHandler<String> {
    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 2005);
        } else {
            String v = (String)parameter;
            StringReader reader = new StringReader(v);
            ps.setCharacterStream(i, (Reader)reader, v.length());
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Clob clob = rs.getClob(columnName);
        return this.toString(clob);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        return this.toString(clob);
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Clob clob = cs.getClob(columnIndex);
        return this.toString(clob);
    }

    private String toString(Clob clob) throws SQLException {
        return clob == null ? null : clob.getSubString(1L, (int)clob.length());
    }
}

