/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data.type;

import cn.myafx.data.type.BaseTypeHandler;
import cn.myafx.data.type.ByteArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobByteObjectArrayTypeHandler
extends BaseTypeHandler<Byte[]> {
    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 2004);
        } else {
            Byte[] v = (Byte[])parameter;
            ByteArrayInputStream bis = new ByteArrayInputStream(ByteArrayUtils.convertToPrimitiveArray(v));
            ps.setBinaryStream(i, (InputStream)bis, v.length);
        }
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Blob blob = cs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    private Byte[] getBytes(Blob blob) throws SQLException {
        Byte[] returnValue = null;
        if (blob != null) {
            returnValue = ByteArrayUtils.convertToObjectArray(blob.getBytes(1L, (int)blob.length()));
        }
        return returnValue;
    }
}

