/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data;

import cn.myafx.data.IsolationLevel;
import cn.myafx.data.Model;
import java.util.List;
import java.util.Map;

public interface IDatabase
extends AutoCloseable {
    public boolean isClose();

    public boolean isTransaction();

    public void open() throws Exception;

    public void beginTransaction() throws Exception;

    public void beginTransaction(IsolationLevel var1) throws Exception;

    public void commit() throws Exception;

    public void rollback() throws Exception;

    public int execute(String var1, Object ... var2) throws Exception;

    public <T> T queryOne(String var1, Class<T> var2, Object ... var3) throws Exception;

    public <T> List<T> queryList(String var1, Class<T> var2, Object ... var3) throws Exception;

    public Map<String, Object> queryOneMap(String var1, Object ... var2) throws Exception;

    public List<Map<String, Object>> queryListMap(String var1, Object ... var2) throws Exception;

    public <TModel extends Model> TModel get(Class<TModel> var1, Map<String, Object> var2) throws Exception;

    public <TModel extends Model> List<TModel> getList(Class<TModel> var1, Map<String, Object> var2) throws Exception;

    public int add(String var1, Map<String, Object> var2) throws Exception;

    public <TModel extends Model> int add(TModel var1, String[] var2) throws Exception;

    public int update(String var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;

    public <TModel extends Model> int update(Class<TModel> var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;

    public int delete(String var1, Map<String, Object> var2) throws Exception;

    public <TModel extends Model> int delete(Class<TModel> var1, Map<String, Object> var2) throws Exception;
}

