/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.data;

import cn.myafx.data.IDatabase;
import cn.myafx.data.IsolationLevel;
import cn.myafx.data.Model;
import cn.myafx.data.SqlParamInfo;
import cn.myafx.data.factory.DefaultObjectFactory;
import cn.myafx.data.factory.ObjectFactory;
import cn.myafx.data.type.TypeHandler;
import cn.myafx.data.type.TypeHandlerRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Database
implements IDatabase {
    private Connection connection = null;
    private Boolean is_tran = false;
    private Boolean is_close = true;
    private static final int NOT_MODEL = 3096;
    private static final int CLASS_FIELD = 7;
    protected static final TypeHandlerRegistry typeHandlerRegistry = new TypeHandlerRegistry();
    private static final ObjectFactory objectFactory = new DefaultObjectFactory();
    private static final List<Class<?>> baseTypeList = new ArrayList(50);

    @Override
    public boolean isClose() {
        return this.is_close;
    }

    @Override
    public boolean isTransaction() {
        return this.is_tran;
    }

    protected abstract Connection getConnection() throws Exception;

    protected abstract String encodeColumn(String var1);

    @Override
    public void open() throws Exception {
        if (this.is_close.booleanValue()) {
            this.connection = this.getConnection();
            this.is_close = false;
        }
    }

    @Override
    public void beginTransaction() throws Exception {
        this.beginTransaction(IsolationLevel.None);
    }

    @Override
    public void beginTransaction(IsolationLevel level) throws Exception {
        if (this.is_tran.booleanValue()) {
            throw new Exception("repeat beginTransaction!");
        }
        this.open();
        if (this.connection == null) {
            throw new Exception("not open!");
        }
        this.connection.setAutoCommit(false);
        switch (level) {
            case ReadUncommitted: {
                this.connection.setTransactionIsolation(1);
                break;
            }
            case None: 
            case ReadCommitted: {
                this.connection.setTransactionIsolation(2);
                break;
            }
            case RepeatableRead: {
                this.connection.setTransactionIsolation(4);
                break;
            }
            case Serializable: {
                this.connection.setTransactionIsolation(8);
                break;
            }
        }
        this.is_tran = true;
    }

    @Override
    public void commit() throws Exception {
        if (this.is_tran.booleanValue()) {
            this.connection.commit();
            this.is_tran = false;
        }
    }

    @Override
    public void rollback() throws Exception {
        if (this.is_tran.booleanValue()) {
            this.connection.rollback();
            this.is_tran = false;
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.is_close.booleanValue()) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
            this.is_close = true;
        }
    }

    private Object getDefault(Class<?> clazz) {
        Comparable<Boolean> obj = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                obj = false;
            } else if (clazz == Character.TYPE) {
                obj = Character.valueOf('\u0000');
            } else if (clazz == Byte.TYPE) {
                obj = (byte)0;
            } else if (clazz == Short.TYPE) {
                obj = (short)0;
            } else if (clazz == Integer.TYPE) {
                obj = 0;
            } else if (clazz == Long.TYPE) {
                obj = 0L;
            } else if (clazz == Float.TYPE) {
                obj = Float.valueOf(0.0f);
            } else if (clazz == Double.TYPE) {
                obj = 0.0;
            }
        }
        return obj;
    }

    private void checkModel(Class<?> clazz) throws Exception {
        if (clazz == null) {
            throw new Exception("T class is null!");
        }
        if (baseTypeList.contains(clazz)) {
            return;
        }
        if (clazz.isArray() || clazz.isEnum() || clazz.isInterface() || clazz.isAnonymousClass() || clazz.isAnnotation() || (clazz.getModifiers() & 0xC18) > 0) {
            throw new Exception("T(" + clazz.getSimpleName() + ") class is error!");
        }
    }

    private Map<String, Field> getFieldMap(Class<?> clazz) throws Exception {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        Class<?> t = clazz;
        while (!Object.class.equals(t)) {
            Field[] arr;
            for (Field f : arr = t.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (modifiers != 0 && (modifiers & 7) <= 0) continue;
                fieldMap.put(f.getName(), f);
                if (Modifier.isPublic(modifiers)) continue;
                f.setAccessible(true);
            }
            t = t.getSuperclass();
        }
        if (fieldMap.size() == 0) {
            throw new Exception("clazz(" + clazz.getName() + ") is error!");
        }
        return fieldMap;
    }

    private void setValue(Object m, Map<String, Field> fieldMap, ResultSet resultSet, ResultSetMetaData metaData, Map<String, TypeHandler<?>> handerMap) throws Exception {
        int count = metaData.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = metaData.getColumnLabel(i + 1);
            if (!fieldMap.containsKey(name)) continue;
            Field field = fieldMap.get(name);
            Object value = null;
            TypeHandler<?> handler = null;
            if (handerMap.containsKey(name)) {
                handler = handerMap.get(name);
            } else {
                Class<?> ft = field.getType();
                handler = typeHandlerRegistry.getTypeHandler(ft);
                handerMap.put(name, handler);
            }
            if (handler != null) {
                value = handler.getResult(resultSet, i + 1);
            }
            if (value == null) continue;
            field.set(m, value);
        }
    }

    private <T> List<T> toListModel(ResultSet resultSet, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        boolean isBaseType = baseTypeList.contains(clazz);
        Map<String, Field> fieldMap = null;
        HashMap handerMap = null;
        ResultSetMetaData metaData = null;
        TypeHandler<T> handler = null;
        if (isBaseType) {
            handler = typeHandlerRegistry.getTypeHandler(clazz);
        } else {
            fieldMap = this.getFieldMap(clazz);
            handerMap = new HashMap();
            metaData = resultSet.getMetaData();
        }
        while (resultSet.next()) {
            T m;
            if (isBaseType) {
                m = handler.getResult(resultSet, 1);
                list.add(m);
                continue;
            }
            m = objectFactory.create(clazz);
            this.setValue(m, fieldMap, resultSet, metaData, handerMap);
            list.add(m);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlParamInfo getParamInfo(String sql, Object[] param) throws Exception {
        if (sql == null || sql.isEmpty()) {
            throw new Exception("sql is null!");
        }
        SqlParamInfo result = new SqlParamInfo();
        result.sql = sql;
        if (sql.indexOf(63) > 0) {
            result.param = param;
            return result;
        } else {
            String openToken = "${";
            String closeToken = "}";
            int start = sql.indexOf(openToken);
            if (start < 0) {
                openToken = "#{";
                start = sql.indexOf(openToken);
            }
            if (start <= 0) return result;
            if (param == null || param.length != 1) {
                throw new Exception("parameter is error!");
            }
            Object o = param[0];
            Integer paramtype = 0;
            Map map = null;
            Map<String, Field> fieldMap = null;
            if (o instanceof Map) {
                Map omap = (Map)o;
                map = omap;
                if (map != null && map.size() > 0) {
                    paramtype = 1;
                }
            } else {
                Class<?> t = o.getClass();
                fieldMap = this.getFieldMap(t);
                if (fieldMap.size() > 0) {
                    paramtype = 2;
                }
            }
            if (paramtype == 0) {
                throw new Exception("parameter type is error!");
            }
            StringBuilder builder = new StringBuilder();
            Integer appendStart = 0;
            Integer offset = start + openToken.length();
            Integer end = sql.indexOf(closeToken, (int)offset);
            ArrayList<Object> olist = new ArrayList<Object>();
            while (start > 0 && end > start) {
                String name = sql.substring(offset, end);
                builder.append(sql.substring(appendStart, start));
                builder.append("?");
                if (paramtype == 1) {
                    if (!map.containsKey(name)) throw new Exception("not find " + openToken + name + closeToken + " parameter!");
                    olist.add(map.get(name));
                } else {
                    Object v = null;
                    if (!fieldMap.containsKey(name)) {
                        throw new Exception("not find " + openToken + name + closeToken + " parameter!");
                    }
                    Field field = fieldMap.get(name);
                    v = field.get(o);
                    olist.add(v);
                }
                appendStart = end + closeToken.length();
                start = sql.indexOf(openToken, (int)appendStart);
                if (start < 0) break;
                offset = start + openToken.length();
                end = sql.indexOf(closeToken, (int)offset);
            }
            if (appendStart < sql.length()) {
                builder.append(sql.substring(appendStart));
            }
            result.sql = builder.toString();
            result.param = olist.toArray();
        }
        return result;
    }

    @Override
    public int execute(String sql, Object ... param) throws Exception {
        int result = 0;
        this.open();
        if (param == null || param.length == 0) {
            try (Statement statement = this.connection.createStatement();){
                result = statement.executeUpdate(sql);
            }
        }
        SqlParamInfo sqlparam = this.getParamInfo(sql, param);
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            for (int i = 0; i < sqlparam.param.length; ++i) {
                Object o = sqlparam.param[i];
                if (o != null) {
                    Class<?> t = o.getClass();
                    TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                    handler.setParameter(statement, i + 1, o);
                    continue;
                }
                statement.setNull(i + 1, 12);
            }
            result = statement.executeUpdate();
        }
        return result;
    }

    private <T> T toModel(ResultSet resultSet, Class<T> clazz) throws Exception {
        Object m;
        boolean isBaseType = baseTypeList.contains(clazz);
        Map<String, Field> fieldMap = null;
        HashMap handerMap = null;
        ResultSetMetaData metaData = null;
        TypeHandler<T> handler = null;
        if (isBaseType) {
            handler = typeHandlerRegistry.getTypeHandler(clazz);
        } else {
            fieldMap = this.getFieldMap(clazz);
            handerMap = new HashMap();
            metaData = resultSet.getMetaData();
        }
        if (resultSet.next()) {
            if (isBaseType) {
                m = handler.getResult(resultSet, 1);
            } else {
                m = objectFactory.create(clazz);
                this.setValue(m, fieldMap, resultSet, metaData, handerMap);
            }
        } else {
            m = this.getDefault(clazz);
        }
        return (T)m;
    }

    @Override
    public <T> T queryOne(String sql, Class<T> clazz, Object ... param) throws Exception {
        this.checkModel(clazz);
        this.open();
        if (param == null || param.length == 0) {
            try (Statement statement = this.connection.createStatement();){
                T t;
                block27: {
                    ResultSet resultSet = statement.executeQuery(sql);
                    try {
                        T m;
                        t = m = this.toModel(resultSet, clazz);
                        if (resultSet == null) break block27;
                    }
                    catch (Throwable m) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                m.addSuppressed(throwable);
                            }
                        }
                        throw m;
                    }
                    resultSet.close();
                }
                return t;
            }
        }
        SqlParamInfo sqlparam = this.getParamInfo(sql, param);
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            T t;
            block28: {
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t2 = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t2);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                ResultSet resultSet = statement.executeQuery();
                try {
                    T m;
                    t = m = this.toModel(resultSet, clazz);
                    if (resultSet == null) break block28;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return t;
        }
    }

    @Override
    public <T> List<T> queryList(String sql, Class<T> clazz, Object ... param) throws Exception {
        List<T> list;
        block27: {
            list = null;
            this.checkModel(clazz);
            this.open();
            if (param == null || param.length == 0) {
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sql);){
                    list = this.toListModel(resultSet, clazz);
                    break block27;
                }
            }
            SqlParamInfo sqlparam = this.getParamInfo(sql, param);
            try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                try (ResultSet resultSet = statement.executeQuery();){
                    list = this.toListModel(resultSet, clazz);
                }
            }
        }
        return list;
    }

    private Map<String, Object> toMap(ResultSet resultSet) throws Exception {
        HashMap<String, Object> map = null;
        if (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int count = metaData.getColumnCount();
            map = new HashMap<String, Object>(count);
            for (int i = 0; i < count; ++i) {
                String name = metaData.getColumnLabel(i + 1);
                Object value = resultSet.getObject(i + 1);
                map.put(name, value);
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> queryOneMap(String sql, Object ... param) throws Exception {
        Map<String, Object> map;
        block27: {
            map = null;
            this.open();
            if (param == null || param.length == 0) {
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sql);){
                    map = this.toMap(resultSet);
                    break block27;
                }
            }
            SqlParamInfo sqlparam = this.getParamInfo(sql, param);
            try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                try (ResultSet resultSet = statement.executeQuery();){
                    map = this.toMap(resultSet);
                }
            }
        }
        return map;
    }

    private List<Map<String, Object>> toListMap(ResultSet resultSet) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>(count);
            for (int i = 0; i < count; ++i) {
                String name = metaData.getColumnLabel(i + 1);
                Object value = resultSet.getObject(i + 1);
                map.put(name, value);
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryListMap(String sql, Object ... param) throws Exception {
        List<Map<String, Object>> list;
        block27: {
            list = null;
            this.open();
            if (param == null || param.length == 0) {
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sql);){
                    list = this.toListMap(resultSet);
                    break block27;
                }
            }
            SqlParamInfo sqlparam = this.getParamInfo(sql, param);
            try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                try (ResultSet resultSet = statement.executeQuery();){
                    list = this.toListMap(resultSet);
                }
            }
        }
        return list;
    }

    private SqlParamInfo getSelectSql(Class<?> clazz, Map<String, Object> param) throws Exception {
        Map<String, Field> fieldMap = this.getFieldMap(clazz);
        SqlParamInfo result = new SqlParamInfo();
        result.sql = "SELECT ";
        fieldMap.forEach((k, v) -> {
            result.sql = result.sql + this.encodeColumn((String)k) + ", ";
        });
        result.sql = result.sql.substring(0, result.sql.length() - 2);
        result.sql = result.sql + " FROM " + this.encodeColumn(clazz.getSimpleName());
        if (param != null && param.size() > 0) {
            ArrayList arr = new ArrayList(param.size());
            result.sql = result.sql + " WHERE 1=1";
            param.forEach((k, v) -> {
                result.sql = result.sql + " AND " + this.encodeColumn((String)k) + " = ?";
                arr.add(v);
            });
            result.param = arr.toArray();
        }
        return result;
    }

    @Override
    public <TModel extends Model> TModel get(Class<TModel> clazz, Map<String, Object> param) throws Exception {
        this.checkModel(clazz);
        this.open();
        SqlParamInfo sqlparam = this.getSelectSql(clazz, param);
        if (sqlparam.param == null || sqlparam.param.length == 0) {
            try (Statement statement = this.connection.createStatement();){
                Model model;
                block27: {
                    ResultSet resultSet = statement.executeQuery(sqlparam.sql);
                    try {
                        Model m;
                        model = m = (Model)this.toModel(resultSet, clazz);
                        if (resultSet == null) break block27;
                    }
                    catch (Throwable m) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                m.addSuppressed(throwable);
                            }
                        }
                        throw m;
                    }
                    resultSet.close();
                }
                return (TModel)model;
            }
        }
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            Model model;
            block28: {
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                ResultSet resultSet = statement.executeQuery();
                try {
                    Model m;
                    model = m = (Model)this.toModel(resultSet, clazz);
                    if (resultSet == null) break block28;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return (TModel)model;
        }
    }

    @Override
    public <TModel extends Model> List<TModel> getList(Class<TModel> clazz, Map<String, Object> param) throws Exception {
        List<TModel> list;
        block27: {
            list = null;
            this.checkModel(clazz);
            this.open();
            SqlParamInfo sqlparam = this.getSelectSql(clazz, param);
            if (sqlparam.param == null || sqlparam.param.length == 0) {
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sqlparam.sql);){
                    list = this.toListModel(resultSet, clazz);
                    break block27;
                }
            }
            try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
                for (int i = 0; i < sqlparam.param.length; ++i) {
                    Object o = sqlparam.param[i];
                    if (o != null) {
                        Class<?> t = o.getClass();
                        TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                        handler.setParameter(statement, i + 1, o);
                        continue;
                    }
                    statement.setNull(i + 1, 12);
                }
                try (ResultSet resultSet = statement.executeQuery();){
                    list = this.toListModel(resultSet, clazz);
                }
            }
        }
        return list;
    }

    private SqlParamInfo getInsertSql(String table, Map<String, Object> param) throws Exception {
        if (table == null || table.isEmpty()) {
            throw new Exception("table is null!");
        }
        SqlParamInfo m = new SqlParamInfo();
        m.sql = "INSERT INTO " + this.encodeColumn(table) + "(";
        ArrayList<Object> plist = new ArrayList<Object>(param.size());
        Object vsql = "VALUES(";
        for (Map.Entry<String, Object> kv : param.entrySet()) {
            m.sql = m.sql + this.encodeColumn(kv.getKey()) + ", ";
            plist.add(kv.getValue());
            vsql = (String)vsql + "?, ";
        }
        m.sql = m.sql.substring(0, m.sql.length() - 2) + ") " + ((String)vsql).substring(0, ((String)vsql).length() - 2) + ");";
        m.param = plist.toArray();
        return m;
    }

    @Override
    public int add(String table, Map<String, Object> param) throws Exception {
        if (param == null || param.size() == 0) {
            throw new Exception("param is null!");
        }
        SqlParamInfo sqlparam = this.getInsertSql(table, param);
        int result = 0;
        this.open();
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            for (int i = 0; i < sqlparam.param.length; ++i) {
                Object o = sqlparam.param[i];
                if (o != null) {
                    Class<?> t = o.getClass();
                    TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                    handler.setParameter(statement, i + 1, o);
                    continue;
                }
                statement.setNull(i + 1, 12);
            }
            result = statement.executeUpdate();
        }
        return result;
    }

    @Override
    public <TModel extends Model> int add(TModel m, String[] ignore) throws Exception {
        if (m == null) {
            throw new Exception("m is null!");
        }
        Class<?> clazz = m.getClass();
        Map<String, Field> fieldMap = this.getFieldMap(clazz);
        if (ignore != null && ignore.length > 0) {
            for (int i = 0; i < ignore.length; ++i) {
                fieldMap.remove(ignore[i]);
            }
        }
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(fieldMap.size());
        for (Map.Entry<String, Field> kv : fieldMap.entrySet()) {
            param.put(kv.getKey(), kv.getValue().get(m));
        }
        return this.add(clazz.getSimpleName(), param);
    }

    private SqlParamInfo getUpdateSql(String table, Map<String, Object> setParam, Map<String, Object> whereParam) throws Exception {
        if (table == null || table.isEmpty()) {
            throw new Exception("table is null!");
        }
        SqlParamInfo m = new SqlParamInfo();
        m.sql = "UPDATE " + this.encodeColumn(table) + " SET ";
        ArrayList<Object> plist = new ArrayList<Object>(setParam.size() + (whereParam != null ? whereParam.size() : 0));
        for (Map.Entry<String, Object> kv : setParam.entrySet()) {
            m.sql = m.sql + this.encodeColumn(kv.getKey()) + " = ?, ";
            plist.add(kv.getValue());
        }
        m.sql = m.sql.substring(0, m.sql.length() - 2) + " WHERE 1=1";
        if (whereParam != null && whereParam.size() > 0) {
            for (Map.Entry<String, Object> kv : whereParam.entrySet()) {
                m.sql = m.sql + " AND " + this.encodeColumn(kv.getKey()) + " = ?";
                plist.add(kv.getValue());
            }
        }
        m.param = plist.toArray();
        return m;
    }

    @Override
    public int update(String table, Map<String, Object> setParam, Map<String, Object> whereParam) throws Exception {
        if (setParam == null || setParam.size() == 0) {
            throw new Exception("param is null!");
        }
        SqlParamInfo sqlparam = this.getUpdateSql(table, setParam, whereParam);
        int result = 0;
        this.open();
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            for (int i = 0; i < sqlparam.param.length; ++i) {
                Object o = sqlparam.param[i];
                if (o != null) {
                    Class<?> t = o.getClass();
                    TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                    handler.setParameter(statement, i + 1, o);
                    continue;
                }
                statement.setNull(i + 1, 12);
            }
            result = statement.executeUpdate();
        }
        return result;
    }

    @Override
    public <TModel extends Model> int update(Class<TModel> clazz, Map<String, Object> setParam, Map<String, Object> whereParam) throws Exception {
        if (clazz == null) {
            throw new Exception("T class is null!");
        }
        String table = clazz.getSimpleName();
        return this.update(table, setParam, whereParam);
    }

    private SqlParamInfo getDeleteSql(String table, Map<String, Object> whereParam) throws Exception {
        if (table == null || table.isEmpty()) {
            throw new Exception("table is null!");
        }
        SqlParamInfo m = new SqlParamInfo();
        m.sql = "DELETE FROM " + this.encodeColumn(table) + " WHERE 1=1";
        if (whereParam != null && whereParam.size() > 0) {
            ArrayList<Object> plist = new ArrayList<Object>(whereParam.size());
            if (whereParam != null && whereParam.size() > 0) {
                for (Map.Entry<String, Object> kv : whereParam.entrySet()) {
                    m.sql = m.sql + " AND " + this.encodeColumn(kv.getKey()) + " = ?";
                    plist.add(kv.getValue());
                }
            }
            m.param = plist.toArray();
        }
        return m;
    }

    @Override
    public int delete(String table, Map<String, Object> whereParam) throws Exception {
        if (table == null || table.isEmpty()) {
            throw new Exception("table is null!");
        }
        SqlParamInfo sqlparam = this.getDeleteSql(table, whereParam);
        int result = 0;
        this.open();
        try (PreparedStatement statement = this.connection.prepareStatement(sqlparam.sql);){
            for (int i = 0; i < sqlparam.param.length; ++i) {
                Object o = sqlparam.param[i];
                if (o != null) {
                    Class<?> t = o.getClass();
                    TypeHandler<?> handler = typeHandlerRegistry.getTypeHandler(t);
                    handler.setParameter(statement, i + 1, o);
                    continue;
                }
                statement.setNull(i + 1, 12);
            }
            result = statement.executeUpdate();
        }
        return result;
    }

    @Override
    public <TModel extends Model> int delete(Class<TModel> clazz, Map<String, Object> whereParam) throws Exception {
        if (clazz == null) {
            throw new Exception("T class is null!");
        }
        String table = clazz.getSimpleName();
        return this.delete(table, whereParam);
    }

    static {
        baseTypeList.add(Boolean.TYPE);
        baseTypeList.add(Byte.TYPE);
        baseTypeList.add(Short.TYPE);
        baseTypeList.add(Integer.TYPE);
        baseTypeList.add(Long.TYPE);
        baseTypeList.add(Float.TYPE);
        baseTypeList.add(Double.TYPE);
        baseTypeList.add(Character.TYPE);
        baseTypeList.add(Boolean.class);
        baseTypeList.add(Byte.class);
        baseTypeList.add(Short.class);
        baseTypeList.add(Integer.class);
        baseTypeList.add(Long.class);
        baseTypeList.add(Float.class);
        baseTypeList.add(Double.class);
        baseTypeList.add(Character.class);
        baseTypeList.add(String.class);
        baseTypeList.add(BigDecimal.class);
        baseTypeList.add(BigInteger.class);
        baseTypeList.add(java.util.Date.class);
        baseTypeList.add(ZonedDateTime.class);
        baseTypeList.add(Year.class);
        baseTypeList.add(YearMonth.class);
        baseTypeList.add(OffsetTime.class);
        baseTypeList.add(Date.class);
        baseTypeList.add(Timestamp.class);
        baseTypeList.add(Time.class);
        baseTypeList.add(Blob.class);
        baseTypeList.add(Clob.class);
        baseTypeList.add(NClob.class);
    }
}

