/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.OpWhen;
import cn.myafx.cache.base.IStringCache;
import cn.myafx.cache.base.RedisCache;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;

public class StringCache<T>
extends RedisCache
implements IStringCache<T> {
    private Class<T> clazz;

    public StringCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix, Class<T> clazz) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        this.clazz = clazz;
    }

    @Override
    public T get(Object ... args) throws Exception {
        String caheKey = this.getCacheKey(args);
        int db = this.getCacheDb(caheKey);
        this.redis.select(db);
        byte[] caheKeyBytes = this.getBytes(caheKey);
        byte[] r = this.redis.stringCommands().get(caheKeyBytes);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    private RedisStringCommands.SetOption toSetOption(OpWhen when) {
        switch (when) {
            case Exists: {
                return RedisStringCommands.SetOption.SET_IF_PRESENT;
            }
            case NotExists: {
                return RedisStringCommands.SetOption.SET_IF_ABSENT;
            }
        }
        return RedisStringCommands.SetOption.UPSERT;
    }

    @Override
    public boolean set(T m, OpWhen when, Object ... args) throws Exception {
        String caheKey = this.getCacheKey(args);
        int db = this.getCacheDb(caheKey);
        this.redis.select(db);
        byte[] caheKeyBytes = this.getBytes(caheKey);
        if (m == null) {
            this.redis.keyCommands().del((byte[][])new byte[][]{caheKeyBytes});
            return true;
        }
        Boolean r = this.redis.stringCommands().set(caheKeyBytes, this.serialize(m), Expiration.persistent(), this.toSetOption(when));
        return r == null ? false : r;
    }

    @Override
    public boolean set(T m, int expireSeconds, OpWhen when, Object ... args) throws Exception {
        String caheKey = this.getCacheKey(args);
        int db = this.getCacheDb(caheKey);
        this.redis.select(db);
        byte[] caheKeyBytes = this.getBytes(caheKey);
        if (m == null) {
            this.redis.keyCommands().del((byte[][])new byte[][]{caheKeyBytes});
            return true;
        }
        Boolean r = this.redis.stringCommands().set(caheKeyBytes, this.serialize(m), Expiration.seconds((long)expireSeconds), this.toSetOption(when));
        return r == null ? false : r;
    }

    @Override
    public long increment(long incrementValue, Object ... args) throws Exception {
        String caheKey = this.getCacheKey(args);
        int db = this.getCacheDb(caheKey);
        this.redis.select(db);
        byte[] caheKeyBytes = this.getBytes(caheKey);
        Long r = this.redis.stringCommands().incrBy(caheKeyBytes, incrementValue);
        return r == null ? 0L : r;
    }

    @Override
    public long decrement(long decrementValue, Object ... args) throws Exception {
        String caheKey = this.getCacheKey(args);
        int db = this.getCacheDb(caheKey);
        this.redis.select(db);
        byte[] caheKeyBytes = this.getBytes(caheKey);
        Long r = this.redis.stringCommands().incrBy(caheKeyBytes, -decrementValue);
        return r == null ? 0L : r;
    }
}

