/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.ExcludeType;
import cn.myafx.cache.ICacheCursor;
import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.OpWhen;
import cn.myafx.cache.Sort;
import cn.myafx.cache.SortSetModel;
import cn.myafx.cache.base.ISortSetCache;
import cn.myafx.cache.base.RedisCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

public class SortSetCache<T>
extends RedisCache
implements ISortSetCache<T> {
    private Class<T> clazz;

    public SortSetCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix, Class<T> clazz) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        this.clazz = clazz;
    }

    private RedisZSetCommands.ZAddArgs toZAddArgs(OpWhen when) {
        switch (when) {
            case Exists: {
                return RedisZSetCommands.ZAddArgs.ifExists();
            }
            case NotExists: {
                return RedisZSetCommands.ZAddArgs.ifNotExists();
            }
        }
        return RedisZSetCommands.ZAddArgs.empty();
    }

    @Override
    public boolean addOrUpdate(T value, double score, OpWhen when, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Boolean r = this.redis.zSetCommands().zAdd(cacheKeyBytes, score, this.serialize(value), this.toZAddArgs(when));
        return r != null;
    }

    @Override
    public boolean addOrUpdate(SortSetModel<T> m, OpWhen when, Object ... args) throws Exception {
        if (m == null) {
            throw new Exception("m is null!");
        }
        if (m.Value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Boolean r = this.redis.zSetCommands().zAdd(cacheKeyBytes, m.Score, this.serialize(m.Value), this.toZAddArgs(when));
        return r != null;
    }

    @Override
    public long addOrUpdate(List<SortSetModel<T>> list, OpWhen when, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        HashSet<SortSetTuple> hashset = new HashSet<SortSetTuple>(list.size());
        for (SortSetModel<T> sm : list) {
            if (sm == null) {
                throw new Exception("list item is null!");
            }
            if (sm.Value == null) {
                throw new Exception("list item.value is null!");
            }
            hashset.add(new SortSetTuple(this.serialize(sm.Value), sm.Score));
        }
        Long r = this.redis.zSetCommands().zAdd(cacheKeyBytes, hashset, this.toZAddArgs(when));
        return r == null ? 0L : r;
    }

    @Override
    public double decdrement(T value, double score, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Double r = this.redis.zSetCommands().zIncrBy(cacheKeyBytes, -score, this.serialize(value));
        return r == null ? 0.0 : r;
    }

    @Override
    public double increment(T value, double score, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Double r = this.redis.zSetCommands().zIncrBy(cacheKeyBytes, score, this.serialize(value));
        return r == null ? 0.0 : r;
    }

    @Override
    public long getCount(double minScore, double maxScore, ExcludeType excType, Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.zSetCommands().zCount(cacheKeyBytes, minScore, maxScore);
        return r == null ? 0L : r;
    }

    @Override
    public SortSetModel<T> pop(Sort sort, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Tuple r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zPopMax(cacheKeyBytes) : this.redis.zSetCommands().zPopMin(cacheKeyBytes);
        SortSetModel<T> m = null;
        if (r != null) {
            m = new SortSetModel<T>(this.deserialize(r.getValue(), this.clazz), r.getScore());
        }
        return m;
    }

    @Override
    public List<SortSetModel<T>> pop(long count, Sort sort, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (count <= 0L) {
            throw new Exception("count=" + count + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Set r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zPopMax(cacheKeyBytes, count) : this.redis.zSetCommands().zPopMin(cacheKeyBytes, count);
        ArrayList<SortSetModel<T>> list = null;
        if (r != null) {
            list = new ArrayList<SortSetModel<T>>(r.size());
            for (Tuple rt : r) {
                list.add(new SortSetModel<T>(this.deserialize(rt.getValue(), this.clazz), rt.getScore()));
            }
        }
        return list;
    }

    @Override
    public List<T> get(long start, long stop, Sort sort, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Set r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zRange(cacheKeyBytes, start, stop) : this.redis.zSetCommands().zRevRange(cacheKeyBytes, start, stop);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] rt : r) {
                list.add(this.deserialize(rt, this.clazz));
            }
        }
        return list;
    }

    @Override
    public List<SortSetModel<T>> getWithScores(long start, long stop, Sort sort, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Set r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zRangeWithScores(cacheKeyBytes, start, stop) : this.redis.zSetCommands().zRevRangeWithScores(cacheKeyBytes, start, stop);
        ArrayList<SortSetModel<T>> list = null;
        if (r != null) {
            list = new ArrayList<SortSetModel<T>>(r.size());
            for (Tuple rt : r) {
                list.add(new SortSetModel<T>(this.deserialize(rt.getValue(), this.clazz), rt.getScore()));
            }
        }
        return list;
    }

    private Range<Double> toRange(double startScore, double stopScore, ExcludeType excType) {
        Range range = null;
        switch (excType) {
            case Start: {
                range = Range.leftOpen((Object)startScore, (Object)stopScore);
                break;
            }
            case Stop: {
                range = Range.rightOpen((Object)startScore, (Object)stopScore);
                break;
            }
            case Both: {
                range = Range.open((Object)startScore, (Object)stopScore);
                break;
            }
            default: {
                range = Range.closed((Object)startScore, (Object)stopScore);
            }
        }
        return range;
    }

    @Override
    public List<T> getByScore(double startScore, double stopScore, ExcludeType excType, Sort sort, int skip, int take, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (skip < 0) {
            throw new Exception("skip=" + skip + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Range<Double> range = this.toRange(startScore, stopScore, excType);
        Limit limit = Limit.limit().offset(skip).count(take);
        Set r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zRangeByScore(cacheKeyBytes, range, limit) : this.redis.zSetCommands().zRevRangeByScore(cacheKeyBytes, range, limit);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] rt : r) {
                list.add(this.deserialize(rt, this.clazz));
            }
        }
        return list;
    }

    @Override
    public List<SortSetModel<T>> getByScoreWithScores(double startScore, double stopScore, ExcludeType excType, Sort sort, int skip, int take, Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (skip < 0) {
            throw new Exception("skip=" + skip + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Range<Double> range = this.toRange(startScore, stopScore, excType);
        Limit limit = Limit.limit().offset(skip).count(take);
        Set r = null;
        r = sort == Sort.Asc ? this.redis.zSetCommands().zRangeByScoreWithScores(cacheKeyBytes, range, limit) : this.redis.zSetCommands().zRevRangeByScoreWithScores(cacheKeyBytes, range, limit);
        ArrayList<SortSetModel<T>> list = null;
        if (r != null) {
            list = new ArrayList<SortSetModel<T>>(r.size());
            for (Tuple rt : r) {
                list.add(new SortSetModel<T>(this.deserialize(rt.getValue(), this.clazz), rt.getScore()));
            }
        }
        return list;
    }

    @Override
    public boolean delete(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.zSetCommands().zRem(cacheKeyBytes, (byte[][])new byte[][]{this.serialize(value)});
        return r != null && r > 0L;
    }

    @Override
    public long delete(List<T> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        byte[][] arr = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            T m = list.get(i);
            if (m == null) {
                throw new Exception("list item is null!");
            }
            arr[i] = this.serialize(m);
        }
        Long r = this.redis.zSetCommands().zRem(cacheKeyBytes, (byte[][])arr);
        return r == null ? 0L : r;
    }

    @Override
    public long delete(long start, long stop, Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.zSetCommands().zRemRange(cacheKeyBytes, start, stop);
        return r == null ? 0L : r;
    }

    @Override
    public long deleteByScore(double startScore, double stopScore, ExcludeType excType, Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.zSetCommands().zRemRangeByScore(cacheKeyBytes, this.toRange(startScore, stopScore, excType));
        return r == null ? 0L : r;
    }

    @Override
    public ICacheCursor<SortSetModel<T>> scan(String pattern, int pageSize, Object ... args) throws Exception {
        if (pattern == null || pattern.isEmpty()) {
            throw new Exception("pattern is null!");
        }
        if (pageSize <= 0) {
            throw new Exception("pageSize=" + pageSize + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        ScanOptions.ScanOptionsBuilder opbu = ScanOptions.scanOptions().match(pattern).count((long)pageSize);
        Cursor r = this.redis.zSetCommands().zScan(cacheKeyBytes, opbu.build());
        return new SortSetCursor((Cursor<Tuple>)r, this.clazz);
    }

    public class SortSetTuple
    implements Tuple {
        private byte[] value;
        private Double score;

        public SortSetTuple(byte[] value, Double score) {
            this.value = value;
            this.score = score;
        }

        public int compareTo(Double arg0) {
            return (int)(this.score - arg0);
        }

        public byte[] getValue() {
            return this.value;
        }

        public Double getScore() {
            return this.score;
        }
    }

    public class SortSetCursor
    implements ICacheCursor<SortSetModel<T>> {
        private Cursor<Tuple> cursor;
        private Class<T> valueClazz;

        public SortSetCursor(Cursor<Tuple> cursor, Class<T> valueClazz) {
            this.cursor = cursor;
            this.valueClazz = valueClazz;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
                this.valueClazz = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public SortSetModel<T> next() {
            Tuple tp = (Tuple)this.cursor.next();
            try {
                Object v = SortSetCache.this.deserialize(tp.getValue(), this.valueClazz);
                return new SortSetModel(v, tp.getScore());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

