/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.ICacheCursor;
import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.SetOp;
import cn.myafx.cache.base.ISetCache;
import cn.myafx.cache.base.RedisCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

public class SetCache<T>
extends RedisCache
implements ISetCache<T> {
    private Class<T> clazz;

    public SetCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix, Class<T> clazz) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        this.clazz = clazz;
    }

    @Override
    public boolean add(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.setCommands().sAdd(cacheKeyBytes, (byte[][])new byte[][]{this.serialize(value)});
        return r != null && r > 0L;
    }

    @Override
    public long add(List<T> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        byte[][] arr = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            T m = list.get(i);
            if (m == null) {
                throw new Exception("list item is null!");
            }
            arr[i] = this.serialize(m);
        }
        Long r = this.redis.setCommands().sAdd(cacheKeyBytes, (byte[][])arr);
        return r == null ? 0L : r;
    }

    @Override
    public List<T> get(Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Set r = this.redis.setCommands().sMembers(cacheKeyBytes);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.clazz));
            }
        }
        return list;
    }

    @Override
    public List<T> join(Object[] firstArgs, Object[] secondArgs, SetOp op) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String firstCachekey = this.getCacheKey(firstArgs);
        String secondCachekey = this.getCacheKey(secondArgs);
        int db = this.getCacheDb(firstCachekey);
        this.redis.select(db);
        byte[] firstCachekeyBytes = this.getBytes(firstCachekey);
        byte[] secondCachekeyBytes = this.getBytes(secondCachekey);
        ArrayList<T> list = null;
        Set r = null;
        switch (op) {
            case Union: {
                r = this.redis.setCommands().sUnion((byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
                break;
            }
            case Intersect: {
                r = this.redis.setCommands().sInter((byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
                break;
            }
            case Difference: {
                r = this.redis.setCommands().sDiff((byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
            }
        }
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.clazz));
            }
        }
        return list;
    }

    @Override
    public long joinAndAdd(Object[] addArgs, Object[] firstArgs, Object[] secondArgs, SetOp op) throws Exception {
        String addCachekey = this.getCacheKey(addArgs);
        String firstCachekey = this.getCacheKey(firstArgs);
        String secondCachekey = this.getCacheKey(secondArgs);
        int db = this.getCacheDb(firstCachekey);
        this.redis.select(db);
        byte[] addCachekeyBytes = this.getBytes(addCachekey);
        byte[] firstCachekeyBytes = this.getBytes(firstCachekey);
        byte[] secondCachekeyBytes = this.getBytes(secondCachekey);
        Long r = null;
        switch (op) {
            case Union: {
                r = this.redis.setCommands().sUnionStore(addCachekeyBytes, (byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
                break;
            }
            case Intersect: {
                r = this.redis.setCommands().sInterStore(addCachekeyBytes, (byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
                break;
            }
            case Difference: {
                r = this.redis.setCommands().sDiffStore(addCachekeyBytes, (byte[][])new byte[][]{firstCachekeyBytes, secondCachekeyBytes});
            }
        }
        return r == null ? 0L : r;
    }

    @Override
    public boolean exist(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Boolean r = this.redis.setCommands().sIsMember(cacheKeyBytes, this.serialize(value));
        return r == null ? false : r;
    }

    @Override
    public long getCount(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.setCommands().sCard(cacheKeyBytes);
        return r == null ? 0L : r;
    }

    @Override
    public boolean move(Object[] sourceArgs, Object[] desArgs, T value) throws Exception {
        String sourceCachekey = this.getCacheKey(sourceArgs);
        String desCachekey = this.getCacheKey(desArgs);
        int db = this.getCacheDb(sourceCachekey);
        this.redis.select(db);
        byte[] sourceCachekeyBytes = this.getBytes(sourceCachekey);
        byte[] desCachekeyBytes = this.getBytes(desCachekey);
        Boolean r = this.redis.setCommands().sMove(sourceCachekeyBytes, desCachekeyBytes, this.serialize(value));
        return r == null ? false : r;
    }

    @Override
    public T pop(Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.setCommands().sPop(cacheKeyBytes);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    @Override
    public List<T> pop(int count, Object ... args) throws Exception {
        if (count <= 0) {
            throw new Exception("count=" + count + " is error!");
        }
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        List r = this.redis.setCommands().sPop(cacheKeyBytes, (long)count);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.clazz));
            }
        }
        return list;
    }

    @Override
    public T getRandomValue(Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.setCommands().sRandMember(cacheKeyBytes);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    @Override
    public List<T> getRandomValue(int count, Object ... args) throws Exception {
        if (count <= 0) {
            throw new Exception("count=" + count + " is error!");
        }
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        List r = this.redis.setCommands().sRandMember(cacheKeyBytes, (long)count);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.clazz));
            }
        }
        return list;
    }

    @Override
    public boolean delete(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        Long r = this.redis.setCommands().sRem(cacheKeyBytes, (byte[][])new byte[][]{this.serialize(value)});
        return r != null && r > 0L;
    }

    @Override
    public long delete(List<T> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        byte[][] arr = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            T m = list.get(i);
            if (m == null) {
                throw new Exception("list item is null!");
            }
            arr[i] = this.serialize(m);
        }
        Long r = this.redis.setCommands().sRem(cacheKeyBytes, (byte[][])arr);
        return r == null ? 0L : r;
    }

    @Override
    public ICacheCursor<T> scan(String pattern, int count, Object ... args) throws Exception {
        if (pattern == null || pattern.isEmpty()) {
            throw new Exception("pattern is null!");
        }
        if (count <= 0) {
            throw new Exception("count=" + count + " is error!");
        }
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cacheKeyBytes = this.getBytes(cachekey);
        ScanOptions.ScanOptionsBuilder opbu = ScanOptions.scanOptions().count((long)count).match(this.getBytes(pattern));
        Cursor r = this.redis.setCommands().sScan(cacheKeyBytes, opbu.build());
        return new SetCursor((Cursor<byte[]>)r, this.clazz);
    }

    public class SetCursor
    implements ICacheCursor<T> {
        private Cursor<byte[]> cursor;
        private Class<T> valueClazz;

        public SetCursor(Cursor<byte[]> cursor, Class<T> valueClazz) {
            this.cursor = cursor;
            this.valueClazz = valueClazz;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
                this.valueClazz = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public T next() {
            byte[] buffer = (byte[])this.cursor.next();
            try {
                Object v = SetCache.this.deserialize(buffer, this.valueClazz);
                return v;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

