/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.CacheKeyConfig;
import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.IJsonMapper;
import cn.myafx.cache.base.BaseCache;
import cn.myafx.cache.base.IRedisCache;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnection;

public class RedisCache
extends BaseCache
implements IRedisCache {
    public static IJsonMapper DefaultJsonMapper;
    protected IJsonMapper mapper = DefaultJsonMapper;
    protected RedisConnection redis;
    protected CacheKeyConfig keyConfig;
    protected String prefix;
    protected String nodeName;

    public RedisCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix) throws Exception {
        if (DefaultJsonMapper == null) {
            throw new Exception("RedisCache.DefaultJsonMapper is null !");
        }
        if (node == null || node.isEmpty()) {
            throw new Exception("node is null !");
        }
        if (item == null || item.isEmpty()) {
            throw new Exception("item is null !");
        }
        if (redisConnection == null) {
            throw new Exception("redis is null !");
        }
        if (cacheKey == null) {
            throw new Exception("cacheKey is null !");
        }
        this.keyConfig = cacheKey.get(node, item);
        if (this.keyConfig == null) {
            throw new Exception(node + "/" + item + " \u672a\u914d\u7f6e\uff01");
        }
        this.redis = redisConnection;
        this.prefix = prefix != null ? prefix : "";
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : this.keyConfig.Node.toCharArray()) {
            if ('A' <= c && c <= 'Z') {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("_");
                }
                stringBuilder.append((char)(c + 32));
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append(":");
        this.nodeName = stringBuilder.toString();
    }

    @Override
    public void setJsonMapper(IJsonMapper mapper) {
        if (mapper != null) {
            this.mapper = mapper;
        }
    }

    protected Object getDefault(Class<?> clazz) throws Exception {
        Comparable<Boolean> obj = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                obj = false;
            } else if (clazz == Character.TYPE) {
                obj = Character.valueOf('\u0000');
            } else if (clazz == Byte.TYPE) {
                obj = (byte)0;
            } else if (clazz == Short.TYPE) {
                obj = (short)0;
            } else if (clazz == Integer.TYPE) {
                obj = 0;
            } else if (clazz == Long.TYPE) {
                obj = 0L;
            } else if (clazz == Float.TYPE) {
                obj = Float.valueOf(0.0f);
            } else if (clazz == Double.TYPE) {
                obj = 0.0;
            }
        }
        return obj;
    }

    protected byte[] getBytes(String cachekey) throws Exception {
        if (cachekey == null) {
            return null;
        }
        return cachekey.getBytes("utf-8");
    }

    protected String getString(byte[] buffer) throws Exception {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        return new String(buffer, "utf-8");
    }

    protected byte[] serialize(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return buf;
        }
        String json = this.mapper.serialize(value);
        return this.getBytes(json);
    }

    protected <T> T deserialize(byte[] buffer, Class<T> clazz) throws Exception {
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (clazz == byte[].class) {
            byte[] obj = buffer;
            return (T)obj;
        }
        String json = this.getString(buffer);
        if (clazz == String.class) {
            String obj = json;
            return (T)obj;
        }
        if (json == null || json.isEmpty()) {
            return (T)this.getDefault(clazz);
        }
        T m = this.mapper.deserialize(json, clazz);
        return m;
    }

    @Override
    public CacheKeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    @Override
    public String getCacheKey(Object[] args) throws Exception {
        if (this.keyConfig.Key == null || this.keyConfig.Key.isEmpty()) {
            throw new Exception("cache key(Node=" + this.keyConfig.Node + ", Item=" + this.keyConfig.Item + ") is null!");
        }
        Object key = this.keyConfig.Key;
        if (args != null && args.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o instanceof Enum) {
                    Enum e = (Enum)o;
                    o = e.ordinal();
                }
                stringBuilder.append(":" + (o == null ? "null" : o.toString().toLowerCase()));
            }
            key = (String)key + stringBuilder.toString();
        }
        return this.prefix + this.nodeName + (String)key;
    }

    @Override
    public int getCacheDb(String cachekey) {
        List<Integer> list = this.keyConfig.Db;
        if (list == null || list.size() == 0) {
            return 0;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int hash = 0;
        for (char c : cachekey.toCharArray()) {
            if ((hash += c) <= 255) continue;
            hash %= 255;
        }
        Integer db = list.get(hash % list.size());
        return db == null ? 0 : db;
    }

    @Override
    public boolean remove(Object[] args) throws Exception {
        String key = this.getCacheKey(args);
        int db = this.getCacheDb(key);
        this.redis.select(db);
        Long r = this.redis.keyCommands().del((byte[][])new byte[][]{this.getBytes(key)});
        return r != null && r > 0L;
    }

    @Override
    public boolean contains(Object[] args) throws Exception {
        String key = this.getCacheKey(args);
        int db = this.getCacheDb(key);
        this.redis.select(db);
        Boolean r = this.redis.keyCommands().exists(this.getBytes(key));
        return r == null ? false : r;
    }

    @Override
    public boolean expire(Integer expireSeconds, Object[] args) throws Exception {
        String key = this.getCacheKey(args);
        int db = this.getCacheDb(key);
        this.redis.select(db);
        Boolean r = expireSeconds != null && expireSeconds > 0 ? this.redis.keyCommands().expire(this.getBytes(key), (long)expireSeconds.intValue()) : this.redis.keyCommands().persist(this.getBytes(key));
        return r == null ? false : r;
    }

    @Override
    public boolean expire(Object[] args) throws Exception {
        return this.expire(this.keyConfig.Expire, args);
    }

    @Override
    public String ping() {
        return this.redis.ping();
    }

    @Override
    public void close() throws Exception {
        this.keyConfig = null;
        this.nodeName = null;
        this.redis = null;
        this.prefix = null;
        this.mapper = null;
    }
}

