/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.base.ILinkListCache;
import cn.myafx.cache.base.RedisCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;

public class LinkListCache<T>
extends RedisCache
implements ILinkListCache<T> {
    private Class<T> clazz;

    public LinkListCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix, Class<T> clazz) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        this.clazz = clazz;
    }

    @Override
    public long pushLeft(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().lPush(cachekeyBytes, (byte[][])new byte[][]{this.serialize(value)});
        return r == null ? -1L : r;
    }

    @Override
    public long pushLeft(List<T> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[][] arr = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            T v = list.get(i);
            if (v == null) {
                throw new Exception("list item is null!");
            }
            arr[i] = this.serialize(v);
        }
        Long r = this.redis.listCommands().lPush(cachekeyBytes, (byte[][])arr);
        return r == null ? -1L : r;
    }

    @Override
    public long pushRight(T value, Object ... args) throws Exception {
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().rPush(cachekeyBytes, (byte[][])new byte[][]{this.serialize(value)});
        return r == null ? -1L : r;
    }

    @Override
    public long pushRight(List<T> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[][] arr = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            T v = list.get(i);
            if (v == null) {
                throw new Exception("list item is null!");
            }
            arr[i] = this.serialize(v);
        }
        Long r = this.redis.listCommands().rPush(cachekeyBytes, (byte[][])arr);
        return r == null ? -1L : r;
    }

    @Override
    public T get(long index, Object ... args) throws Exception {
        if (index < 0L) {
            throw new Exception("index = " + index + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.listCommands().lIndex(cachekeyBytes, index);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    @Override
    public List<T> getRange(long start, long stop, Object ... args) throws Exception {
        if (start < 0L) {
            throw new Exception("start = " + start + " is error!");
        }
        if (stop != -1L && stop < start) {
            throw new Exception("stop = " + stop + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        List r = this.redis.listCommands().lRange(cachekeyBytes, start, stop);
        ArrayList<T> list = null;
        if (r != null) {
            list = new ArrayList<T>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.clazz));
            }
        }
        return list;
    }

    @Override
    public long insertAfter(T pivot, T value, Object ... args) throws Exception {
        if (pivot == null) {
            throw new Exception("pivot is null!");
        }
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().lInsert(cachekeyBytes, RedisListCommands.Position.AFTER, this.serialize(pivot), this.serialize(value));
        return r == null ? -1L : r;
    }

    @Override
    public long insertBefore(T pivot, T value, Object ... args) throws Exception {
        if (pivot == null) {
            throw new Exception("pivot is null!");
        }
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().lInsert(cachekeyBytes, RedisListCommands.Position.BEFORE, this.serialize(pivot), this.serialize(value));
        return r == null ? -1L : r;
    }

    @Override
    public T popLeft(Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.listCommands().lPop(cachekeyBytes);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    @Override
    public T popRight(Object ... args) throws Exception {
        if (this.clazz == null) {
            throw new Exception("clazz is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.listCommands().rPop(cachekeyBytes);
        T m = this.deserialize(r, this.clazz);
        return m;
    }

    @Override
    public boolean update(long index, T value, Object ... args) throws Exception {
        if (index < 0L) {
            throw new Exception("index=" + index + " is error!");
        }
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        this.redis.listCommands().lSet(cachekeyBytes, index, this.serialize(value));
        return true;
    }

    @Override
    public long delete(T value, long count, Object ... args) throws Exception {
        if (count < 0L) {
            throw new Exception("count=" + count + " is error!");
        }
        if (value == null) {
            throw new Exception("value is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().lRem(cachekeyBytes, count, this.serialize(value));
        return r == null ? -1L : r;
    }

    @Override
    public void trim(long start, long stop, Object ... args) throws Exception {
        if (start < 0L) {
            throw new Exception("start=" + start + " is error!");
        }
        if (stop < start) {
            throw new Exception("stop=" + stop + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        this.redis.listCommands().lTrim(cachekeyBytes, start, stop);
    }

    @Override
    public long getCount(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.listCommands().lLen(cachekeyBytes);
        return r == null ? 0L : r;
    }
}

