/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache;

import org.springframework.data.geo.Point;

public final class GeoPos {
    public final double Lon;
    public final double Lat;

    public GeoPos(double lon, double lat) throws Exception {
        if (lat < -90.0 || lat > 90.0) {
            throw new Exception("lat = " + lat + " is error!");
        }
        if (lon < -180.0 || lon > 180.0) {
            throw new Exception("lon = " + lon + " is error!");
        }
        this.Lat = lat;
        this.Lon = lon;
    }

    public double toX() {
        return this.Lon;
    }

    public double toY() {
        return this.Lat;
    }

    public Point toPoint() {
        return new Point(this.toX(), this.toY());
    }

    public static Point toPoint(double lon, double lat) throws Exception {
        if (lat < -90.0 || lat > 90.0) {
            throw new Exception("lat = " + lat + " is error!");
        }
        if (lon < -180.0 || lon > 180.0) {
            throw new Exception("lon = " + lon + " is error!");
        }
        return new Point(lon, lat);
    }

    public static GeoPos toGeoPos(Point point) throws Exception {
        if (point == null) {
            return null;
        }
        return new GeoPos(point.getX(), point.getY());
    }
}

