/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache;

import cn.myafx.cache.CacheKeyConfig;
import cn.myafx.cache.ICacheKey;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheKey
implements ICacheKey {
    private ArrayList<CacheKeyConfig> list;

    public CacheKey() throws Exception {
        String xmlFile = System.getenv("xmlCacheKeyFile");
        if (xmlFile == null || xmlFile.isEmpty()) {
            xmlFile = "cache-key.xml";
        }
        this.load(xmlFile);
    }

    public CacheKey(String xmlFile) throws Exception {
        if (xmlFile == null || xmlFile.isEmpty()) {
            throw new Exception("cache-key.xml is not found!");
        }
        this.load(xmlFile);
    }

    public CacheKey(URL url) throws Exception {
        if (url == null) {
            throw new Exception("url is null!");
        }
        try (InputStream stream = url.openStream();){
            this.load(stream);
        }
    }

    public CacheKey(InputStream stream) throws Exception {
        this.load(stream);
    }

    private static List<Integer> getDbList(String val) {
        ArrayList<Integer> list = null;
        if (val != null && !val.isEmpty()) {
            list = new ArrayList<Integer>();
            String[] arr = val.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String ss = arr[i].trim();
                if (ss == null || ss.isEmpty()) continue;
                if (ss.contains("-")) {
                    String[] ssarr = ss.split("-");
                    if (ssarr.length != 2) continue;
                    String bs = ssarr[0].trim();
                    String es = ssarr[1].trim();
                    int bv = 0;
                    int ev = 0;
                    try {
                        bv = Integer.parseInt(bs);
                        ev = Integer.parseInt(es);
                        if (bv > ev) continue;
                        while (bv < ev) {
                            list.add(bv++);
                        }
                        list.add(ev);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    int v = Integer.parseInt(ss);
                    list.add(v);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            list.trimToSize();
        }
        return list;
    }

    private static Integer parseExpire(String str) {
        Integer expire = null;
        if (str != null && !str.isEmpty()) {
            String[] arr = str.split(":");
            for (int j = 0; j < arr.length / 2; ++j) {
                String v = arr[arr.length - j - 1];
                arr[arr.length - j - 1] = arr[j];
                arr[j] = v;
            }
            try {
                Integer v = Integer.parseInt(arr[0]);
                if (arr.length > 1) {
                    v = v + Integer.parseInt(arr[1]) * 60;
                }
                if (arr.length > 2) {
                    v = v + Integer.parseInt(arr[2]) * 60 * 60;
                }
                if (arr.length > 3) {
                    v = v + Integer.parseInt(arr[3]) * 60 * 60 * 24;
                }
                expire = v;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expire;
    }

    private void load(Document doc) throws Exception {
        Element rootElement = doc.getDocumentElement();
        NodeList nodes = rootElement.getChildNodes();
        this.list = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element node = (Element)n;
            List<Integer> node_db = CacheKey.getDbList(node.getAttribute("db"));
            if (node_db == null) {
                node_db = new ArrayList<Integer>(0);
            }
            Integer node_expire = CacheKey.parseExpire(node.getAttribute("expire"));
            NodeList child = node.getChildNodes();
            for (int j = 0; j < child.getLength(); ++j) {
                Integer expire;
                Node in = child.item(j);
                if (!(in instanceof Element)) continue;
                Element item = (Element)in;
                String key = item.getAttribute("key");
                List<Integer> db = CacheKey.getDbList(item.getAttribute("db"));
                if (db == null) {
                    db = node_db;
                }
                if ((expire = CacheKey.parseExpire(item.getAttribute("expire"))) == null) {
                    expire = node_expire;
                }
                this.list.add(new CacheKeyConfig(node.getNodeName(), item.getNodeName(), key, expire, db));
            }
        }
        this.list.trimToSize();
    }

    private void load(String xmlFile) throws Exception {
        File f = new File(xmlFile);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("xmlFile(" + xmlFile + ") not found!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(f);
        this.load(doc);
    }

    private void load(InputStream stream) throws Exception {
        if (stream == null) {
            throw new Exception("stream is null!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(stream);
        this.load(doc);
    }

    @Override
    public CacheKeyConfig get(String node, String item) {
        CacheKeyConfig m = null;
        for (CacheKeyConfig q : this.list) {
            if (q.Node != node || q.Item != item) continue;
            m = q;
            break;
        }
        return m;
    }

    @Override
    public String getKey(String node, String item) {
        CacheKeyConfig m = this.get(node, item);
        return m != null ? m.Key : null;
    }

    @Override
    public Integer getExpire(String node, String item) {
        CacheKeyConfig m = this.get(node, item);
        return m != null ? m.Expire : null;
    }

    @Override
    public List<Integer> getDb(String node, String item) {
        CacheKeyConfig m = this.get(node, item);
        return m != null ? m.Db : null;
    }
}

